// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.programStrategy;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * La stratégie définit a priori ce que devront être les données présentes dans le système de
 * l'origine de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que
 * des méthodes préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la
 * saisie des données, en personnalisant les écrans, et facilite la consultation rapide du contenu
 * théorique de la base.
 * Par exemple, on pourra avoir les stratégies suivantes :
 * - stratégie "échantillonnage pendant les marées observées"
 * - stratégie "échantillonnage pendant les campagne à la mer"
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Strategy
    implements Serializable, Comparable<Strategy>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 3391613597864647219L;

    // Generate 5 attributes
    private Integer id;

    /**
     * Identifiant interne. généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne. généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 6 associations
    private Collection<ReferenceTaxonStrategy> referenceTaxonStrategies = new HashSet<ReferenceTaxonStrategy>();

    /**
     * Définit les Taxons relatifs à une stratégie de collecte, éventuellement le niveau de priorité
     * de la
     * collecte sur le Taxon.
     * @return this.referenceTaxonStrategies Collection<ReferenceTaxonStrategy>
     */
    public Collection<ReferenceTaxonStrategy> getReferenceTaxonStrategies()
    {
        return this.referenceTaxonStrategies;
    }

    /**
     * Définit les Taxons relatifs à une stratégie de collecte, éventuellement le niveau de priorité
     * de la
     * collecte sur le Taxon.
     * @param referenceTaxonStrategiesIn Collection<ReferenceTaxonStrategy>
     */
    public void setReferenceTaxonStrategies(Collection<ReferenceTaxonStrategy> referenceTaxonStrategiesIn)
    {
        this.referenceTaxonStrategies = referenceTaxonStrategiesIn;
    }

    /**
     * Définit les Taxons relatifs à une stratégie de collecte, éventuellement le niveau de priorité
     * de la
     * collecte sur le Taxon.
     * @param elementToAdd ReferenceTaxonStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addReferenceTaxonStrategies(ReferenceTaxonStrategy elementToAdd)
    {
        return this.referenceTaxonStrategies.add(elementToAdd);
    }

    /**
     * Définit les Taxons relatifs à une stratégie de collecte, éventuellement le niveau de priorité
     * de la
     * collecte sur le Taxon.
     * @param elementToRemove ReferenceTaxonStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeReferenceTaxonStrategies(ReferenceTaxonStrategy elementToRemove)
    {
        return this.referenceTaxonStrategies.remove(elementToRemove);
    }

    private Collection<Person> managersUsers = new HashSet<Person>();

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.managersUsers Collection<Person>
     */
    public Collection<Person> getManagersUsers()
    {
        return this.managersUsers;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param managersUsersIn Collection<Person>
     */
    public void setManagersUsers(Collection<Person> managersUsersIn)
    {
        this.managersUsers = managersUsersIn;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToAdd Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addManagersUsers(Person elementToAdd)
    {
        return this.managersUsers.add(elementToAdd);
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToRemove Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeManagersUsers(Person elementToRemove)
    {
        return this.managersUsers.remove(elementToRemove);
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Collection<PmfmStrategy> pmfmStrategies = new HashSet<PmfmStrategy>();

    /**
     * 
     * @return this.pmfmStrategies Collection<PmfmStrategy>
     */
    public Collection<PmfmStrategy> getPmfmStrategies()
    {
        return this.pmfmStrategies;
    }

    /**
     * 
     * @param pmfmStrategiesIn Collection<PmfmStrategy>
     */
    public void setPmfmStrategies(Collection<PmfmStrategy> pmfmStrategiesIn)
    {
        this.pmfmStrategies = pmfmStrategiesIn;
    }

    /**
     * 
     * @param elementToAdd PmfmStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addPmfmStrategies(PmfmStrategy elementToAdd)
    {
        return this.pmfmStrategies.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove PmfmStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removePmfmStrategies(PmfmStrategy elementToRemove)
    {
        return this.pmfmStrategies.remove(elementToRemove);
    }

    private Collection<AppliedStrategy> appliedStrategies = new HashSet<AppliedStrategy>();

    /**
     * Une stratégie applicable est la stratégie qui s'applique pour un lieu de surveillance donné
     * durant
     * un interval de dates défini.
     * @return this.appliedStrategies Collection<AppliedStrategy>
     */
    public Collection<AppliedStrategy> getAppliedStrategies()
    {
        return this.appliedStrategies;
    }

    /**
     * Une stratégie applicable est la stratégie qui s'applique pour un lieu de surveillance donné
     * durant
     * un interval de dates défini.
     * @param appliedStrategiesIn Collection<AppliedStrategy>
     */
    public void setAppliedStrategies(Collection<AppliedStrategy> appliedStrategiesIn)
    {
        this.appliedStrategies = appliedStrategiesIn;
    }

    /**
     * Une stratégie applicable est la stratégie qui s'applique pour un lieu de surveillance donné
     * durant
     * un interval de dates défini.
     * @param elementToAdd AppliedStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addAppliedStrategies(AppliedStrategy elementToAdd)
    {
        return this.appliedStrategies.add(elementToAdd);
    }

    /**
     * Une stratégie applicable est la stratégie qui s'applique pour un lieu de surveillance donné
     * durant
     * un interval de dates défini.
     * @param elementToRemove AppliedStrategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeAppliedStrategies(AppliedStrategy elementToRemove)
    {
        return this.appliedStrategies.remove(elementToRemove);
    }

    private Collection<Gear> gears = new HashSet<Gear>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @return this.gears Collection<Gear>
     */
    public Collection<Gear> getGears()
    {
        return this.gears;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param gearsIn Collection<Gear>
     */
    public void setGears(Collection<Gear> gearsIn)
    {
        this.gears = gearsIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Gear
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGears(Gear elementToAdd)
    {
        return this.gears.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Gear
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGears(Gear elementToRemove)
    {
        return this.gears.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Strategy instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Strategy))
        {
            return false;
        }
        final Strategy that = (Strategy)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Strategy}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Strategy}.
         * @return new StrategyImpl()
         */
        public static Strategy newInstance()
        {
            return new StrategyImpl();
        }

        /**
         * Constructs a new instance of {@link Strategy}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param managersUsers Collection<Person>
         * @param program Program
         * @return newInstance
         */
        public static Strategy newInstance(String name, String description, Date creationDate, Collection<Person> managersUsers, Program program)
        {
            final Strategy entity = new StrategyImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setManagersUsers(managersUsers);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Strategy}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param referenceTaxonStrategies Collection<ReferenceTaxonStrategy>
         * @param managersUsers Collection<Person>
         * @param program Program
         * @param pmfmStrategies Collection<PmfmStrategy>
         * @param appliedStrategies Collection<AppliedStrategy>
         * @param gears Collection<Gear>
         * @return newInstance Strategy
         */
        public static Strategy newInstance(String name, String description, Date creationDate, Timestamp updateDate, Collection<ReferenceTaxonStrategy> referenceTaxonStrategies, Collection<Person> managersUsers, Program program, Collection<PmfmStrategy> pmfmStrategies, Collection<AppliedStrategy> appliedStrategies, Collection<Gear> gears)
        {
            final Strategy entity = new StrategyImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setReferenceTaxonStrategies(referenceTaxonStrategies);
            entity.setManagersUsers(managersUsers);
            entity.setProgram(program);
            entity.setPmfmStrategies(pmfmStrategies);
            entity.setAppliedStrategies(appliedStrategies);
            entity.setGears(gears);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Strategy o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Strategy.java merge-point
}