/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.QueryParameters;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceGraph;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.RelayReferenceNode;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class PojoQuery {
    private String version;
    private String dataSetClass;
    private String appContextKey;
    private List<IColumnsMapping> mappings = new ArrayList<IColumnsMapping>();
    private ReferenceGraph rg;
    private QueryParameters qps;

    public PojoQuery(String version, String dataSetClass, String appContextKey) {
        this.version = version;
        this.dataSetClass = dataSetClass;
        this.appContextKey = appContextKey;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataSetClass() {
        return this.dataSetClass;
    }

    public void setDataSetClass(String dataSetClass) {
        this.dataSetClass = dataSetClass;
    }

    public String getAppContextKey() {
        return this.appContextKey;
    }

    public void setAppContextKey(String appContextKey) {
        this.appContextKey = appContextKey;
    }

    public void addColumnsMapping(IColumnsMapping mapping) {
        if (mapping == null) {
            throw new NullPointerException("mapping is null");
        }
        this.mappings.add(mapping);
    }

    public IColumnsMapping[] getColumnsMappings() {
        return this.mappings.toArray(new IColumnsMapping[0]);
    }

    public ReferenceGraph getReferenceGraph() {
        if (this.rg == null) {
            this.rg = ReferenceGraph.create(this);
        }
        return this.rg;
    }

    public void clearColumnMappings() {
        this.mappings.clear();
    }

    public QueryParameters getQueryParameters() throws OdaException {
        if (this.qps == null) {
            this.qps = QueryParameters.create(this);
        }
        return this.qps;
    }

    public void prepareParameterValues(Map<String, Object> inputValues, ClassLoader pojoClassLoader) throws OdaException {
        ReferenceNode[] referenceNodeArray = this.getReferenceGraph().getRoots();
        int n = referenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceNode rn = referenceNodeArray[n2];
            PojoQuery.prepareParameterValues(rn, inputValues, pojoClassLoader);
            ++n2;
        }
    }

    private static void prepareParameterValues(ReferenceNode rn, Map<String, Object> inputValues, ClassLoader pojoClassLoader) throws OdaException {
        rn.getReference().prepareParameterValues(inputValues, pojoClassLoader);
        if (rn instanceof RelayReferenceNode) {
            RelayReferenceNode rrn = (RelayReferenceNode)rn;
            ReferenceNode[] referenceNodeArray = rrn.getChildren();
            int n = referenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceNode child = referenceNodeArray[n2];
                PojoQuery.prepareParameterValues(child, inputValues, pojoClassLoader);
                ++n2;
            }
        }
    }
}

