/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.liquibase;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.config.AdagioConfigurationOption;
import fr.ifremer.adagio.core.dao.technical.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.DatabaseObjectFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component(value="liquibase")
@Lazy
public class Liquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected static final String CHANGE_LOG_SNAPSHOT_SUFFIX = "-SNAPSHOT.xml";
    private String beanName;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private AdagioConfiguration config;
    private String changeLog;
    private String defaultSchema;
    private String contexts;
    private Map<String, String> parameters;
    protected Version maxChangeLogFileVersion;

    @Autowired
    public Liquibase(DataSource dataSource, AdagioConfiguration config) {
        this.dataSource = dataSource;
        this.config = config;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        this.setChangeLog(this.config.getLiquibaseChangeLogPath());
        this.computeMaxChangeLogFileVersion();
        boolean shouldRun = AdagioConfiguration.getInstance().useLiquibaseAutoRun();
        if (!shouldRun) {
            this.getLog().debug("Liquibase did not run because properties '" + AdagioConfigurationOption.LIQUIBASE_RUN_AUTO.getKey() + "' set to false.");
            return;
        }
        this.executeUpdate();
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.dataSource.getConnection()));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    this.getLog().warning("Problem closing connection", (Throwable)e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void executeUpdate() throws LiquibaseException {
        Connection c = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            this.performUpdate(liquibase);
            liquibase.forceReleaseLocks();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void performUpdate(liquibase.Liquibase liquibase) throws LiquibaseException {
        liquibase.update(this.getContexts());
    }

    public void reportStatus(Writer writer) throws LiquibaseException {
        Connection c = null;
        Writer myWriter = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            if (writer != null) {
                this.performReportStatus(liquibase, writer);
            } else {
                myWriter = new OutputStreamWriter(System.out);
                this.performReportStatus(liquibase, myWriter);
            }
            liquibase.forceReleaseLocks();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
            if (myWriter != null) {
                try {
                    myWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void performReportStatus(liquibase.Liquibase liquibase, Writer writer) throws LiquibaseException {
        liquibase.reportStatus(true, this.getContexts(), writer);
    }

    protected liquibase.Liquibase createLiquibase(Connection c) throws LiquibaseException {
        liquibase.Liquibase liquibase = new liquibase.Liquibase(this.getChangeLog(), (ResourceAccessor)this.createResourceOpener(), this.createDatabase(c));
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (StringUtils.trimToNull((String)this.defaultSchema) != null) {
            database.setDefaultSchemaName(this.defaultSchema);
        }
        return database;
    }

    protected Database createHibernateDatabase() throws DatabaseException {
        Database referenceDatabase = CommandLineUtils.createDatabaseObject((ClassLoader)this.getClass().getClassLoader(), (String)"hibernate:classic:hibernate.cfg.xml", null, null, null, (String)this.config.getJdbcCatalog(), (String)this.config.getJdbcSchema(), (boolean)false, (boolean)false, null, null, null, null);
        return referenceDatabase;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpener(this.getChangeLog());
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    protected void computeMaxChangeLogFileVersion() {
        this.maxChangeLogFileVersion = null;
        String changeLogPath = this.getChangeLog();
        if (StringUtils.isBlank((CharSequence)changeLogPath)) {
            return;
        }
        int index = (changeLogPath = changeLogPath.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index == -1 || index == changeLogPath.length() - 1) {
            return;
        }
        String changeLogWithVersionRegex = changeLogPath.substring(index + 1);
        changeLogWithVersionRegex = changeLogWithVersionRegex.replaceAll("master\\.xml", "([0-9]\\\\.[.-_a-zA-Z]+)\\\\.xml");
        Pattern changeLogWithVersionPattern = Pattern.compile(changeLogWithVersionRegex);
        Version maxVersion = null;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        try {
            Resource[] resources;
            String pathPrefix = changeLogPath.substring(0, index);
            for (Resource resource : resources = resolver.getResources(pathPrefix + "/db-changelog-*.xml")) {
                String fileVersion;
                String filename = resource.getFilename();
                Matcher matcher = changeLogWithVersionPattern.matcher(filename);
                if (!matcher.matches() || (fileVersion = matcher.group(1)).endsWith(CHANGE_LOG_SNAPSHOT_SUFFIX)) continue;
                try {
                    Version version = Version.parseVersion(fileVersion);
                    if (maxVersion != null && maxVersion.compareTo(version) >= 0) continue;
                    maxVersion = version;
                }
                catch (IllegalArgumentException iae) {
                    this.getLog().warning(String.format("Bad format version found in file: %s/%s. Ignoring this file when computing the max schema version.", changeLogPath, filename));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get changelog files", e);
        }
        if (maxVersion != null) {
            this.maxChangeLogFileVersion = maxVersion;
        }
    }

    public Version getMaxChangeLogFileVersion() {
        return this.maxChangeLogFileVersion;
    }

    public void reportDiff(File outputFile, String typesToControl) throws LiquibaseException {
        Connection c = null;
        PrintStream writer = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            DiffResult diffResult = this.performDiff(liquibase, typesToControl);
            liquibase.forceReleaseLocks();
            writer = outputFile != null ? new PrintStream(outputFile) : null;
            new DiffToReport(diffResult, writer != null ? writer : System.out).print();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AdagioTechnicalException("Could not write diff report file.", e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void generateDiffChangelog(File changeLogFile, String typesToControl) throws LiquibaseException {
        Connection c = null;
        PrintStream writer = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            DiffResult diffResult = this.performDiff(liquibase, typesToControl);
            liquibase.forceReleaseLocks();
            writer = changeLogFile != null ? new PrintStream(changeLogFile) : null;
            DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, false);
            new DiffToChangeLog(diffResult, diffOutputControl).print(writer != null ? writer : System.out);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        catch (ParserConfigurationException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        catch (IOException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected DiffResult performDiff(liquibase.Liquibase liquibase, String typesToControl) throws LiquibaseException {
        Database referenceDatabase = this.createHibernateDatabase();
        CompareControl compareControl = new CompareControl(DatabaseObjectFactory.getInstance().parseTypes(typesToControl));
        DiffResult diffResult = liquibase.diff(referenceDatabase, liquibase.getDatabase(), compareControl);
        return diffResult;
    }

    protected Logger getLog() {
        return LogFactory.getInstance().getLog();
    }

    public class SpringResourceOpener
    implements ResourceAccessor {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        public InputStream getResourceAsStream(String file) throws IOException {
            try {
                Resource resource = this.getResource(file);
                return resource.getInputStream();
            }
            catch (FileNotFoundException ex) {
                return null;
            }
        }

        public Enumeration<URL> getResources(String packageName) throws IOException {
            Vector<URL> tmp = new Vector<URL>();
            tmp.add(this.getResource(packageName).getURL());
            return tmp.elements();
        }

        public Resource getResource(String file) {
            return Liquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            return this.isClasspathPrefixPresent(this.parentFile) && !this.isClasspathPrefixPresent(file) ? "classpath:" + file : file;
        }

        public boolean isClasspathPrefixPresent(String file) {
            return file.startsWith("classpath:");
        }

        public ClassLoader toClassLoader() {
            return Liquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

