/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.replace.AbstractReplaceTemporaryUI;
import fr.ifremer.tutti.ui.swing.content.referential.replace.AbstractReplaceTemporaryUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class AbstractOpenReplaceTemporaryUIAction<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>, UI extends AbstractReplaceTemporaryUI<E, M>>
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(AbstractOpenReplaceTemporaryUIAction.class);
    protected E source;
    protected E target;

    protected abstract String getEntityLabel();

    protected abstract M createNewModel();

    protected abstract UI createUI(JAXXInitialContext var1);

    protected abstract List<E> getTargetList(PersistenceService var1);

    protected AbstractOpenReplaceTemporaryUIAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.setProgressionModel(new ProgressionModel());
            this.getProgressionModel().setTotal(3);
        }
        return doAction;
    }

    public void releaseAction() {
        this.target = null;
        this.source = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        M model = this.createNewModel();
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        String entityLabel = this.getEntityLabel();
        this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.loading.target", (Object[])new Object[]{entityLabel}));
        List<E> targetList = this.getTargetList(persistenceService);
        this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.loading.source", (Object[])new Object[]{entityLabel}));
        List sourceList = persistenceService.retainTemporaryList(targetList);
        log.info((Object)("Loaded temporary referentials: " + sourceList.size()));
        log.info((Object)("Loaded official referentials: " + targetList.size()));
        boolean showDialog = true;
        if (targetList.isEmpty()) {
            this.displayWarningMessage(I18n.t((String)"tutti.title.openReplaceTemporaryUI.noTarget", (Object[])new Object[]{entityLabel}), I18n.t((String)"tutti.message.openReplaceTemporaryUI.noTarget", (Object[])new Object[]{entityLabel}));
            showDialog = false;
        }
        if (sourceList.isEmpty()) {
            this.displayWarningMessage(I18n.t((String)"tutti.title.openReplaceTemporaryUI.noSource", (Object[])new Object[]{entityLabel}), I18n.t((String)"tutti.message.openReplaceTemporaryUI.noSource", (Object[])new Object[]{entityLabel}));
            showDialog = false;
        }
        if (showDialog) {
            this.getProgressionModel().increments(I18n.t((String)"tutti.openReplaceTemporaryUI.open.dialog", (Object[])new Object[0]));
            ((AbstractReplaceTemporaryUIModel)model).setTargetList(targetList);
            ((AbstractReplaceTemporaryUIModel)model).setSourceList(sourceList);
            JAXXInitialContext ctx = new JAXXInitialContext();
            ctx.add((Object)this.getUI());
            ctx.add(model);
            UI dialog = this.createUI(ctx);
            MainUI mainUI = TuttiUIUtil.getApplicationContext(dialog).getMainUI();
            SwingUtil.setComponentHeight(dialog, (int)400);
            SwingUtil.setComponentWidth(dialog, (int)(mainUI.getWidth() - 100));
            SwingUtil.center((Component)mainUI, dialog);
            SwingUtilities.invokeLater(new Runnable((AbstractReplaceTemporaryUI)dialog){
                final /* synthetic */ AbstractReplaceTemporaryUI val$dialog;
                {
                    this.val$dialog = abstractReplaceTemporaryUI;
                }

                @Override
                public void run() {
                    this.val$dialog.setVisible(true);
                    ((TuttiUI)((Object)this.val$dialog)).getHandler().onCloseUI();
                }
            });
        }
    }
}

