/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.api.InstanceID;

public class DocumentDataSource {
    IDocArchiveReader dataSource;
    InstanceID iid;
    String bookmark;

    public DocumentDataSource(IDocArchiveReader dataSource) {
        this(dataSource, null, null);
    }

    public DocumentDataSource(IDocArchiveReader dataSource, String bookmark, InstanceID iid) {
        this.dataSource = dataSource;
        this.bookmark = bookmark;
        if (iid != null) {
            this.iid = iid;
        }
    }

    public boolean isReportletDocument() {
        return this.bookmark != null && this.iid != null;
    }

    public void open() throws IOException {
        this.dataSource.open();
    }

    public void close() throws IOException {
        this.dataSource.close();
    }

    public IDocArchiveReader getDataSource() {
        return this.dataSource;
    }

    public InstanceID getInstanceID() {
        return this.iid;
    }

    public long getElementID() {
        if (this.iid != null) {
            return this.iid.getComponentID();
        }
        return -1L;
    }

    public String getBookmark() {
        return this.bookmark;
    }
}

