/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.list.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.list.DefaultCheckListModel;
import jaxx.runtime.swing.list.filter.CheckListFilterType;
import jaxx.runtime.swing.list.filter.FilterableCheckListModel;
import org.nuiton.decorator.Decorator;

public class DefaultFilterableCheckListModel<T>
extends DefaultCheckListModel<T>
implements FilterableCheckListModel<T> {
    private List<T> filteredData = null;

    public DefaultFilterableCheckListModel(Collection<? extends T> data) {
        super(data);
    }

    public DefaultFilterableCheckListModel(T ... data) {
        super(Arrays.asList(data));
    }

    @Override
    protected List<T> data() {
        return this.filteredData == null ? this.data : this.filteredData;
    }

    @Override
    public void filter(String filter, Decorator<Object> decorator, CheckListFilterType filterType) {
        if (filter == null || filter.trim().length() == 0) {
            this.filteredData = null;
        } else {
            CheckListFilterType ft = filterType == null ? CheckListFilterType.CONTAINS : filterType;
            String f = filter.toLowerCase();
            ArrayList<T> fData = new ArrayList<T>();
            for (Object o : this.data) {
                String decorated = o != null && decorator != null ? decorator.toString(o) : JAXXUtil.getStringValue(o);
                if (!ft.include(decorated, f)) continue;
                fData.add(o);
            }
            this.filteredData = fData;
        }
        this.fireContentsChanged(this, 0, this.data.size() - 1);
    }
}

