/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.config;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionConfiguration;

public class OracleConfigStandard
extends ConnectionConfiguration {
    @Override
    public String getDatabaseShortName() {
        return "oracle";
    }

    @Override
    public String getConfigurationName() {
        return "standard";
    }

    @Override
    public String getUrl() {
        return "jdbc:oracle:thin:@" + this.getHostname() + ":1521:" + this.getDatabaseUsername();
    }

    @Override
    public Set<String> getPuppetModules() {
        Set<String> modules = super.getPuppetModules();
        modules.add("biemond/oradb");
        return modules;
    }

    @Override
    public String getVagrantBoxName() {
        return "linux.centos.6_4";
    }

    @Override
    public Set<String> getRequiredPackages(String vagrantBoxName) {
        Set<String> requiredPackages = super.getRequiredPackages(vagrantBoxName);
        requiredPackages.addAll(Arrays.asList("binutils", "compat-libcap1", "gcc", "gcc-c++", "glibc", "glibc-devel", "ksh", "libgcc", "libstdc++", "libstdc++-devel", "libaio", "libaio-devel", "libXext", "libX11", "libXau", "libxcb", "libXi", "make", "sysstat", "rlwrap"));
        return requiredPackages;
    }

    @Override
    public String getPuppetInit(String box) {
        return "Package <| |> -> Oradb::Installdb <| |>\n\noradb::installdb{ '" + this.getVersion() + "_Linux-x86-64':\n" + "        version      => '" + this.getVersion() + "',\n" + "        file         => 'linuxamd64_12c_database',\n" + "        databaseType => 'SE',\n" + "        oracleBase   => '" + this.getOracleBase() + "',\n" + "        oracleHome   => '" + this.getOracleHome() + "',\n" + "        user         => '" + this.getInstallUsername() + "',\n" + "        group        => 'dba',\n" + "        downloadDir  => '/install/oracle/',\n" + "        puppetDownloadMntPoint  => '/install/oracle/'\n" + "}\n" + "\n" + "oradb::database{ '" + this.getSID() + "':\n" + "                  oracleBase              => '" + this.getOracleBase() + "',\n" + "                  oracleHome              => '" + this.getOracleHome() + "',\n" + "                  version                 => '" + this.getShortVersion() + "',\n" + "                  user                    => '" + this.getInstallUsername() + "',\n" + "                  group                   => 'dba',\n" + "                  downloadDir             => '/install/oracle/',\n" + "                  action                  => 'create',\n" + "                  dbName                  => '" + this.getSID() + "',\n" + "                  dbDomain                => '" + this.getDatabaseDomain() + "',\n" + "                  sysPassword             => '" + this.getSysPassword() + "',\n" + "                  systemPassword          => '" + this.getSystemPassword() + "',\n" + "                  dataFileDestination     => '" + this.getOracleBase() + "/oradata',\n" + "                  recoveryAreaDestination => '" + this.getOracleBase() + "/flash_recovery_area',\n" + "                  characterSet            => '" + this.getCharacterSet() + "',\n" + "                  nationalCharacterSet    => '" + this.getNationalCharacterSet() + "',\n" + "                  initParams              => '" + this.getInitParams() + "',\n" + "                  sampleSchema            => 'FALSE',\n" + "                  memoryPercentage        => '" + this.getMemoryPercentage() + "',\n" + "                  memoryTotal             => '" + this.getMemoryTotal() + "',\n" + "                  databaseType            => \"MULTIPURPOSE\",\n" + "                  require                 => Oradb::InstallDb['" + this.getVersion() + "_Linux-x86-64'],\n" + "}\n" + "\n" + "oradb::listener{'start listener':\n" + "        oracleBase   => '" + this.getOracleBase() + "',\n" + "        oracleHome   => '" + this.getOracleHome() + "',\n" + "        user         => '" + this.getInstallUsername() + "',\n" + "        group        => 'dba',\n" + "        action       => 'start',\n" + "        require      => Oradb::Database['" + this.getSID() + "'],\n" + "   }\n" + "\n" + "oradb::autostartdatabase{ 'autostart oracle':\n" + "                   oracleHome              => '" + this.getOracleHome() + "',\n" + "                   user                    => '" + this.getInstallUsername() + "',\n" + "                   dbName                  => '" + this.getSID() + "',\n" + "                   require                 => Oradb::Database['" + this.getSID() + "'],\n" + "}\n" + "file { '~/oracle-init.sh':\n" + "    require      => Oradb::Autostartdatabase['autostart oracle'],\n" + "    mode => '755',\n" + "    content => \"#!/bin/sh\n" + "\n" + "export ORACLE_HOME=" + this.getOracleHome() + ";\n" + "export ORACLE_SID=" + this.getSID() + ";\n" + "echo \\\"create user " + this.getDatabaseUsername() + " identified by " + this.getDatabasePassword() + ";\n" + "grant all privileges to " + this.getDatabaseUsername() + ";\n" + "create user " + this.getAlternateUsername() + " identified by " + this.getAlternateUserPassword() + ";\n" + "grant all privileges to " + this.getAlternateUsername() + ";\n" + "create tablespace " + this.getAlternateTablespace() + " datafile '" + this.getOracleBase() + "/oradata/" + this.getSID() + "/" + this.getAlternateTablespace() + ".dbf' SIZE 5M autoextend on next 5M;    \\\" | " + this.getOracleHome() + "/bin/sqlplus / as sysdba; \n" + "touch ~/database-init.ran;\n" + "\",\n" + "}\n" + "\n" + "exec { 'execute oracle setup scripts':\n" + "    require      => [File['~/database-init.sh'], Oradb::Autostartdatabase['autostart oracle']],\n" + "    path => ['/bin','/usr/bin'],\n" + "    command => '~/database-init.sh',\n" + "    user => '" + this.getInstallUsername() + "',\n" + "    creates => '~/database-init.ran',\n" + "}\n";
    }

    @Override
    public String getVersion() {
        return "12.1.0.1";
    }

    protected String getShortVersion() {
        return "12.1";
    }

    public String getMemoryTotal() {
        return "800";
    }

    public String getMemoryPercentage() {
        return "40";
    }

    public String getInitParams() {
        return "open_cursors=1000,processes=600,job_queue_processes=4";
    }

    public String getNationalCharacterSet() {
        return "UTF8";
    }

    public String getCharacterSet() {
        return "AL32UTF8";
    }

    public String getSystemPassword() {
        return "oracle";
    }

    public String getSysPassword() {
        return "oracle";
    }

    public String getDatabaseDomain() {
        return "liquibase.org";
    }

    public String getSID() {
        return "liquibase";
    }

    public String getInstallUsername() {
        return "oracle";
    }

    public String getOracleHome() {
        return "/oracle/product/" + this.getShortVersion() + "/db";
    }

    public String getOracleBase() {
        return "/oracle";
    }

    @Override
    public String getDescription() {
        return String.valueOf(super.getDescription()) + "SID: " + this.getSID() + "\n" + "Oracle Base: " + this.getOracleBase() + "\n" + "Oracle Home: " + this.getOracleHome() + "\n" + "Database Domain: " + this.getDatabaseDomain() + "\n" + "Installer OS Username: " + this.getInstallUsername() + "\n" + "             Password: " + this.getInstallUsername() + "\n" + "SYS User Password: " + this.getSysPassword() + "\n" + "SYSTEM User Password: " + this.getSystemPassword() + "\n" + "Init Params: " + this.getInitParams() + "\n" + "Character Set: " + this.getCharacterSet() + "\n" + "National Character Set: " + this.getNationalCharacterSet() + "\n" + "\n" + "NOTE: You must manually download the oracle installation files into " + new File("vagrant/install-files/oracle").getAbsolutePath() + "\n" + "      You can download the install files from http://www.oracle.com/technetwork/database/enterprise-edition/downloads/index.html with a free OTN account\n" + "      Expected files: linuxamd64_12c_database_1of2.zip and linuxamd64_12c_database_2of2.zip\n" + "\n" + "NOTE: For easier sqlplus usage, rlwrap is installed. See http://www.oraclealchemist.com/news/add-history-and-tab-completion-to-sqlplus/ for more information";
    }
}

