/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.config;

import java.io.File;
import java.net.URL;
import java.util.Locale;
import org.hibernate.dialect.HSQLDialect;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;

public enum SynchroConfigurationOption implements ConfigOptionDef
{
    BASEDIR("adagio.basedir", I18n.n((String)"adagio.config.option.basedir.description", (Object[])new Object[0]), "${user.home}/.adagio", File.class),
    DATA_DIRECTORY("adagio.data.directory", I18n.n((String)"adagio.config.option.data.directory.description", (Object[])new Object[0]), "${adagio.basedir}/data", File.class),
    I18N_DIRECTORY("adagio.i18n.directory", I18n.n((String)"adagio.config.option.i18n.directory.description", (Object[])new Object[0]), "${adagio.basedir}/i18n", File.class),
    TMP_DIRECTORY("adagio.tmp.directory", I18n.n((String)"adagio.config.option.tmp.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/temp", File.class),
    DB_DIRECTORY("adagio.persistence.db.directory", I18n.n((String)"adagio.config.option.persistence.db.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/db", File.class),
    DB_ATTACHMENT_DIRECTORY("adagio.persistence.db.attachment.directory", I18n.n((String)"adagio.config.option.persistence.db.attachment.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/meas_files", File.class),
    DB_CACHE_DIRECTORY("adagio.persistence.db.cache.directory", I18n.n((String)"adagio.config.option.persistence.db.cache.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/dbcache", File.class),
    DB_NAME("adagio.persistence.db.name", I18n.n((String)"adagio.config.option.persistence.db.name.description", (Object[])new Object[0]), "allegro", String.class),
    DB_HOST("adagio.persistence.db.host", I18n.n((String)"adagio.config.option.persistence.db.host.description", (Object[])new Object[0]), "", String.class),
    DB_PORT("adagio.persistence.db.port", I18n.n((String)"adagio.config.option.persistence.db.port.description", (Object[])new Object[0]), "", String.class),
    DB_VALIDATION_QUERY("adagio.persistence.db.validation-query", I18n.n((String)"adagio.persistence.db.validation-query.description", (Object[])new Object[0]), "SELECT COUNT(*) FROM STATUS", String.class),
    JDBC_USERNAME("adagio.persistence.jdbc.username", I18n.n((String)"adagio.config.option.persistence.jdbc.username.description", (Object[])new Object[0]), "sa", String.class),
    JDBC_PASSWORD("adagio.persistence.jdbc.password", I18n.n((String)"adagio.config.option.persistence.jdbc.password.description", (Object[])new Object[0]), "", String.class),
    JDBC_URL("adagio.persistence.jdbc.url", I18n.n((String)"adagio.config.option.persistence.jdbc.url.description", (Object[])new Object[0]), "jdbc:hsqldb:file:${adagio.persistence.db.directory}/${adagio.persistence.db.name}", String.class),
    JDBC_DRIVER("adagio.persistence.jdbc.driver", I18n.n((String)"adagio.config.option.persistence.jdbc.driver.description", (Object[])new Object[0]), "org.hsqldb.jdbcDriver", Class.class),
    HIBERNATE_DIALECT("adagio.persistence.hibernate.dialect", I18n.n((String)"adagio.config.option.persistence.hibernate.dialect.description", (Object[])new Object[0]), HSQLDialect.class.getName(), Class.class),
    VERSION("adagio.persistence.version", I18n.n((String)"adagio.config.option.persistence.version.description", (Object[])new Object[0]), "3.4.2", Version.class),
    SITE_URL("adagio.site.url", I18n.n((String)"adagio.config.option.site.url.description", (Object[])new Object[0]), "http://www.ifremer.fr/sih-adagio", URL.class),
    ORGANIZATION_NAME("adagio.organizationName", I18n.n((String)"adagio.config.option.organizationName.description", (Object[])new Object[0]), "Ifremer", String.class),
    INCEPTION_YEAR("adagio.inceptionYear", I18n.n((String)"adagio.config.option.inceptionYear.description", (Object[])new Object[0]), "2011", Integer.class),
    SYNCHRONIZATION_STATUS_SYNCHRONIZED("adagio.synchro.enumeration.SynchronizationStatus.SYNCHRONIZED", I18n.n((String)"adagio.synchro.enumeration.SynchronizationStatus.SYNCHRONIZED.description", (Object[])new Object[0]), "SYNC", String.class),
    SYNCHRONIZATION_STATUS_READY_TO_SYNCHRONIZE("adagio.synchro.enumeration.SynchronizationStatus.READY_TO_SYNCHRONIZE", I18n.n((String)"adagio.synchro.enumeration.SynchronizationStatus.READY_TO_SYNCHRONIZE.description", (Object[])new Object[0]), "READY_TO_SYNC", String.class),
    SYNCHRONIZATION_STATUS_DELETED("adagio.synchro.enumeration.SynchronizationStatus.DELETED", I18n.n((String)"adagio.synchro.enumeration.SynchronizationStatus.DELETED.description", (Object[])new Object[0]), "DELETED", String.class),
    SYNCHRONIZATION_STATUS_DIRTY("adagio.synchro.enumeration.SynchronizationStatus.DIRTY", I18n.n((String)"adagio.synchro.enumeration.SynchronizationStatus.DIRTY.description", (Object[])new Object[0]), "DIRTY", String.class),
    IMPORT_DB_DIRECTORY("adagio.synchro.import.db.directory", I18n.n((String)"adagio.config.option.synchro.import.db.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/dbimport", File.class),
    IMPORT_DB_ATTACHMENT_DIRECTORY("adagio.synchro.import.db.attachment.directory", I18n.n((String)"adagio.config.option.synchro.import.db.attachment.directory.description", (Object[])new Object[0]), "${adagio.synchro.import.db.directory}/meas_files", File.class),
    IMPORT_DB_NAME("adagio.synchro.import.db.name", I18n.n((String)"adagio.config.option.synchro.import.db.name.description", (Object[])new Object[0]), "allegro", String.class),
    IMPORT_DB_HOST("adagio.synchro.import.db.host", I18n.n((String)"adagio.config.option.synchro.import.db.host.description", (Object[])new Object[0]), "", String.class),
    IMPORT_DB_PORT("adagio.synchro.import.db.port", I18n.n((String)"adagio.config.option.synchro.import.db.port.description", (Object[])new Object[0]), "", String.class),
    IMPORT_JDBC_USERNAME("adagio.synchro.import.jdbc.username", I18n.n((String)"adagio.config.option.synchro.import.jdbc.username.description", (Object[])new Object[0]), "sa", String.class),
    IMPORT_JDBC_PASSWORD("adagio.synchro.import.jdbc.password", I18n.n((String)"adagio.config.option.synchro.import.jdbc.password.description", (Object[])new Object[0]), "", String.class),
    IMPORT_JDBC_SCHEMA("adagio.synchro.import.jdbc.schema", I18n.n((String)"adagio.config.option.synchro.import.jdbc.schema.description", (Object[])new Object[0]), null, String.class),
    IMPORT_JDBC_CATALOG("adagio.synchro.import.jdbc.catalog", I18n.n((String)"adagio.config.option.synchro.import.jdbc.catalog.description", (Object[])new Object[0]), null, String.class),
    IMPORT_JDBC_URL("adagio.synchro.import.jdbc.url", I18n.n((String)"adagio.config.option.synchro.import.jdbc.url.description", (Object[])new Object[0]), "jdbc:hsqldb:file:${adagio.synchro.import.db.directory}/${adagio.synchro.import.db.name}", String.class),
    IMPORT_JDBC_DRIVER("adagio.synchro.import.jdbc.driver", I18n.n((String)"adagio.config.option.synchro.import.jdbc.driver.description", (Object[])new Object[0]), "org.hsqldb.jdbcDriver", Class.class),
    IMPORT_HIBERNATE_DIALECT("adagio.synchro.import.hibernate.dialect", I18n.n((String)"adagio.config.option.synchro.import.hibernate.dialect.description", (Object[])new Object[0]), HSQLDialect.class.getName(), Class.class),
    IMPORT_TABLES_DATA_INCLUDES("adagio.synchro.import.tables.data.includes", I18n.n((String)"adagio.config.option.synchro.import.tables.data.includes.description", (Object[])new Object[0]), "", String.class),
    IMPORT_TABLES_REFERENTIAL_INCLUDES("adagio.synchro.import.tables.referential.includes", I18n.n((String)"adagio.config.option.synchro.import.tables.referential.includes.description", (Object[])new Object[0]), "", String.class),
    IMPORT_JDBC_BATCH_SIZE("adagio.synchro.import.jdbc.batch-size", I18n.n((String)"adagio.config.option.synchro.import.jdbc.batch-size.description", (Object[])new Object[0]), "1000", Integer.class),
    SERVER_PORT("adagio.server.port", I18n.n((String)"adagio.config.option.server.port.description", (Object[])new Object[0]), "8080", Integer.class, false),
    SERVER_SSL_KEYSTORE("adagio.server.ssl.keystore.file", I18n.n((String)"adagio.config.option.server.ssl.keystore.file.description", (Object[])new Object[0]), "my.keystore", File.class, false),
    DB_BACKUP_DIRECTORY("adagio.persistence.db.backup.directory", I18n.n((String)"adagio.config.option.persistence.db.backup.directory.description", (Object[])new Object[0]), "${adagio.data.directory}/dbbackup", File.class, false),
    I18N_LOCALE("adagio.i18n.locale", I18n.n((String)"adagio.config.option.i18n.locale.description", (Object[])new Object[0]), Locale.FRANCE.getCountry(), Locale.class, false);

    private final String key;
    private final String description;
    private final Class<?> type;
    private String defaultValue;
    private boolean isTransient;
    private boolean isFinal;

    private SynchroConfigurationOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isTransient;
    }

    private SynchroConfigurationOption(String key, String description, String defaultValue, Class<?> type) {
        this(key, description, defaultValue, type, true);
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTransient(boolean newValue) {
    }

    public void setFinal(boolean newValue) {
    }
}

