/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class SpeciesRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CODE_FIRST_PART = "codeFirstPart";
    public static final String PROPERTY_CODE_SECOND_PART = "codeSecondPart";
    public static final String PROPERTY_SCIENTIFIC_NAME = "scientificName";
    protected final String codeFirstPart;
    protected final String codeSecondPart;
    protected final String scientificName;

    public SpeciesRow(Species species) {
        String surveyCode = species.getSurveyCode();
        Preconditions.checkNotNull((Object)surveyCode, (Object)("Unable to export a species with a null survey code : " + species));
        int signIndex = surveyCode.indexOf("-");
        if (signIndex == -1) {
            this.codeFirstPart = StringUtils.rightPad((String)StringUtils.substring((String)surveyCode, (int)0, (int)4), (int)4);
            this.codeSecondPart = StringUtils.rightPad((String)StringUtils.substring((String)surveyCode, (int)4, (int)7), (int)3);
        } else {
            this.codeFirstPart = StringUtils.rightPad((String)StringUtils.substring((String)surveyCode, (int)0, (int)4), (int)4);
            this.codeSecondPart = StringUtils.rightPad((String)StringUtils.substring((String)surveyCode, (int)5, (int)8), (int)3);
        }
        this.scientificName = species.getName();
    }

    public String getCodeFirstPart() {
        return this.codeFirstPart;
    }

    public String getCodeSecondPart() {
        return this.codeSecondPart;
    }

    public String getScientificName() {
        return this.scientificName;
    }
}

