/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.util.Numbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class ExportCatchContext {
    final FishingOperation fishingOperation;
    final CatchBatch catchBatch;
    final BatchContainer<SpeciesBatch> rootSpeciesBatch;
    final BatchContainer<BenthosBatch> rootBenthosBatch;
    final BatchContainer<MarineLitterBatch> marineLitterBatches;
    final Multimap<Species, SpeciesBatchFrequency> speciesFrequencies;
    final Multimap<Species, BenthosBatchFrequency> benthosFrequencies;
    final Predicate<SpeciesAbleBatch> vracPredicate;

    public static ExportCatchContext newExportContext(PersistenceService persistenceService, WeightComputingService weightComputingService, String fishingOperationId, boolean loadFrequencies) {
        Multimap<Species, BenthosBatchFrequency> benthosFrequencies;
        Multimap<Species, SpeciesBatchFrequency> speciesFrequencies;
        FishingOperation fishingOperation = persistenceService.getFishingOperation(fishingOperationId);
        CatchBatch catchBatch = persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
        BatchContainer<SpeciesBatch> rootSpeciesBatch = weightComputingService.getComputedSpeciesBatches(fishingOperationId);
        BatchContainer<BenthosBatch> rootBenthosBatch = weightComputingService.getComputedBenthosBatches(fishingOperationId);
        BatchContainer<MarineLitterBatch> marineLitterBatches = weightComputingService.getComputedMarineLitterBatches(fishingOperationId, catchBatch.getMarineLitterTotalWeight());
        weightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, marineLitterBatches);
        if (loadFrequencies) {
            speciesFrequencies = persistenceService.getAllSpeciesBatchFrequencyForBatch(rootSpeciesBatch);
            benthosFrequencies = persistenceService.getAllBenthosBatchFrequencyForBatch(rootBenthosBatch);
        } else {
            speciesFrequencies = null;
            benthosFrequencies = null;
        }
        Predicate<SpeciesAbleBatch> vracPredicate = persistenceService.getVracBatchPredicate();
        ExportCatchContext result = new ExportCatchContext(vracPredicate, fishingOperation, catchBatch, rootSpeciesBatch, speciesFrequencies, rootBenthosBatch, benthosFrequencies, marineLitterBatches);
        return result;
    }

    private ExportCatchContext(Predicate<SpeciesAbleBatch> vracPredicate, FishingOperation fishingOperation, CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, Multimap<Species, SpeciesBatchFrequency> speciesFrequencies, BatchContainer<BenthosBatch> rootBenthosBatch, Multimap<Species, BenthosBatchFrequency> benthosFrequencies, BatchContainer<MarineLitterBatch> marineLitterBatches) {
        this.vracPredicate = vracPredicate;
        this.fishingOperation = fishingOperation;
        this.catchBatch = catchBatch;
        this.rootSpeciesBatch = rootSpeciesBatch;
        this.speciesFrequencies = speciesFrequencies;
        this.benthosFrequencies = benthosFrequencies;
        this.rootBenthosBatch = rootBenthosBatch;
        this.marineLitterBatches = marineLitterBatches;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public float getCatchTotalWeight() {
        float result = ((Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalWeight(), (Number)this.catchBatch.getCatchTotalComputedWeight())).floatValue();
        return result;
    }

    public float getCatchTotalSortedWeight() {
        return this.catchBatch.getSpeciesTotalSampleSortedComputedWeight().floatValue() + this.catchBatch.getBenthosTotalSampleSortedComputedWeight().floatValue() + this.catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + this.catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue();
    }

    public boolean withSpeciesBatches() {
        return this.rootSpeciesBatch != null && !this.rootSpeciesBatch.isEmptyChildren();
    }

    public boolean withBenthosBatches() {
        return this.rootBenthosBatch != null && !this.rootBenthosBatch.isEmptyChildren();
    }

    public boolean withSpeciesFrequencies() {
        return this.speciesFrequencies != null && !this.speciesFrequencies.isEmpty();
    }

    public boolean withBenthosFrequencies() {
        return this.benthosFrequencies != null && !this.benthosFrequencies.isEmpty();
    }

    public List<ExportBatchEntry> getSpeciesBatchEntry(boolean computeNumber) {
        ArrayList catchList = Lists.newArrayList();
        if (this.withSpeciesBatches()) {
            boolean withFrequencies = this.withSpeciesFrequencies();
            LinkedHashMap catches = Maps.newLinkedHashMap();
            float rate = this.getSpeciesElevationRate();
            List batches = this.rootSpeciesBatch.getChildren();
            for (SpeciesBatch batch : batches) {
                ExportBatchEntry aCatch = this.createExportBatchCatch((SpeciesAbleBatch)batch, catches, rate, computeNumber);
                if (!withFrequencies) continue;
                this.addFrequencies(aCatch, this.speciesFrequencies);
            }
            catchList.addAll(catches.values());
        }
        return catchList;
    }

    public List<ExportBatchEntry> getBenthosBatchEntry(boolean computeNumber) {
        ArrayList catchList = Lists.newArrayList();
        if (this.withBenthosBatches()) {
            boolean withFrequencies = this.withBenthosFrequencies();
            LinkedHashMap catches = Maps.newLinkedHashMap();
            float rate = this.getBenthosElevationRate();
            List batches = this.rootBenthosBatch.getChildren();
            for (BenthosBatch batch : batches) {
                ExportBatchEntry aCatch = this.createExportBatchCatch((SpeciesAbleBatch)batch, catches, rate, computeNumber);
                if (!withFrequencies) continue;
                this.addFrequencies(aCatch, this.benthosFrequencies);
            }
            catchList.addAll(catches.values());
        }
        return catchList;
    }

    public ExportBatchEntry getInertAndLivingNotItemizedCatch() {
        Float benthosLivingNotItemizedWeight;
        Float benthosInterWeight;
        Float speciesLivingNotItemizedWeigth;
        ExportBatchEntry result = new ExportBatchEntry(null);
        float speciesRatio = this.getSpeciesElevationRate();
        float benthosRatio = this.getBenthosElevationRate();
        Float speciesInterWeight = (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalInertWeight(), (Number)this.catchBatch.getSpeciesTotalInertComputedWeight());
        if (speciesInterWeight != null) {
            result.addSortedWeight(speciesInterWeight.floatValue());
            result.addTotalWeight(speciesInterWeight.floatValue() * speciesRatio);
        }
        if ((speciesLivingNotItemizedWeigth = (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight())) != null) {
            result.addSortedWeight(speciesLivingNotItemizedWeigth.floatValue());
            result.addTotalWeight(speciesLivingNotItemizedWeigth.floatValue() * speciesRatio);
        }
        if ((benthosInterWeight = (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalInertWeight(), (Number)this.catchBatch.getBenthosTotalInertComputedWeight())) != null) {
            result.addSortedWeight(benthosInterWeight.floatValue());
            result.addTotalWeight(benthosInterWeight.floatValue() * benthosRatio);
        }
        if ((benthosLivingNotItemizedWeight = (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getBenthosTotalLivingNotItemizedComputedWeight())) != null) {
            result.addSortedWeight(benthosLivingNotItemizedWeight.floatValue());
            result.addTotalWeight(benthosLivingNotItemizedWeight.floatValue() * benthosRatio);
        }
        return result;
    }

    public boolean isVracBatch(SpeciesAbleBatch batch) {
        return this.vracPredicate.apply((Object)batch);
    }

    protected float getSpeciesElevationRate() {
        float globalRatio = (this.getCatchTotalWeight() - this.catchBatch.getCatchTotalUnsortedComputedWeight().floatValue()) / this.catchBatch.getCatchTotalSortedComputedWeight().floatValue();
        float speciesTotalSortedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalSortedWeight(), (Number)this.catchBatch.getSpeciesTotalSortedComputedWeight())).floatValue();
        float result = globalRatio * speciesTotalSortedWeight;
        if (this.catchBatch.getSpeciesTotalSampleSortedComputedWeight().floatValue() > 0.0f) {
            result /= this.catchBatch.getSpeciesTotalSampleSortedComputedWeight().floatValue();
        }
        return result;
    }

    protected float getBenthosElevationRate() {
        float globalRatio = (this.getCatchTotalWeight() - this.catchBatch.getCatchTotalUnsortedComputedWeight().floatValue()) / this.catchBatch.getCatchTotalSortedComputedWeight().floatValue();
        float benthosTotalSortedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalSortedWeight(), (Number)this.catchBatch.getBenthosTotalSortedComputedWeight())).floatValue();
        float result = globalRatio * benthosTotalSortedWeight;
        if (this.catchBatch.getBenthosTotalSampleSortedComputedWeight().floatValue() > 0.0f) {
            result /= this.catchBatch.getBenthosTotalSampleSortedComputedWeight().floatValue();
        }
        return result;
    }

    protected ExportBatchEntry createExportBatchCatch(SpeciesAbleBatch batch, Map<Species, ExportBatchEntry> catches, float ratio, boolean computeNumber) {
        Species species = batch.getSpecies();
        ExportBatchEntry ktch = catches.get(species);
        if (ktch == null) {
            ktch = new ExportBatchEntry(batch);
            catches.put(species, ktch);
        }
        float sortedWeight = ((Float)Numbers.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight())).floatValue();
        ktch.addSortedWeight(sortedWeight);
        boolean isVracBatch = this.isVracBatch(batch);
        float speciesTotalWeight = sortedWeight;
        if (isVracBatch) {
            speciesTotalWeight *= ratio;
        }
        ktch.addTotalWeight(speciesTotalWeight);
        if (computeNumber) {
            float number = Math.round(this.computeNumber(batch, 1.0f));
            if (isVracBatch) {
                number *= ratio;
            }
            ktch.addNumber(Math.round(number));
        }
        return ktch;
    }

    protected float computeNumber(SpeciesAbleBatch batch, float rf) {
        float result;
        float weight = ((Float)Numbers.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight())).floatValue();
        if (batch.isChildBatchsEmpty()) {
            Float subweight;
            Integer number = (Integer)Numbers.getValueOrComputedValue((Number)batch.getNumber(), (Number)batch.getComputedNumber());
            if (number == null) {
                number = 0;
            }
            if ((subweight = (Float)Numbers.getValueOrComputedValue((Number)batch.getWeight(), (Number)batch.getComputedWeight())) != null) {
                rf *= weight / subweight.floatValue();
            }
            result = number.floatValue() * rf;
        } else {
            float totalWeight = 0.0f;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                totalWeight += ((Float)Numbers.getValueOrComputedValue((Number)child.getSampleCategoryWeight(), (Number)child.getSampleCategoryComputedWeight())).floatValue();
            }
            result = 0.0f;
            float rf2 = rf * weight / totalWeight;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                result += this.computeNumber(child, rf2);
            }
        }
        return result;
    }

    protected <F extends SpeciesAbleBatchFrequency> void addFrequencies(ExportBatchEntry aCatch, Multimap<Species, F> frequencies) {
        Species species = aCatch.getBatch().getSpecies();
        Collection batchFrequencies = frequencies.get((Object)species);
        if (CollectionUtils.isNotEmpty((Collection)batchFrequencies)) {
            for (SpeciesAbleBatchFrequency batchFrequency : batchFrequencies) {
                Integer number = batchFrequency.getNumber();
                Float lengthStep = batchFrequency.getLengthStep();
                aCatch.addFrequency(lengthStep.floatValue(), number);
            }
        }
    }
}

