/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.awt.Container;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidatorMessageListModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import jaxx.runtime.validator.swing.ui.IconValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.validator.NuitonValidatorFactory;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SwingValidator<B>
extends SimpleBeanValidator<B> {
    private static final Log log = LogFactory.getLog(SwingValidator.class);
    private static final Class<? extends AbstractBeanValidatorUI> DEFAULT_UI_CLASS = IconValidationUI.class;
    protected final Map<String, JComponent> fieldRepresentation = new HashMap<String, JComponent>();
    protected SwingValidatorMessageListModel errorListModel;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected Class<? extends AbstractBeanValidatorUI> uiClass;

    public static <O> SwingValidator<O> newValidator(Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        SwingValidator<O> beanValidator = SwingValidator.newValidator(providerName, type, context, scopes);
        return beanValidator;
    }

    public static <O> SwingValidator<O> newValidator(String providerName, Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        Preconditions.checkNotNull(type, (Object)"type parameter can not be null.");
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider((String)providerName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Could not find provider with name " + providerName));
        SwingValidator<O> validator = new SwingValidator<O>(provider, type, context, scopes);
        return validator;
    }

    public SwingValidator(NuitonValidatorProvider provider, Class<B> beanClass, String contextName, NuitonValidatorScope ... filterScopes) {
        super(provider, beanClass, contextName, filterScopes);
    }

    public SwingValidator(Class<B> beanClass, String contextName, NuitonValidatorScope ... filterScopes) {
        super(NuitonValidatorFactory.getDefaultProvider(), beanClass, contextName, filterScopes);
    }

    public SwingValidator(Class<B> beanClass, String contextName) {
        this(beanClass, contextName, NuitonValidatorScope.values());
    }

    public void reloadBean() {
        Object b = this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will reload bean : " + b));
        }
        if (b != null) {
            this.setBean(null);
            this.setBean(b);
        }
    }

    public JComponent getFieldRepresentation(String fieldname) {
        return this.fieldRepresentation.get(fieldname);
    }

    public Class<? extends AbstractBeanValidatorUI> getUiClass() {
        return this.uiClass;
    }

    public void setErrorListModel(SwingValidatorMessageListModel errorListModel) {
        this.errorListModel = errorListModel;
        if (errorListModel != null) {
            errorListModel.registerValidator(this);
        }
    }

    public void setErrorTableModel(SwingValidatorMessageTableModel errorTableModel) {
        this.errorTableModel = errorTableModel;
        if (errorTableModel != null) {
            errorTableModel.registerValidator(this);
        }
    }

    public void setUiClass(Class<? extends AbstractBeanValidatorUI> uiClass) {
        this.uiClass = uiClass;
    }

    public void setContext(String context) {
        String oldContext = this.getContext();
        super.setContext(context);
        if (context == null && oldContext == null || context != null && context.equals(oldContext)) {
            return;
        }
        if (this.fieldRepresentation != null) {
            this.installUIs();
        }
    }

    public void setFieldRepresentation(String fieldname, JComponent c) {
        boolean fieldFound = this.getDelegate().getEffectiveFields().contains(fieldname);
        if (!fieldFound) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("the field '" + fieldname + "' is not defined in validator (no rules on it)"));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("register field [" + fieldname + "] with component : " + c.getName()));
            }
            this.fieldRepresentation.put(fieldname, c);
        }
    }

    public void setFieldRepresentation(Map<String, JComponent> fieldRepresentation) {
        for (Map.Entry<String, JComponent> e : fieldRepresentation.entrySet()) {
            this.setFieldRepresentation(e.getKey(), e.getValue());
        }
    }

    public SwingValidator<?> getParentValidator() {
        return (SwingValidator)super.getParentValidator();
    }

    public void setParentValidator(SwingValidator<?> parentValidator) {
        super.setParentValidator(parentValidator);
    }

    public void installUIs() {
        if (this.fieldRepresentation == null) {
            throw new NullPointerException("fieldRepresentation is null, must init before invoking installUIs method...");
        }
        if (this.uiClass == null) {
            this.uiClass = DEFAULT_UI_CLASS;
        }
        ArrayListMultimap fieldsByEditor = ArrayListMultimap.create();
        for (Map.Entry<String, JComponent> entry : this.fieldRepresentation.entrySet()) {
            fieldsByEditor.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (JComponent editor : fieldsByEditor.keySet()) {
            Collection fields = fieldsByEditor.get((Object)editor);
            try {
                this.setMessageRepresentation(editor, fields, this.uiClass);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void setMessageRepresentation(JComponent c, Collection<String> fieldnames, Class<? extends AbstractBeanValidatorUI> uiClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Preconditions.checkNotNull((Object)c, (Object)"No editor");
        Container container = c.getParent();
        if (container instanceof JXLayer) {
            JXLayer jx = (JXLayer)container;
            LayerUI oldUI = jx.getUI();
            if (oldUI != null && oldUI instanceof AbstractBeanValidatorUI) {
                this.removeSimpleBeanValidatorListener((AbstractBeanValidatorUI)oldUI);
            }
            Constructor<? extends AbstractBeanValidatorUI> cons = uiClass.getConstructor(Collection.class);
            AbstractBeanValidatorUI ui = cons.newInstance(fieldnames);
            this.addSimpleBeanValidatorListener(ui);
            jx.setUI((LayerUI)ui);
        }
    }

    @Deprecated
    protected void setMessageRepresentation(String fieldname, JComponent old, JComponent c, Class<? extends AbstractBeanValidatorUI> uiClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        JXLayer jx;
        Container container;
        if (old == c) {
            return;
        }
        boolean fieldFound = this.getDelegate().getEffectiveFields().contains(fieldname);
        if (!fieldFound) {
            return;
        }
        if (old != null && (container = old.getParent()) instanceof JXLayer) {
            jx = (JXLayer)container;
            LayerUI ui = jx.getUI();
            if (ui != null && ui instanceof AbstractBeanValidatorUI) {
                this.removeSimpleBeanValidatorListener((AbstractBeanValidatorUI)ui);
            }
            jx.setUI(null);
        }
        if (c != null && (container = c.getParent()) instanceof JXLayer) {
            jx = (JXLayer)container;
            LayerUI oldUI = jx.getUI();
            if (oldUI != null && oldUI instanceof AbstractBeanValidatorUI) {
                this.removeSimpleBeanValidatorListener((AbstractBeanValidatorUI)oldUI);
            }
            Constructor<? extends AbstractBeanValidatorUI> cons = uiClass.getConstructor(String.class);
            AbstractBeanValidatorUI ui = cons.newInstance(fieldname);
            this.addSimpleBeanValidatorListener(ui);
            jx.setUI((LayerUI)ui);
        }
    }
}

