package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import org.jdesktop.beans.AbstractBean;

import java.io.File;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public abstract class AbstractExportMultiPostAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
        extends AbstractTuttiAction<M, UI, H> {

    protected File file;

    protected FishingOperation currentOperation;

    protected MultiPostExportService multiPostImportExportService;

    public AbstractExportMultiPostAction(H handler) {
        super(handler, false);
        multiPostImportExportService = getContext().getMultiPostExportService();
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            EditCatchesUI catchesUI = getUI().getParentContainer(EditCatchesUI.class);
            currentOperation = catchesUI.getModel().getFishingOperation();

            String extension = getFileExtension();
            // choose file to export
            file = saveFile(
                    decorate(currentOperation, DecoratorService.FILE_NAME_COMPATIBLE),
                    extension,
                    getFileChooserTitle(),
                    getFileChooserButton(),
                    "^.*\\." + extension,
                    getFileExtensionDescription()
            );
            doAction = file != null;
        }
        return doAction;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    @Override
    public void releaseAction() {
        file = null;
        currentOperation = null;
        super.releaseAction();
    }

}
