/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.esotericsoftware.yamlbeans.YamlConfig;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Beans {
    private Beans() {
    }

    public static boolean isScalar(Class c) {
        return c.isPrimitive() || c == String.class || c == Integer.class || c == Boolean.class || c == Float.class || c == Long.class || c == Double.class || c == Short.class || c == Byte.class || c == Character.class;
    }

    public static DeferredConstruction getDeferredConstruction(Class type, YamlConfig config) {
        YamlConfig.ConstructorParameters parameters = config.readConfig.constructorParameters.get(type);
        if (parameters != null) {
            return new DeferredConstruction(parameters.constructor, parameters.parameterNames);
        }
        try {
            Class<?> constructorProperties = Class.forName("java.beans.ConstructorProperties");
            for (Constructor<?> typeConstructor : type.getConstructors()) {
                Object annotation = typeConstructor.getAnnotation(constructorProperties);
                if (annotation == null) continue;
                String[] parameterNames = (String[])constructorProperties.getMethod("value", new Class[0]).invoke(annotation, (Object[])null);
                return new DeferredConstruction(typeConstructor, parameterNames);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean canInitializeProperty(Class type, PropertyDescriptor property, YamlConfig config) {
        if (property.getWriteMethod() != null) {
            return true;
        }
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, config);
        return deferredConstruction != null && deferredConstruction.hasParameter(property.getName());
    }

    public static Object createObject(Class type, boolean privateConstructors) throws InvocationTargetException {
        Constructor<Object> constructor = null;
        for (Constructor<?> typeConstructor : type.getConstructors()) {
            if (typeConstructor.getParameterTypes().length != 0) continue;
            constructor = typeConstructor;
            break;
        }
        if (constructor == null && privateConstructors) {
            try {
                constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (SecurityException ignored) {
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        if (constructor == null) {
            try {
                if (List.class.isAssignableFrom(type)) {
                    constructor = ArrayList.class.getConstructor(new Class[0]);
                } else if (Set.class.isAssignableFrom(type)) {
                    constructor = HashSet.class.getConstructor(new Class[0]);
                } else if (Map.class.isAssignableFrom(type)) {
                    constructor = HashMap.class.getConstructor(new Class[0]);
                }
            }
            catch (Exception ex) {
                throw new InvocationTargetException(ex, "Error getting constructor for class: " + type.getName());
            }
        }
        if (constructor == null) {
            throw new InvocationTargetException(null, "Unable to find a no-arg constructor for class: " + type.getName());
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new InvocationTargetException(ex, "Error constructing instance of class: " + type.getName());
        }
    }

    public static Set<Property> getProperties(Class type, boolean beanProperties, boolean privateFields, YamlConfig config) throws IntrospectionException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        TreeSet<Property> properties = new TreeSet<Property>();
        if (beanProperties) {
            for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (property.getReadMethod() == null || !Beans.canInitializeProperty(type, property, config)) continue;
                properties.add(new MethodProperty(type, property));
            }
        }
        for (Field field : Beans.getAllFields(type)) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            if (!Modifier.isPublic(modifiers)) {
                if (!privateFields) continue;
                field.setAccessible(true);
            }
            properties.add(new FieldProperty(field));
        }
        return properties;
    }

    public static Property getProperty(Class type, String name, boolean beanProperties, boolean privateFields, YamlConfig config) throws IntrospectionException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        if (beanProperties) {
            for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (!property.getName().equals(name)) continue;
                if (property.getReadMethod() == null || !Beans.canInitializeProperty(type, property, config)) break;
                return new MethodProperty(type, property);
            }
        }
        for (Field field : Beans.getAllFields(type)) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            if (!Modifier.isPublic(modifiers)) {
                if (!privateFields) continue;
                field.setAccessible(true);
            }
            if (!field.getName().equals(name)) continue;
            return new FieldProperty(field);
        }
        return null;
    }

    private static ArrayList<Field> getAllFields(Class type) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allFields, nextClass.getDeclaredFields());
        }
        return allFields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Property
    implements Comparable<Property> {
        private final Class declaringClass;
        private final String name;
        private final Class type;

        public Property(Class declaringClass, String name, Class type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Property o) {
            int comparison = this.name.compareTo(o.name);
            if (comparison != 0) {
                if (this.name.equals("id")) {
                    return -1;
                }
                if (o.name.equals("id")) {
                    return 1;
                }
                if (this.name.equals("name")) {
                    return -1;
                }
                if (o.name.equals("name")) {
                    return 1;
                }
            }
            return comparison;
        }

        public abstract void set(Object var1, Object var2) throws Exception;

        public abstract Object get(Object var1) throws Exception;
    }

    public static class FieldProperty
    extends Property {
        private final Field field;

        public FieldProperty(Field field) {
            super(field.getDeclaringClass(), field.getName(), field.getType());
            this.field = field;
        }

        public void set(Object object, Object value) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, value);
                return;
            }
            this.field.set(object, value);
        }

        public Object get(Object object) throws Exception {
            return this.field.get(object);
        }
    }

    public static class MethodProperty
    extends Property {
        private final PropertyDescriptor property;

        public MethodProperty(Class declaringClass, PropertyDescriptor property) {
            super(declaringClass, property.getName(), property.getPropertyType());
            this.property = property;
        }

        public void set(Object object, Object value) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, value);
                return;
            }
            this.property.getWriteMethod().invoke(object, value);
        }

        public Object get(Object object) throws Exception {
            return this.property.getReadMethod().invoke(object, new Object[0]);
        }
    }
}

