/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGenerator;
import liquibase.statement.core.InsertOrUpdateStatement;

public class InsertOrUpdateGeneratorMySQL
extends InsertOrUpdateGenerator {
    public boolean supports(InsertOrUpdateStatement statement, Database database) {
        return database instanceof MySQLDatabase;
    }

    protected String getInsertStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuffer sql = new StringBuffer(super.getInsertStatement(insertOrUpdateStatement, database, sqlGeneratorChain));
        sql.deleteCharAt(sql.lastIndexOf(";"));
        StringBuffer updateClause = new StringBuffer("ON DUPLICATE KEY UPDATE ");
        String[] pkFields = insertOrUpdateStatement.getPrimaryKey().split(",");
        HashSet<String> hashPkFields = new HashSet<String>(Arrays.asList(pkFields));
        boolean hasFields = false;
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            if (hashPkFields.contains(columnKey)) continue;
            hasFields = true;
            updateClause.append(columnKey).append(" = ");
            updateClause.append(this.convertToString(insertOrUpdateStatement.getColumnValue(columnKey), database));
            updateClause.append(",");
        }
        if (hasFields) {
            updateClause.deleteCharAt(updateClause.lastIndexOf(","));
            sql.append(updateClause);
        } else {
            sql.insert(sql.indexOf("INSERT ") + "INSERT ".length(), "IGNORE ");
        }
        return sql.toString();
    }

    protected String getUpdateStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause, SqlGeneratorChain sqlGeneratorChain) {
        return "";
    }

    protected String getRecordCheck(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause) {
        return "";
    }

    protected String getElse(Database database) {
        return "";
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null || newValue.toString().equals("") || newValue.toString().equalsIgnoreCase("NULL") ? "NULL" : (newValue instanceof String && database.shouldQuoteValue((String)newValue) ? "'" + database.escapeStringForDatabase(newValue.toString()) + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (((Boolean)newValue).booleanValue() ? TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getTrueBooleanValue() : TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue()) : newValue.toString())));
        return sqlString;
    }
}

