#!/bin/bash

BACKUP_DATE=$(date +%Y%m%d%H%M%S)

if [ -d NEW/jre ]; then
  oldVersion=`cat jre/version.appup`
  newVersion=`cat NEW/jre/version.appup`
  echo "Update jre version $oldVersion to $newVersion"
  mkdir -p OLD
  backupdir=OLD/jre-$oldVersion-$BACKUP_DATE
  echo "Backup jre old version to $backupdir"
  mv jre $backupdir
  mv NEW/jre .
  chmod +x jre/bin/java
fi

if [ -d NEW/tutti ]; then
  oldVersion=`cat tutti/version.appup`
  newVersion=`cat NEW/tutti/version.appup`
  echo "Update tutti version $oldVersion to $newVersion"
  mkdir -p OLD
  backupdir=OLD/tutti-$oldVersion-$BACKUP_DATE
  echo "Backup tutti old version to $backupdir"
  mv tutti $backupdir
  mv NEW/tutti .
  chmod +x tutti/update.sh
  chmod +x tutti/launch.sh
fi

if [ -d NEW/i18n ]; then
  oldVersion=`cat i18n/version.appup`
  newVersion=`cat NEW/i18n/version.appup`
  echo "Update i18n version $oldVersion to $newVersion"
  mkdir -p OLD
  backupdir=OLD/i18n-$oldVersion-$BACKUP_DATE
  echo "Backup i18n old version to $backupdir"
  mv i18n $backupdir
  mv NEW/i18n .
fi

if [ -d NEW/help ]; then
  oldVersion=`cat help/version.appup`
  newVersion=`cat NEW/help/version.appup`
  echo "Update help version $oldVersion to $newVersion"
  mkdir -p OLD
  backupdir=OLD/help-$oldVersion-$BACKUP_DATE
  echo "Backup help old version to $backupdir"
  mv help $backupdir
  mv NEW/help .
fi

if [ -d NEW/report ]; then
  oldVersion=`cat report/version.appup`
  newVersion=`cat NEW/report/version.appup`
  echo "Update report version $oldVersion to $newVersion"
  mkdir -p OLD
  backupdir=OLD/report-$oldVersion-$BACKUP_DATE
  echo "Backup report old version to $backupdir"
  mv report $backupdir
  mv NEW/report .
fi

rm -rf NEW
