/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.executor.Executor;
import liquibase.executor.jvm.CallableStatementCallback;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.ResultSetExtractor;
import liquibase.executor.jvm.RowCallbackHandler;
import liquibase.executor.jvm.RowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.executor.jvm.SingleColumnRowMapper;
import liquibase.executor.jvm.StatementCallback;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.snapshot.jvm.JdbcDatabaseSnapshotGenerator;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.CallableSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.StoredProcedureStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcExecutor
extends AbstractExecutor
implements Executor {
    private Logger log = LogFactory.getLogger();

    @Override
    public boolean updatesDatabase() {
        return true;
    }

    public Object execute(StatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            Statement stmtToUse = stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
            object = action.doInStatement(stmtToUse);
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                throw new DatabaseException("Error executing SQL " + StringUtils.join(this.applyVisitors(action.getStatement(), sqlVisitors), "; on " + con.getURL()) + ": " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return object;
    }

    @Override
    public void execute(SqlStatement sql) throws DatabaseException {
        this.execute(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public void execute(final SqlStatement sql, final List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            this.call((CallableSqlStatement)sql, new ArrayList(), sqlVisitors);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ExecuteStatementCallback
        implements StatementCallback {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
                for (String statement : JdbcExecutor.this.applyVisitors(sql, sqlVisitors)) {
                    if (JdbcExecutor.this.database instanceof OracleDatabase) {
                        statement = statement.replaceFirst("/\\s*/\\s*$", "");
                    }
                    JdbcExecutor.this.log.debug("Executing EXECUTE database command: " + statement);
                    if (statement.contains("?")) {
                        stmt.setEscapeProcessing(false);
                    }
                    stmt.execute(statement);
                }
                return null;
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback(), sqlVisitors);
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse) throws DatabaseException {
        return this.query(sql, rse, new ArrayList<SqlVisitor>());
    }

    public Object query(final SqlStatement sql, final ResultSetExtractor rse, final List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            throw new DatabaseException("Direct query using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QueryStatementCallback
        implements StatementCallback {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
                Object object;
                ResultSet rs = null;
                try {
                    String[] sqlToExecute = JdbcExecutor.this.applyVisitors(sql, sqlVisitors);
                    if (sqlToExecute.length != 1) {
                        throw new DatabaseException("Can only query with statements that return one sql statement");
                    }
                    JdbcExecutor.this.log.debug("Executing QUERY database command: " + sqlToExecute[0]);
                    ResultSet rsToUse = rs = stmt.executeQuery(sqlToExecute[0]);
                    object = rse.extractData(rsToUse);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return object;
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback(), sqlVisitors);
    }

    public List query(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.query(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public List query(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (List)this.query(sql, new RowMapperResultSetExtractor(rowMapper), sqlVisitors);
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.queryForObject(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        List results = this.query(sql, rowMapper, sqlVisitors);
        return JdbcUtils.requiredSingleResult(results);
    }

    @Override
    public Object queryForObject(SqlStatement sql, Class requiredType) throws DatabaseException {
        return this.queryForObject(sql, requiredType, new ArrayList<SqlVisitor>());
    }

    @Override
    public Object queryForObject(SqlStatement sql, Class requiredType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType), sqlVisitors);
    }

    @Override
    public long queryForLong(SqlStatement sql) throws DatabaseException {
        return this.queryForLong(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = (Number)this.queryForObject(sql, Long.class, sqlVisitors);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(SqlStatement sql) throws DatabaseException {
        return this.queryForInt(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = (Number)this.queryForObject(sql, Integer.class, sqlVisitors);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        return this.queryForList(sql, elementType, new ArrayList<SqlVisitor>());
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType), sqlVisitors);
    }

    @Override
    public List<Map> queryForList(SqlStatement sql) throws DatabaseException {
        return this.queryForList(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public List<Map> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getColumnMapRowMapper(), sqlVisitors);
    }

    @Override
    public int update(SqlStatement sql) throws DatabaseException {
        return this.update(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int update(final SqlStatement sql, final List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            throw new DatabaseException("Direct update using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateStatementCallback
        implements StatementCallback {
            UpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
                String[] sqlToExecute = JdbcExecutor.this.applyVisitors(sql, sqlVisitors);
                if (sqlToExecute.length != 1) {
                    throw new DatabaseException("Cannot call update on Statement that returns back multiple Sql objects");
                }
                JdbcExecutor.this.log.debug("Executing UPDATE database command: " + sqlToExecute[0]);
                return stmt.executeUpdate(sqlToExecute[0]);
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(), sqlVisitors);
    }

    public Object execute(CallableSqlStatement csc, CallableStatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        CallableStatement cs = null;
        try {
            CallableStatement csToUse = cs = this.createCallableStatement((StoredProcedureStatement)csc, this.database);
            object = action.doInCallableStatement(csToUse);
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error executing callable statement", ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(cs);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(cs);
        return object;
    }

    public CallableStatement createCallableStatement(StoredProcedureStatement statement, Database database) throws SQLException {
        StringBuffer sql = new StringBuffer("{call " + statement.getProcedureName());
        List<String> parameters = statement.getParameters();
        if (parameters.size() > 0) {
            sql.append("(");
            for (String param : parameters) {
                sql.append("?,");
            }
            sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append(")");
        }
        sql.append("}");
        CallableStatement pstmt = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().prepareCall(sql.toString());
        for (int i = 0; i < parameters.size(); ++i) {
            String param = parameters.get(i);
            int type = ((JdbcDatabaseSnapshotGenerator)DatabaseSnapshotGeneratorFactory.getInstance().getGenerator(database)).getDatabaseType(statement.getParameterType(param), database);
            if (param == null) {
                pstmt.setNull(i + 1, type);
                continue;
            }
            pstmt.setObject(i + 1, (Object)param, type);
        }
        return pstmt;
    }

    @Override
    public Map call(CallableSqlStatement csc, List declaredParameters, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (Map)this.execute(csc, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException {
                cs.execute();
                return new HashMap();
            }
        }, sqlVisitors);
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    @Override
    public void comment(String message) throws DatabaseException {
        LogFactory.getLogger().debug(message);
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }
}

