/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroResult;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroService;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import java.io.File;
import java.util.Properties;

public class TuttiReferentialSynchronizeService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    protected ReferentialSynchroService synchroService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.synchroService = TuttiPersistenceServiceLocator.getReferentialSynchroService();
        this.persistenceService = this.getService(PersistenceService.class);
    }

    public void prepare(File dbDirectory, ReferentialSynchroResult result) {
        Properties remoteConnectionProperties = this.getRemoteProperties(dbDirectory);
        this.synchroService.prepare(remoteConnectionProperties, result);
    }

    public void synchronize(File dbDirectory, ReferentialSynchroResult result) {
        Properties remoteConnectionProperties = this.getRemoteProperties(dbDirectory);
        this.synchroService.synchronize(remoteConnectionProperties, result);
    }

    protected Properties getRemoteProperties(File dbDirectory) {
        Properties remoteConnectionProperties = new Properties();
        TuttiConfiguration config = this.context.getConfig();
        String jdbcUrl = TuttiEntities.getJdbcUrl((File)dbDirectory, (String)config.getDbName());
        TuttiEntities.fillConnectionProperties((Properties)remoteConnectionProperties, (String)jdbcUrl, (String)config.getJdbcUsername(), (String)config.getJdbcPassword());
        return remoteConnectionProperties;
    }
}

