/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.util.Collection;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.w3c.dom.css.CSSValue;

public class StyleEntryWriter {
    protected final String RIGHT = "right";
    protected final String LEFT = "left";
    protected final String TOP = "top";
    protected final String BOTTOM = "bottom";
    protected XMLWriter writer;
    private int reportDpi;
    private static final int[] PADDING_PROPS = new int[]{39, 38, 40, 41};
    private static final int[] BORDER_STYLE_PROPS = new int[]{11, 14, 17, 20};
    private static final int[] BORDER_COLOR_PROPS = new int[]{10, 13, 16, 19};
    private static final int[] BORDER_WIDTH_PROPS = new int[]{12, 15, 18, 21};
    private static final int[] MARGIN_PROPS = new int[]{43, 42, 44, 45};
    private static final String[] SIDES = new String[]{"bottom", "top", "left", "right"};

    public StyleEntryWriter(XMLWriter writer, int reportDpi) {
        this.writer = writer;
        this.reportDpi = reportDpi;
    }

    public void writeDefaultStyle(StyleEntry aStyle) {
        this.writer.openTag("style:default-style");
        this.writeStyleEntry(aStyle);
        this.writer.closeTag("style:default-style");
    }

    public void writeStyle(StyleEntry aStyle) {
        if (aStyle.getType() != 6) {
            this.writer.openTag("style:style");
            this.writeStyleEntry(aStyle);
            this.writer.closeTag("style:style");
        } else {
            this.writer.openTag("style:page-layout");
            this.writer.attribute("style:name", aStyle.getName());
            this.writePageLayout(aStyle);
            this.writer.closeTag("style:page-layout");
        }
    }

    private void writeStyleEntry(StyleEntry aStyle) {
        this.writer.attribute("style:name", aStyle.getName());
        switch (aStyle.getType()) {
            case 0: {
                this.writeParagraphStyle(aStyle, false);
                this.writeTextProperties(aStyle);
                break;
            }
            case 1: {
                this.writeTextStyle(aStyle);
                break;
            }
            case 2: {
                this.writeTableStyle(aStyle);
                break;
            }
            case 3: {
                this.writeTableColumnStyle(aStyle);
                break;
            }
            case 4: {
                this.writeTableRowStyle(aStyle);
                break;
            }
            case 5: {
                this.writeTableCellStyle(aStyle);
                if (aStyle.getProperty(8) != null) {
                    this.writeParagraphProperties(aStyle, true);
                }
                if (aStyle.getProperty(0) == null) break;
                this.writeTextProperties(aStyle);
                break;
            }
            case 7: {
                this.writeGraphicStyle(aStyle);
            }
        }
    }

    private void writeTableStyle(StyleEntry aStyle) {
        this.writer.attribute("style:family", "table");
        String masterPage = aStyle.getStringProperty(58);
        if (masterPage != null) {
            this.writer.attribute("style:master-page-name", masterPage);
        }
        this.writer.openTag("style:table-properties");
        this.writer.attribute("table:border-model", "collapsing");
        String direction = aStyle.getStringProperty(27);
        String tableAlign = "rtl".equals(direction) ? "right" : "left";
        this.writer.attribute("table:align", tableAlign);
        Double tableWidth = aStyle.getDoubleProperty(35);
        if (tableWidth != null) {
            this.writeTableWidth(tableWidth);
        }
        this.writeBorders(aStyle);
        this.writeBackgroundColor(aStyle.getStringProperty(6));
        this.writeAlign(aStyle);
        this.writePageBreaks(aStyle);
        this.writer.closeTag("style:table-properties");
    }

    private void writePageBreaks(StyleEntry aStyle) {
        String breakBefore = aStyle.getStringProperty(57);
        if (breakBefore != null && !"auto".equals(breakBefore)) {
            this.writer.attribute("fo:break-before", breakBefore);
        }
    }

    private void writeTableColumnStyle(StyleEntry aStyle) {
        this.writer.attribute("style:family", "table-column");
        this.writer.openTag("style:table-column-properties");
        Double width = aStyle.getDoubleProperty(35);
        if (width != null && width >= 0.0) {
            this.writer.attribute("style:column-width", this.getDimension(width));
        }
        this.writer.closeTag("style:table-column-properties");
    }

    private void writeTableRowStyle(StyleEntry style) {
        Double minHeight;
        this.writer.attribute("style:family", "table-row");
        this.writer.openTag("style:table-row-properties");
        Double height = style.getDoubleProperty(36);
        if (height != null && height > 0.0) {
            this.writer.attribute("style:row-height", this.getDimension(height));
        }
        if ((minHeight = style.getDoubleProperty(64)) != null && minHeight > 0.0) {
            this.writer.attribute("style:min-row-height", this.getDimension(minHeight));
        } else {
            this.writer.attribute("style:use-optimal-row-height", "true");
        }
        this.writer.closeTag("style:table-row-properties");
    }

    private void writeTableCellStyle(StyleEntry aStyle) {
        this.writer.attribute("style:family", "table-cell");
        this.writer.openTag("style:table-cell-properties");
        Double cellWidth = aStyle.getDoubleProperty(35);
        if (cellWidth != null) {
            this.writeCellWidth(cellWidth.intValue());
        }
        this.writeCellProperties(aStyle);
        this.writeAlign(aStyle);
        this.writeBackgroundImage(aStyle);
        this.writer.closeTag("style:table-cell-properties");
    }

    private void writeCellWidth(double width) {
        if (width >= 0.0) {
            this.writer.attribute("style:width", this.getDimension(width));
        }
    }

    private void writeBorders(StyleEntry style) {
        this.writeBorders(style, false);
    }

    private void writeGraphicStyle(StyleEntry style) {
        this.writer.attribute("style:family", "graphic");
        this.writer.attribute("style:parent-style-name", "Graphics");
        this.writer.openTag("style:graphic-properties");
        this.writeBorders(style);
        this.writeBackgroundColor(style.getStringProperty(6));
        this.writeFrameStyle(style);
        this.writer.openTag("style:background-image");
        this.writer.closeTag("style:background-image");
        this.writer.closeTag("style:graphic-properties");
    }

    private void writeFrameStyle(StyleEntry style) {
        String color;
        String stroke;
        String fillColor;
        String fill = style.getStringProperty(61);
        if (fill != null) {
            this.writer.attribute("draw:fill", fill);
        }
        if ((fillColor = style.getStringProperty(62)) != null) {
            this.writer.attribute("draw:fill-color", fillColor);
        }
        if ((stroke = style.getStringProperty(60)) != null) {
            this.writer.attribute("draw:stroke", stroke);
        }
        Double strokeWidth = style.getDoubleProperty(63);
        if (stroke != null) {
            this.writer.attribute("svg:stroke-width", this.getDimension(strokeWidth));
        }
        if ((color = style.getStringProperty(7)) != null) {
            this.writer.attribute("svg:stroke-color", color);
        }
    }

    public void writeParagraphStyle(StyleEntry aStyle, boolean noCellProps) {
        this.writer.attribute("style:family", "paragraph");
        this.writer.attribute("style:parent-style-name", "Standard");
        String masterPage = aStyle.getStringProperty(58);
        if (masterPage != null) {
            this.writer.attribute("style:master-page-name", masterPage);
        }
        this.writeParagraphProperties(aStyle, noCellProps);
    }

    private void writeParagraphProperties(StyleEntry aStyle, boolean noCellProps) {
        this.writer.openTag("style:paragraph-properties");
        CSSValue lineHeight = (CSSValue)aStyle.getProperty(46);
        if (lineHeight != null && !"normal".equalsIgnoreCase(lineHeight.getCssText())) {
            this.writeSpacing(lineHeight);
        }
        if (!noCellProps) {
            this.writeBackgroundColor(aStyle.getStringProperty(6));
            this.writeBorders(aStyle, true);
            this.writePaddings(aStyle);
        }
        this.writeAlign(aStyle);
        this.writeIndent(aStyle);
        this.writePageBreaks(aStyle);
        this.writeBackgroundImage(aStyle);
        this.writer.closeTag("style:paragraph-properties");
    }

    public void writeTextStyle(StyleEntry style) {
        this.writer.attribute("style:family", "text");
        this.writeTextProperties(style);
    }

    private void writeTextProperties(StyleEntry style) {
        this.writer.openTag("style:text-properties");
        Boolean isHidden = style.getBoolProperty(37);
        if (isHidden != null && isHidden.booleanValue()) {
            this.writer.attribute("text:display", "none");
        }
        this.writeFont(style.getStringProperty(0));
        this.writeFontStyle(style);
        this.writeFontWeight(style);
        this.writeFontSize(style);
        this.writeTextColor(style);
        this.writeLetterSpacing(style);
        this.writeTextUnderline(style);
        this.writeTextLineThrough(style);
        this.writeTextTransform(style);
        this.writer.closeTag("style:text-properties");
    }

    private void writeTextTransform(StyleEntry style) {
        String textTransform = style.getStringProperty(26);
        if (textTransform != null && !"none".equals(textTransform)) {
            this.writer.attribute("fo:text-transform", textTransform);
        }
    }

    private void writeSpacing(CSSValue spacing) {
        if (spacing != null) {
            this.writer.attribute("fo:line-height", this.getDimension(spacing));
        }
    }

    protected void writeBackgroundColor(String color) {
        String cssColor = OdfUtil.parseColor(color);
        if (cssColor == null) {
            return;
        }
        this.writer.attribute("fo:background-color", cssColor);
    }

    private void writeMargins(StyleEntry style) {
        int i = 0;
        while (i < MARGIN_PROPS.length) {
            String margin = this.getDimension(style.getProperty(MARGIN_PROPS[i]));
            if (margin != null) {
                this.writer.attribute("fo:margin-" + SIDES[i], margin);
            }
            ++i;
        }
    }

    private void writeCellBorders(StyleEntry style) {
        this.writeBorders(style, false);
    }

    protected void writeBorders(StyleEntry style, boolean includeMargins) {
        int i = 0;
        while (i < 4) {
            String borderStyle = style.getStringProperty(BORDER_STYLE_PROPS[i]);
            if (this.hasBorder(borderStyle)) {
                this.writeSingleBorder(SIDES[i], borderStyle, style.getStringProperty(BORDER_COLOR_PROPS[i]), this.getDimension(style.getProperty(BORDER_WIDTH_PROPS[i])), includeMargins ? this.getDimension(style.getProperty(MARGIN_PROPS[i])) : null);
            }
            ++i;
        }
    }

    protected void writePaddings(StyleEntry style) {
        int i = 0;
        while (i < PADDING_PROPS.length) {
            CSSValue paddingValue = (CSSValue)style.getProperty(PADDING_PROPS[i]);
            if (paddingValue != null) {
                this.writeSinglePadding(SIDES[i], this.getDimension(paddingValue));
            }
            ++i;
        }
    }

    private void writeSingleBorder(String type, String borderStyle, String color, String width, String margin) {
        this.writer.attribute("fo:border-" + type, String.valueOf(width) + " " + borderStyle + " " + OdfUtil.parseColor(color));
        if (margin != null) {
            this.writer.attribute("fo:margin-" + type, margin);
        }
    }

    private String getDimension(CSSValue width) {
        return this.getDimension(OdfUtil.getDimensionValue(width, this.reportDpi));
    }

    private void writeSinglePadding(String type, String value) {
        this.writer.attribute("fo:padding-" + type, value);
    }

    protected void writeAlign(StyleEntry style) {
        String verticalAlign;
        String align = style.getStringProperty(8);
        if (align != null) {
            this.writer.attribute("fo:text-align", align);
        }
        if ((verticalAlign = style.getStringProperty(9)) != null) {
            this.writer.attribute("style:vertical-align", verticalAlign);
        }
    }

    private void writeTextColor(StyleEntry style) {
        String val = OdfUtil.parseColor(style.getStringProperty(7));
        if (val != null) {
            this.writer.attribute("fo:color", val);
        }
    }

    private void writeTextUnderline(StyleEntry style) {
        Boolean overline;
        Boolean underline = style.getBoolProperty(5);
        if (underline != null && underline.booleanValue()) {
            this.writer.attribute("style:text-underline-type", "single");
        }
        if ((overline = style.getBoolProperty(59)) != null && overline.booleanValue()) {
            this.writer.attribute("style:text-overline-type", "single");
        }
    }

    private void writeTextLineThrough(StyleEntry style) {
        Boolean lineThrough = style.getBoolProperty(4);
        if (lineThrough != null && lineThrough.booleanValue()) {
            this.writer.attribute("style:text-line-through-type", "single");
        }
    }

    private void writeLetterSpacing(StyleEntry style) {
        CSSValue spacing = (CSSValue)style.getProperty(47);
        if (spacing != null) {
            double letterSpacing = OdfUtil.getDimensionValue((CSSValue)style.getProperty(47), this.reportDpi);
            this.writer.attribute("fo:letter-spacing", this.getDimension(letterSpacing));
        }
    }

    private void writeCellProperties(StyleEntry style) {
        if (style == null) {
            return;
        }
        this.writer.attribute("style:text-align-source", "fix");
        this.writeBackgroundColor(style.getStringProperty(6));
        this.writeCellBorders(style);
        this.writePaddings(style);
        this.writer.attribute("fo:wrap-option", "nowrap".equalsIgnoreCase(style.getStringProperty(28)) ? "no-wrap" : "wrap");
    }

    private void writeBackgroundImage(StyleEntry style) {
        String url = style.getStringProperty(51);
        if (url == null || url.length() == 0) {
            return;
        }
        this.writer.openTag("style:background-image");
        if (url != null) {
            String repeat = style.getStringProperty(56);
            this.writer.attribute("xlink:href", url);
            String width = style.getStringProperty(52);
            String height = style.getStringProperty(53);
            if ("cover".equals(width) || "cover".equals(height)) {
                repeat = "stretch";
            }
            if ("no-repeat".equals(repeat)) {
                String leftPos = style.getStringProperty(54);
                String topPos = style.getStringProperty(55);
                leftPos = "100%".equals(leftPos) ? "right" : ("50%".equals(leftPos) ? "center" : "left");
                topPos = "100%".equals(topPos) ? "bottom" : ("50%".equals(topPos) ? "center" : "top");
                this.writer.attribute("style:position", String.valueOf(leftPos) + " " + topPos);
            }
            this.writer.attribute("style:repeat", repeat);
        }
        this.writer.closeTag("style:background-image");
    }

    protected void writeFontSize(StyleEntry styleEntry) {
        double size = 0.0;
        Double sizeDouble = styleEntry.getDoubleProperty(1);
        if (sizeDouble != null) {
            size = sizeDouble;
        } else {
            CSSValue fontSize = (CSSValue)styleEntry.getProperty(1);
            if (fontSize != null) {
                size = OdfUtil.parseFontSize(PropertyUtil.getDimensionValue(fontSize));
            }
        }
        if (size > 0.0) {
            this.writer.attribute("fo:font-size", String.valueOf(size) + "pt");
            this.writer.attribute("style:font-size-asian", String.valueOf(size) + "pt");
            this.writer.attribute("style:font-size-complex", String.valueOf(size) + "pt");
        }
    }

    protected void writeFont(String fontFamily) {
        if (fontFamily != null && !"NULL".equals(fontFamily)) {
            this.writer.attribute("fo:font-family", fontFamily);
            this.writer.attribute("style:font-family-asian", fontFamily);
            this.writer.attribute("style:font-family-complex", fontFamily);
        }
    }

    protected void writeFontStyle(StyleEntry styleEntry) {
        String val = styleEntry.getStringProperty(2);
        if (!"normal".equalsIgnoreCase(val)) {
            this.writer.attribute("fo:font-style", val);
            this.writer.attribute("style:font-style-asian", val);
            this.writer.attribute("style:font-style-complex", val);
        }
    }

    protected void writeFontWeight(StyleEntry styleEntry) {
        String weight = styleEntry.getStringProperty(3);
        if (weight != null && !"normal".equals(weight)) {
            this.writer.attribute("fo:font-weight", weight);
            this.writer.attribute("style:font-weight-asian", weight);
            this.writer.attribute("style:font-weight-complex", weight);
        }
    }

    private boolean hasBorder(String borderStyle) {
        return borderStyle != null && !"none".equalsIgnoreCase(borderStyle);
    }

    private void writeTableWidth(double tableWidth) {
        if (tableWidth >= 0.0) {
            this.writer.attribute("style:width", this.getDimension(tableWidth));
        }
    }

    private void writeIndent(StyleEntry style) {
        CSSValue value = (CSSValue)style.getProperty(65);
        if (value != null) {
            this.writer.attribute("fo:text-indent", this.getDimension(value));
        }
    }

    private String getDimension(Double value) {
        if (value != null) {
            value = (double)Math.round(value * 1000.0) / 1000.0;
            return value + "in";
        }
        return "";
    }

    private String getDimension(Object value) {
        if (value == null) {
            return "0in";
        }
        if (value instanceof CSSValue) {
            return this.getDimension((CSSValue)value);
        }
        if (value instanceof DimensionType) {
            return this.getDimension(OdfUtil.convertTo((DimensionType)value, this.reportDpi));
        }
        return value.toString();
    }

    private void writePageLayout(StyleEntry style) {
        this.writer.openTag("style:page-layout-properties");
        this.writePageLayoutProperties(style);
        this.writer.closeTag("style:page-layout-properties");
        this.writer.openTag("style:header-style");
        this.writer.openTag("style:header-footer-properties");
        this.writer.attribute("fo:min-height", this.getDimension(style.getProperty(48)));
        this.writer.closeTag("style:header-footer-properties");
        this.writer.closeTag("style:header-style");
        this.writer.openTag("style:footer-style");
        this.writer.openTag("style:header-footer-properties");
        this.writer.attribute("fo:min-height", this.getDimension(style.getIntegerProperty(49)));
        this.writer.closeTag("style:header-footer-properties");
        this.writer.closeTag("style:footer-style");
    }

    private void writePageLayoutProperties(StyleEntry style) {
        this.writeMargins(style);
        this.writeBorders(style);
        this.writeBackgroundColor(style.getStringProperty(6));
        this.writer.attribute("style:print-orientation", style.getStringProperty(50));
        this.writer.attribute("fo:page-width", this.getDimension(style.getProperty(35)));
        this.writer.attribute("fo:page-height", this.getDimension(style.getProperty(36)));
        this.writer.attribute("style:num-format", "1");
        String direction = style.getStringProperty(27);
        if ("rtl".equals(direction)) {
            this.writer.attribute("style:writing-mode", "rl");
        } else {
            this.writer.attribute("style:writing-mode", "lr");
        }
        this.writeBackgroundImage(style);
    }

    public void writeStyles(Collection<StyleEntry> styles) {
        if (styles == null) {
            return;
        }
        for (StyleEntry style : styles) {
            this.writeStyle(style);
        }
    }
}

