/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import jaxx.runtime.swing.MemoryStatusWidget;
import org.nuiton.i18n.I18n;

public class MemoryStatusWidgetHandler {
    private static final String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc = new FontRenderContext(null, false, false);
    private LineMetrics lm = new JLabel().getFont().getLineMetrics("99999/99999Mb", this.frc);
    protected final MemoryStatusWidget ui;

    public MemoryStatusWidgetHandler(MemoryStatusWidget ui) {
        this.ui = ui;
    }

    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)(runtime.freeMemory() / 1024L);
        int totalMemory = (int)(runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = this.ui.getWidth() - insets.left - insets.right;
        int height = this.ui.getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float)usedMemory / (float)totalMemory;
        g.setColor(this.ui.progressBackground);
        g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
        String str = I18n.t((String)"memorywidget.memory", (Object[])new Object[]{usedMemory / 1024, totalMemory / 1024});
        Rectangle2D bounds = g.getFont().getStringBounds(str, this.frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top, (int)((float)width * fraction), height);
        g2.setColor(this.ui.progressForeground);
        g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.ui.getWidth() - insets.left - (int)((float)width * fraction), height);
        g2.setColor(this.ui.getForeground());
        g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
        g2.dispose();
    }

    void $afterCompleteSetup() {
        this.ui.setFont(new JLabel().getFont());
        Rectangle2D bounds = this.ui.getFont().getStringBounds(memoryTestStr, this.frc);
        Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        this.ui.setPreferredSize(dim);
        this.ui.setMaximumSize(dim);
    }
}

