/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.service.pupitri.PupitriImportResult;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public class ImportPupitriAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected File importedTrunkFile;
    protected File importedCarrouselFile;
    protected ImportPupitriPopupUI importPupitriDialog;
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected EditFishingOperationAction editAction;
    protected PupitriImportResult importResult;

    public ImportPupitriAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        this.importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (this.editAction == null) {
            FishingOperationsUI parentContainer = (FishingOperationsUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(FishingOperationsUI.class);
            this.editAction = (EditFishingOperationAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)parentContainer.getHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    public boolean prepareAction() throws Exception {
        SpeciesBatchUIModel speciesBatchUIModel;
        boolean result = true;
        TuttiEnumerationFile enumerationFile = this.persistenceService.getEnumerationFile();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        ArrayList missingCategories = Lists.newArrayList();
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SIZE_CATEGORY)) {
            missingCategories.add("<li>" + this.persistenceService.getSizeCategoryCaracteristic().getParameterName() + "</li>");
        }
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SEX)) {
            missingCategories.add("<li>" + this.persistenceService.getSexCaracteristic().getParameterName() + "</li>");
        }
        if (!missingCategories.isEmpty()) {
            result = false;
            JOptionPane.showMessageDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.message", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)missingCategories)}), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.title", (Object[])new Object[0]), 0, UIManager.getIcon("error"));
        }
        if (result && (speciesBatchUIModel = ((SpeciesBatchUI)this.getUI()).getModel()).getRowCount() > 0) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.title", (Object[])new Object[0]), 2, 2);
            boolean bl = result = answer == 0;
        }
        if (result) {
            this.importPupitriDialog.open();
            this.importedTrunkFile = this.importPupitriDialog.getTrunkFile().getSelectedFile();
            this.importedCarrouselFile = this.importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = this.importedTrunkFile != null && this.importedCarrouselFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PupitriImportExportService importExportService = this.getContext().getTuttiPupitriImportExportService();
        EditCatchesUI parentContainer = (EditCatchesUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel model = parentContainer.getModel();
        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.toEntity();
        this.importResult = importExportService.importPupitri(this.importedTrunkFile, this.importedCarrouselFile, operation, catchBatch);
        if (this.importResult.isFishingOperationFound()) {
            this.getEditAction().loadCatchBatch(operation);
        }
    }

    public void releaseAction() {
        super.releaseAction();
        this.importedTrunkFile = null;
        this.importedCarrouselFile = null;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.importResult.isFishingOperationFound()) {
            int rejectedSpeciesNb = this.importResult.getNbCarrousselNotImported();
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.success", (Object[])new Object[]{((SpeciesBatchUIModel)this.getModel()).getRootNumber(), rejectedSpeciesNb}));
        } else {
            this.displayWarningMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.fishingOperation.title", (Object[])new Object[0]), "<html><body>" + I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.fishingOperation", (Object[])new Object[0]) + "</body></html>");
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.data", (Object[])new Object[0]));
        }
    }
}

