/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.ui.swing.action.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;
import javax.swing.JTextArea;
import org.nuiton.i18n.I18n;

public class ImportMarineLitterMultiPostAction
extends AbstractImportMultiPostAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {
    protected Map<String, Object> notImportedData;

    public ImportMarineLitterMultiPostAction(MarineLitterBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiMarineLitter";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n.t((String)"tutti.common.file.tuttiMarineLitter", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    public void releaseAction() {
        this.notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        this.notImportedData = this.multiPostImportExportService.importMarineLitter(this.file, operation);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (!this.notImportedData.isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog)this.getContext().getActionUI());
            Collection notImportedMarineLitterBatches = (Collection)this.notImportedData.get("batchesKey");
            StringBuffer stringBuffer = new StringBuffer();
            Float totalWeight = (Float)this.notImportedData.get("marineLitterTotalWeight");
            if (totalWeight != null) {
                stringBuffer.append("- " + I18n.t((String)"tutti.multiPostImportLog.totalWeight", (Object[])new Object[]{totalWeight}) + "\n");
            }
            for (MarineLitterBatch mlb : notImportedMarineLitterBatches) {
                stringBuffer.append("- " + this.decorate(mlb.getMarineLitterCategory()) + " / " + this.decorate(mlb.getMarineLitterSizeCategory()) + "\n");
            }
            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(this.getContext().getMainUI());
                dialog.setVisible(true);
            }
        }
        this.sendMessage(I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.success", (Object[])new Object[]{this.file}));
    }
}

