package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMarineLitterMultiPostAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ImportMarineLitterMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;

import javax.swing.JTextArea;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMarineLitterMultiPostAction extends AbstractImportMultiPostAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {

    protected Map<String, Object> notImportedData;

    public ImportMarineLitterMultiPostAction(MarineLitterBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiMarineLitter";
    }

    @Override
    protected String getFileExtensionDescription() {
        return t("tutti.common.file.tuttiMarineLitter");
    }

    @Override
    protected String getFileChooserTitle() {
        return t("tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return t("tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    public void releaseAction() {
        notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        notImportedData = multiPostImportExportService.importMarineLitter(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        if (!notImportedData.isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog) getContext().getActionUI());

            Collection<MarineLitterBatch> notImportedMarineLitterBatches =
                    (Collection<MarineLitterBatch>) notImportedData.get(MultiPostImportService.BATCHES_KEY);

            StringBuffer stringBuffer = new StringBuffer();
            Float totalWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_MARINE_LITTER_TOTAL_WEIGHT);
            if (totalWeight != null) {
                stringBuffer.append("- " + t("tutti.multiPostImportLog.totalWeight", totalWeight) + "\n");
            }

            for (MarineLitterBatch mlb : notImportedMarineLitterBatches) {
                stringBuffer.append("- " + decorate(mlb.getMarineLitterCategory()) + " / " + decorate(mlb.getMarineLitterSizeCategory()) + "\n");
            }

            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(getContext().getMainUI());
                dialog.setVisible(true);
            }
        }

        sendMessage(t("tutti.editMarineLitterBatch.action.importMultiPost.success", file));
    }
}
