/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class CachedAggregationResultSet
implements IAggregationResultSet {
    private AggregationDefinition ad;
    private int currentPosition;
    private int length;
    private DimLevel[] levels;
    private String[][] keyNames;
    private String[][] attributeNames;
    private int[][] keyDataTypes;
    private int[][] attributeDataTypes;
    private Map aggregationResultNameMap = null;
    private int[] aggregationDataType;
    private IDiskArray aggregationResultRow;
    private AggregationResultRow resultObject;
    private int[] sortType;
    private String[] aggregationNames;
    private static Logger logger = Logger.getLogger(CachedAggregationResultSet.class.getName());

    CachedAggregationResultSet(DataInputStream inputStream, int length, DimLevel[] levels, int[] sortTypes, String[][] keyNames, String[][] attributeNames, int[][] keyDataTypes, int[][] attributeDataTypes, String[] aggregationNames, int[] aggregationDataType, int bufferSize) throws IOException {
        int i;
        Object[] params = new Object[]{inputStream, length, levels, sortTypes, keyNames, attributeNames, keyDataTypes, attributeDataTypes, aggregationNames, aggregationDataType};
        logger.entering(CachedAggregationResultSet.class.getName(), "CachedAggregationResultSet", params);
        this.currentPosition = 0;
        this.length = length;
        this.levels = levels;
        this.sortType = sortTypes;
        this.keyNames = keyNames;
        this.attributeNames = attributeNames;
        this.keyDataTypes = keyDataTypes;
        this.attributeDataTypes = attributeDataTypes;
        this.aggregationDataType = aggregationDataType;
        this.aggregationResultNameMap = new HashMap();
        if (aggregationNames != null) {
            this.aggregationNames = new String[aggregationNames.length];
            i = 0;
            while (i < aggregationNames.length) {
                this.aggregationNames[i] = aggregationNames[i];
                this.aggregationResultNameMap.put(aggregationNames[i], i);
                ++i;
            }
        }
        if (bufferSize != 0) {
            this.aggregationResultRow = new BufferedStructureArray(AggregationResultRow.getCreator(), bufferSize);
        } else {
            this.aggregationResultRow = new BufferedStructureArray(AggregationResultRow.getCreator(), 1000);
            ((BufferedStructureArray)this.aggregationResultRow).setUseMemoryOnly(true);
        }
        i = 0;
        while (i < length) {
            this.aggregationResultRow.add(AggregationResultSetSaveUtil.loadAggregationRow(inputStream));
            ++i;
        }
        if (this.length > 0) {
            this.seek(0);
        }
        logger.exiting(CachedAggregationResultSet.class.getName(), "CachedAggregationResultSet");
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        if (this.aggregationDataType == null || aggregationIndex < 0 || aggregationIndex >= this.aggregationDataType.length) {
            return -1;
        }
        return this.aggregationDataType[aggregationIndex];
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        Object index = this.aggregationResultNameMap.get(name);
        if (index == null) {
            return -1;
        }
        return (Integer)index;
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (this.resultObject.getAggregationValues() == null || aggregationIndex < 0) {
            return null;
        }
        return this.resultObject.getAggregationValues()[aggregationIndex];
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        if (this.attributeNames == null) {
            return null;
        }
        return this.attributeNames[levelIndex];
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.levels;
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return 0;
        }
        return this.attributeNames[levelIndex].length;
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeDataTypes == null || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(level, attributeName)];
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        if (this.attributeDataTypes == null || levelIndex < 0 || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(levelIndex, attributeName)];
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        if (this.attributeNames == null || levelIndex < 0 || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelCount() {
        if (this.keyNames == null) {
            return 0;
        }
        return this.keyNames.length;
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        if (this.levels == null) {
            return -1;
        }
        int i = 0;
        while (i < this.levels.length) {
            if (this.levels[i].equals(level)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        if (this.keyNames == null || this.keyNames[levelIndex] == null) {
            return 0;
        }
        return this.keyNames[levelIndex].length;
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        if (this.keyDataTypes == null) {
            return -1;
        }
        return this.getLevelKeyDataType(this.getLevelIndex(level), keyName);
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        if (this.keyDataTypes == null || levelIndex < 0 || this.keyDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.keyDataTypes[levelIndex][this.getLevelKeyIndex(levelIndex, keyName)];
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        if (this.keyNames == null || levelIndex < 0 || this.keyNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyNames[levelIndex].length) {
            if (this.keyNames[levelIndex][i].equals(keyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        if (this.keyNames == null) {
            return -1;
        }
        return this.getLevelKeyIndex(this.getLevelIndex(level), keyName);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    @Override
    public int getSortType(int levelIndex) {
        if (this.sortType == null || this.sortType.length < levelIndex) {
            return -100;
        }
        return this.sortType[levelIndex];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void seek(int index) throws IOException {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
        }
        this.currentPosition = index;
        this.resultObject = (AggregationResultRow)this.aggregationResultRow.get(index);
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public String[][] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public IAggregationResultRow getCurrentRow() throws IOException {
        return this.resultObject;
    }

    @Override
    public String[][] getKeyNames() {
        return this.keyNames;
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.keyNames[levelIndex][keyIndex];
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.levels[levelIndex];
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return this.ad;
    }

    @Override
    public void close() throws IOException {
        this.aggregationResultRow.close();
    }

    @Override
    public void clear() throws IOException {
        this.aggregationResultRow.clear();
        this.length = 0;
    }

    @Override
    public int getAggregationCount() {
        return this.aggregationResultNameMap.size();
    }

    @Override
    public String getAggregationName(int index) {
        if (this.aggregationNames != null) {
            return this.aggregationNames[index];
        }
        return null;
    }

    @Override
    public int[] getAggregationDataType() {
        return this.aggregationDataType;
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.attributeDataTypes;
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.attributeNames;
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.keyDataTypes;
    }

    @Override
    public String[][] getLevelKeys() {
        return this.keyNames;
    }

    @Override
    public int[] getSortType() {
        return this.sortType;
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes();
    }

    public void setAggregationDefinition(AggregationDefinition ad) {
        this.ad = ad;
    }

    public IDiskArray getAggregationResultRows() {
        return this.aggregationResultRow;
    }

    public void setAggregationResultRows(IDiskArray rows) {
        this.aggregationResultRow = rows;
    }
}

