/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.psionimport.PsionImportResult;
import fr.ifremer.tutti.service.psionimport.PsionImportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import java.io.File;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public class ImportPsionAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected File importedTrunkFile;
    protected ImportPupitriPopupUI importPupitriDialog;
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected EditFishingOperationAction editAction;
    protected PsionImportResult importResult;

    public ImportPsionAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        this.importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (this.editAction == null) {
            FishingOperationsUI parentContainer = (FishingOperationsUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(FishingOperationsUI.class);
            this.editAction = (EditFishingOperationAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)parentContainer.getHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            this.importedTrunkFile = this.chooseFile(I18n.t((String)"tutti.editSpeciesBatch.action.title.choose.importPsionFile", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesBatch.action.choosePsionFile.import", (Object[])new Object[0]), new String[]{"^.*\\.IWA", I18n.t((String)"tutti.common.file.iwa", (Object[])new Object[0])});
            result = this.importedTrunkFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PsionImportService importService = this.getContext().getTuttiPsionImportExportService();
        EditCatchesUI parentContainer = (EditCatchesUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel model = parentContainer.getModel();
        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.toEntity();
        this.importResult = importService.importFile(this.importedTrunkFile, operation, catchBatch);
        if (this.importResult.isDone()) {
            this.getEditAction().loadCatchBatch(operation);
        }
    }

    public void releaseAction() {
        super.releaseAction();
        this.importedTrunkFile = null;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.importResult.isDone()) {
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPsion.success", (Object[])new Object[]{this.importResult.getNbImported()}));
        } else {
            StringBuilder sb = new StringBuilder();
            for (String s : this.importResult.getErrors()) {
                sb.append("<li>").append(s).append("</li>");
            }
            this.displayWarningMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPsion.no.matching.fishingOperation.title", (Object[])new Object[0]), "<html><body>" + I18n.t((String)"tutti.editSpeciesBatch.action.importPsion.no.matching.fishingOperation", (Object[])new Object[]{sb.toString()}) + "</body></html>");
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPsion.no.matching.data", (Object[])new Object[0]));
        }
    }
}

