package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolSpeciesTableModel.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolSpeciesTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import java.util.List;

import static org.nuiton.i18n.I18n.n;

/**
 * @author kmorin
 * @since 0.3
 */
public class EditProtocolSpeciesTableModel extends AbstractApplicationTableModel<EditProtocolSpeciesRowModel> {

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SPECIES_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SPECIES,
            n("tutti.editProtocol.table.header.speciesReferenceTaxonId"),
            n("tutti.editProtocol.table.header.speciesReferenceTaxonId.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SURVEY_CODE_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SPECIES_SURVEY_CODE,
            n("tutti.editProtocol.table.header.speciesSurveyCode"),
            n("tutti.editProtocol.table.header.speciesSurveyCode.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> LENGTH_STEP_PMFM_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_LENGTH_STEP_PMFM,
            n("tutti.editProtocol.table.header.lengthStep"),
            n("tutti.editProtocol.table.header.lengthStep.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> WEIGHT_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_WEIGHT_ENABLED,
            n("tutti.editProtocol.table.header.weight"),
            n("tutti.editProtocol.table.header.weight.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> COUNT_IF_NO_FREQUENCY_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED,
            n("tutti.editProtocol.table.header.countIfNoFrequency"),
            n("tutti.editProtocol.table.header.countIfNoFrequency.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> CALCIFY_SAMPLE_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_CALCIFY_SAMPLE_ENABLED,
            n("tutti.editProtocol.table.header.calcifySample"),
            n("tutti.editProtocol.table.header.calcifySample.tip"));

    protected final SampleCategoryModel sampleCategoryModel;

    private static final long serialVersionUID = 1L;

    public EditProtocolSpeciesTableModel(SampleCategoryModel sampleCategoryModel,
                                         TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.sampleCategoryModel = sampleCategoryModel;
        setNoneEditableCols(SPECIES_ID);
    }

    public static EditProtocolSpeciesRowModel newRow(SampleCategoryModel sampleCategoryModel) {
        EditProtocolSpeciesRowModel result = new EditProtocolSpeciesRowModel();

        List<Integer> mandatoryIds =
                Lists.newArrayList(sampleCategoryModel.getSamplingOrder());
        // always remove the first category (V/HV)
        mandatoryIds.remove(0);
        result.setMandatorySampleCategoryId(mandatoryIds);

        result.setWeightEnabled(true);
        result.setCountIfNoFrequencyEnabled(true);
        result.setCalcifySampleEnabled(true);
        result.setValid(true);
        return result;
    }

    @Override
    public EditProtocolSpeciesRowModel createNewRow() {
        EditProtocolSpeciesRowModel result = newRow(sampleCategoryModel);
        return result;
    }

    @Override
    protected void setValueAt(Object aValue,
                              int rowIndex,
                              int columnIndex,
                              ColumnIdentifier<EditProtocolSpeciesRowModel> propertyName,
                              EditProtocolSpeciesRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        fireTableCellUpdated(rowIndex, columnIndex);
    }

    /**
     * Return the list of used species in the table (used to fill the
     * comparator cache for species sort)
     *
     * @return the list of used species in the table.
     * @since 2.8
     */
    public List<Species> getSpeciesList() {
        List<Species> result = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : rows) {
            result.add(row.getSpecies());
        }
        return result;
    }

}
