/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchs;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.BatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="benthosBatchPersistenceService")
public class BenthosBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements BenthosBatchPersistenceService {
    private static final Log log = LogFactory.getLog(BenthosBatchPersistenceServiceImpl.class);
    @Resource(name="speciesPersistenceService")
    private SpeciesPersistenceService speciesService;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationPersistenceService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId, boolean validateTree) {
        SortingBatch horsVracBenthosBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyy");
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch vracBenthosBatch = this.batchTreeHelper.getBenthosVracAliveItemizedRootBatch(catchBatch);
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        BatchContainer<BenthosBatch> result = new BatchContainer<BenthosBatch>();
        if (vracBenthosBatch != null) {
            result.setId(vracBenthosBatch.getId());
            for (Batch batch : vracBenthosBatch.getChildBatchs()) {
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootBenthosBatch with a null taxon, but was for " + batch.getId()));
                Species species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId());
                if (species == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.benthosBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                BenthosBatch target = BenthosBatchs.newBenthosBatch();
                target.setSpecies(species);
                this.batchHelper.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Vrac > Benthos > Alive Itemized > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if ((horsVracBenthosBatch = this.batchTreeHelper.getBenthosHorsVracRootBatch(catchBatch)) != null) {
            for (Batch batch : horsVracBenthosBatch.getChildBatchs()) {
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + source.getId()));
                Species species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId());
                if (species == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.benthosBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                BenthosBatch target = BenthosBatchs.newBenthosBatch();
                target.setSpecies(species);
                this.batchHelper.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Hors Vrac > Benthos > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if (validateTree) {
            this.batchHelper.validateBenthos(sampleCategoryModel, result);
        }
        return result;
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getId(), false);
        BenthosBatch created = this.createBenthosBatch(bean, parentBatchId, catchBatch);
        return created;
    }

    @Override
    public Collection<BenthosBatch> createBenthosBatches(String fishingOperationId, Collection<BenthosBatch> beans) {
        Preconditions.checkNotNull(beans);
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        ArrayList<BenthosBatch> result = new ArrayList<BenthosBatch>();
        for (BenthosBatch bean : beans) {
            BenthosBatch created = this.createBenthosBatch(bean, null, catchBatch);
            result.add(created);
        }
        return result;
    }

    protected BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.beanToEntity(bean, batch, parentBatchId, catchBatch);
        bean = this.batchHelper.createSortingBatch(bean, catchBatch, batch);
        return bean;
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.beanToEntity(bean, batch, parentBatchId, catchBatch);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    @Override
    public void deleteBenthosBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.batchHelper.deleteBatch(id);
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.batchHelper.deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(String id, Species species) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.batchHelper.changeBatchSpecies(id, species);
    }

    @Override
    public List<BenthosBatch> getAllBenthosBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        ArrayList<BenthosBatch> batchesToConfirm = new ArrayList<BenthosBatch>();
        BatchContainer<BenthosBatch> rootBenthosBatch = this.getRootBenthosBatch(fishingOperationId, false);
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            this.findBenthosBatchesToConfirm(benthosBatch, batchesToConfirm);
        }
        return batchesToConfirm;
    }

    protected void findBenthosBatchesToConfirm(BenthosBatch benthosBatch, List<BenthosBatch> batchesToConfirm) {
        if (benthosBatch.isSpeciesToConfirm()) {
            batchesToConfirm.add(benthosBatch);
        } else if (!benthosBatch.isChildBatchsEmpty()) {
            for (BenthosBatch batch : benthosBatch.getChildBatchs()) {
                this.findBenthosBatchesToConfirm(batch, batchesToConfirm);
            }
        }
    }

    @Override
    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        Preconditions.checkNotNull((Object)benthosBatchId);
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencies(benthosBatchId);
        ArrayList results = Lists.newArrayList();
        for (SortingBatch child : frequencyChilds) {
            BenthosBatchFrequency target = BenthosBatchFrequencys.newBenthosBatchFrequency();
            this.batchHelper.entityToBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public Multimap<Species, BenthosBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<BenthosBatch> batchContainer) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (BenthosBatch speciesBatch : batchContainer.getChildren()) {
            this.getAllSpeciesBatchFrequencyForBatch(speciesBatch, (Multimap<Species, BenthosBatchFrequency>)result);
        }
        return result;
    }

    protected void getAllSpeciesBatchFrequencyForBatch(BenthosBatch batch, Multimap<Species, BenthosBatchFrequency> result) {
        List<BenthosBatchFrequency> speciesBatchFrequency = this.getAllBenthosBatchFrequency(batch.getId());
        result.putAll((Object)batch.getSpecies(), speciesBatchFrequency);
        if (!batch.isChildBatchsEmpty()) {
            for (BenthosBatch child : batch.getChildBatchs()) {
                this.getAllSpeciesBatchFrequencyForBatch(child, result);
            }
        }
    }

    @Override
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)benthosBatchId);
        Preconditions.checkNotNull(frequencies);
        String pmfmId = null;
        for (BenthosBatchFrequency source : frequencies) {
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
                continue;
            }
            if (pmfmId.equals(source.getLengthStepCaracteristic().getId())) continue;
            throw new DataIntegrityViolationException("Batch frequencies under one Speciesbatch must have all the same lengthStepCaracteristic");
        }
        Integer sortingBatchId = Integer.valueOf(benthosBatchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(sortingBatchId);
        if (catchBatch == null) {
            return frequencies;
        }
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch parentBatch = this.batchHelper.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(parentBatch);
        for (SortingBatch child : frequencyChilds) {
            notUpdatedChildIds.add(child.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (BenthosBatchFrequency source : frequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.batchHelper.beanToEntity(source, target, parentBatch, rankOrder);
                this.batchHelper.createSortingBatch(source, catchBatch, target);
                continue;
            }
            target = this.batchHelper.getSortingBatchById(catchBatch, source.getIdAsInt());
            this.batchHelper.beanToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)batchsToUpdate)) {
            this.batchHelper.updateSortingBatch(batchsToUpdate, catchBatch);
        }
        if (CollectionUtils.isNotEmpty((Collection)notUpdatedChildIds)) {
            for (Integer batchId : notUpdatedChildIds) {
                this.batchHelper.removeWithChildren(batchId, catchBatch);
            }
        }
        return Collections.unmodifiableList(frequencies);
    }

    protected void beanToEntity(BenthosBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.batchHelper.setBenthosBatchParents(source.getSampleCategoryId(), source.getSampleCategoryValue(), target, parentBatchId, catchBatch);
        }
        this.batchHelper.beanToEntity(parentBatchId, source, target);
    }
}

