/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CaracteristicValueParseException;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchModel;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;

public class CsvConsumerForAccidentalCatch
extends CsvComsumer<AccidentalCatchRow, AccidentalCatchModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForAccidentalCatch.class);

    public CsvConsumerForAccidentalCatch(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, AccidentalCatchModel.forImport(separator, parserFactory), reportError);
    }

    public GenericFormatImportOperationContext validateRow(ImportRow<AccidentalCatchRow> row, GenericFormatImportContext importContext) {
        GenericFormatImportOperationContext operationContext = null;
        if (row.isValid() && (operationContext = importContext.getValidationHelper().getFishingOperationContext(this, row, importContext)) != null) {
            AccidentalCatchRow bean = (AccidentalCatchRow)row.getBean();
            Caracteristic caracteristic = bean.getCaracteristic();
            if (caracteristic == null) {
                // empty if block
            }
            if (bean.getCaracteristicValue() == null) {
                // empty if block
            }
            String value = (String)((Object)bean.getCaracteristicValue());
            try {
                Serializable serializable = importContext.parseCaracteristicValue(caracteristic, value);
                bean.setCaracteristicValue(serializable);
            }
            catch (CaracteristicValueParseException e) {
                this.addCheckError(row, e);
            }
        }
        this.reportError(row);
        return operationContext;
    }

    public void prepareRowForPersist(GenericFormatImportOperationContext operationContext, ImportRow<AccidentalCatchRow> row) {
        AccidentalCatchRow bean = (AccidentalCatchRow)row.getBean();
        Integer batchId = bean.getBatchId();
        AccidentalBatch batch = operationContext.getAccidentalBatchById(batchId);
        if (batch == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Detects accidentalBatch: " + batchId));
            }
            batch = AccidentalBatchs.newAccidentalBatch();
            batch.setFishingOperation(operationContext.getFishingOperation());
            batch.setCaracteristics(new CaracteristicMap());
            batch.setComment(bean.getComment());
            batch.setSpecies(bean.getSpecies());
            operationContext.addAccidentalBatch(batchId, batch);
        }
        batch.getCaracteristics().put((Object)bean.getCaracteristic(), (Object)bean.getCaracteristicValue());
    }
}

