/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderMeasureRecord;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.ApplySpeciesFrequencyRafaleAction;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiNumberTickUnitSource;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.xy.IntervalXYDataset;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI> {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    private JFreeChart chart;
    protected WeightUnit weightUnit;
    protected final FeedReaderListener feedReaderListener = new FeedReaderListener(){

        public void recordRead(FeedReaderEvent event) {
            final FeedReaderMeasureRecord record = event.getRecord();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).isSimpleCountingMode()) {
                        SpeciesFrequencyUIHandler.this.consumeFeedRecord(record);
                    }
                }
            });
        }
    };
    protected ApplySpeciesFrequencyRafaleAction applySpeciesFrequencyRafaleAction;

    public SpeciesFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    public boolean isRowValid(SpeciesFrequencyRowModel row) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        boolean valid = model.isRowValid(row);
        return valid;
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesFrequencyRowModel> rows) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.reloadRows();
        this.getTableModel().setRows(rows);
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)((SpeciesFrequencyUI)this.ui).getLogsTable().getModel());
        logsTableModel.setRows(Lists.newArrayList());
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesFrequencyUI ui) {
        this.applySpeciesFrequencyRafaleAction = new ApplySpeciesFrequencyRafaleAction(ui);
        super.beforeInit((ApplicationUI)ui);
        this.weightUnit = this.getConfig().getSpeciesWeightUnit();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel(this.weightUnit, sampleCategoryModel);
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
        this.getContext().addPropertyChangeListener("ichtyometerConnected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean connected = (Boolean)evt.getNewValue();
                if (connected && SpeciesFrequencyUIHandler.this.frequencyEditor != null) {
                    SpeciesFrequencyUIHandler.this.listenItchtyometer();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpeciesFrequencyUIHandler.this.updateLogVisibility();
                    }
                });
            }
        });
    }

    public void afterInit(SpeciesFrequencyUI ui) {
        this.initUI(this.ui);
        ArrayList lengthStepCaracterics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById((Iterable)lengthStepCaracterics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        this.speciesProtocol = this.getContext().isProtocolFilled() ? this.getPersistenceService().toSpeciesProtocolMap() : Maps.newHashMap();
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracterics, modelCaracteristic);
        float step = this.getStep(modelCaracteristic);
        model.setStep(Float.valueOf(step));
        model.setMinStep(null);
        model.setMaxStep(null);
        ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel().getNumberValue();
                    SpeciesFrequencyUIHandler.this.applySpeciesFrequencyRafaleAction.applyRafaleStep(step, false);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                float step = SpeciesFrequencyUIHandler.this.getStep(newValue);
                ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).setStep(Float.valueOf(step));
                ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).setDataSetIntervalWidth(step);
                SpeciesFrequencyUIHandler.this.chart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step == 1.0f));
                if (CollectionUtils.isNotEmpty(((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).getRows())) {
                    for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).getRows()) {
                        rowModel.setLengthStepCaracteristic(newValue);
                        SpeciesFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                    }
                }
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristicUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String unit = (String)evt.getNewValue();
                if (unit == null) {
                    unit = I18n.t((String)"tutti.editSpeciesFrequencies.unkownStepUnit", (Object[])new Object[0]);
                }
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getMinStepLabel().setText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep", (Object[])new Object[0]), unit));
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getMinStepLabel().setToolTipText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep.tip", (Object[])new Object[0]), unit));
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getMaxStepLabel().setText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep", (Object[])new Object[0]), unit));
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getMaxStepLabel().setToolTipText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep.tip", (Object[])new Object[0]), unit));
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getRafaleStepLabel().setText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep", (Object[])new Object[0]), unit));
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getRafaleStepLabel().setToolTipText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep.tip", (Object[])new Object[0]), unit));
                TableColumnExt column = (TableColumnExt)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.getUI()).getTable().getColumn(SpeciesFrequencyTableModel.LENGTH_STEP);
                column.setHeaderValue((Object)SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit));
                column.setToolTipText(SpeciesFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit));
            }
        });
        model.addPropertyChangeListener("configurationMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent componentToFocus = SpeciesFrequencyUIHandler.this.getComponentToFocus(newValue);
                        if (componentToFocus != null) {
                            componentToFocus.grabFocus();
                        }
                        SpeciesFrequencyUIHandler.this.updateLogVisibility();
                    }
                });
            }
        });
        this.chart = ChartFactory.createXYBarChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (boolean)false, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (IntervalXYDataset)model.dataset);
        this.chart.clearSubtitles();
        ValueAxis rangeAxis = this.chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource(true));
        ValueAxis domainAxis = this.chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        this.chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)this.getConfig().getColorComputedWeights());
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        JPanel histogramPanel = ui.getHistogramPanel();
        histogramPanel.add((Component)chartPanel, "Center");
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(this.weightUnit, (TableColumnModelExt)columnModel, model);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        JXTable logTable = ui.getLogsTable();
        DefaultTableColumnModelExt logColumnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)logColumnModel, SpeciesFrequencyLogCellComponent.newEditor(ui), SpeciesFrequencyLogCellComponent.newRender(), SpeciesFrequencyLogsTableModel.LABEL);
        SpeciesFrequencyLogsTableModel logTableModel = new SpeciesFrequencyLogsTableModel((TableColumnModelExt)logColumnModel);
        logTableModel.setRows(new ArrayList());
        logTable.setModel((TableModel)((Object)logTableModel));
        logTable.setColumnModel((TableColumnModel)logColumnModel);
        logTable.getTableHeader().setReorderingAllowed(false);
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.ODD, (Color)this.getConfig().getColorAlternateRow());
        logTable.addHighlighter(evenHighlighter);
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getConfigurationMode();
        BeanFilterableComboBox<Caracteristic> componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setValid(false);
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setSimpleCount(null);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
        if (this.getContext().isIchtyometerConnected()) {
            this.getContext().getIchtyometerReader().removeFeedModeReaderListener(this.feedReaderListener);
        }
    }

    public void editBatch(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        Integer number;
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        SpeciesBatchRowModel speciesBatch = editor.getEditRow();
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
        model.setTotalNumber(null);
        model.setTotalComputedWeight(null);
        model.setTotalWeight(null);
        model.setSimpleCount(null);
        model.setMinStep(null);
        model.setMaxStep(null);
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        ArrayList rows = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<SpeciesFrequencyRowModel> previousFrequency;
            Float lengthStep;
            model.setTotalWeight(speciesBatch.getWeight());
            List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                SpeciesFrequencyTableModel tableModel = this.getTableModel();
                for (SpeciesFrequencyRowModel rowModel : frequency) {
                    SpeciesFrequencyRowModel newRow = tableModel.createNewRow(false);
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    rows.add(newRow);
                }
                SpeciesFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            SpeciesBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                SpeciesFrequencyRowModel rowModel;
                rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (this.getContext().isIchtyometerConnected()) {
                this.listenItchtyometer();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + rows.size() + " frequency"));
        }
        FrequencyConfigurationMode mode = FrequencyConfigurationMode.AUTO_GEN;
        if (lengthStepCaracteristic == null && ((speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())) == null || speciesProtocol.getLengthStepPmfmId() == null)) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
        }
        if ((number = speciesBatch.getNumber()) != null && rows.isEmpty()) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(number);
        }
        model.setConfigurationMode(null);
        model.setConfigurationMode(mode);
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
        Collections.sort(rows);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setRows(rows);
        model.setBatch(speciesBatch);
    }

    protected void consumeFeedRecord(FeedReaderMeasureRecord record) {
        if (!record.isValid()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.editSpeciesFrequencies.error.itchyometer.bad.record", (Object[])new Object[]{record.getRecord()}));
        }
        String unit = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristicUnit();
        float length = "mm".equals(unit) ? (float)record.getMeasure() : (float)record.getMeasure() / 10.0f;
        this.applySpeciesFrequencyRafaleAction.applyRafaleStep(Float.valueOf(length), true);
    }

    protected void listenItchtyometer() {
        this.getContext().getIchtyometerReader().removeFeedModeReaderListener(this.feedReaderListener);
        if (log.isInfoEnabled()) {
            log.info((Object)"Start listen ichtyometer");
        }
        this.getContext().getIchtyometerReader().addFeedModeReaderListener(this.feedReaderListener);
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        BeanFilterableComboBox<Caracteristic> componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getSimpleCountingField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected float getStep(Caracteristic caracteristic) {
        Float precision = null;
        if (caracteristic != null) {
            precision = caracteristic.getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        return precision.floatValue();
    }

    protected void updateLogVisibility() {
        boolean logVisible = ((SpeciesFrequencyUIModel)((Object)this.getModel())).isRafaleMode() || this.getContext().isIchtyometerConnected();
        JSplitPane firstSplitPane = ((SpeciesFrequencyUI)this.ui).getFirstSplitPane();
        JSplitPane secondSplitPane = ((SpeciesFrequencyUI)this.ui).getSecondSplitPane();
        int lastDividerLocation = secondSplitPane.getLastDividerLocation();
        if (lastDividerLocation == 0) {
            lastDividerLocation = 200;
        }
        secondSplitPane.setDividerLocation(logVisible ? lastDividerLocation : 0);
        secondSplitPane.setDividerSize(logVisible ? firstSplitPane.getDividerSize() : 0);
        ((SpeciesFrequencyUI)this.ui).getLogsScrollPane().setVisible(logVisible);
    }

    protected String getLabelWithUnit(String label, String unit) {
        return label + " (" + unit + ")";
    }

    public <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        super.initBeanFilterableComboBox(comboBox, data, selectedData);
    }

    public SpeciesFrequencyCellComponent.FrequencyCellEditor getFrequencyEditor() {
        return this.frequencyEditor;
    }
}

