/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.action.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class ImportMultiPostMarineLitterAction
extends ImportMultiPostActionSupport<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {
    public ImportMultiPostMarineLitterAction(MarineLitterBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiMarineLitter";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n.t((String)"tutti.common.file.tuttiMarineLitter", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    protected String getSuccessMessage(File file) {
        return I18n.t((String)"tutti.editMarineLitterBatch.action.importMultiPost.success", (Object[])new Object[]{file});
    }

    @Override
    protected Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        Map notImportedData = multiPostImportExportService.importMarineLitter(file, operation);
        return notImportedData;
    }

    @Override
    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        WeightUnit marineLitterWeightUnit = this.getConfig().getMarineLitterWeightUnit();
        StringBuilder builder = new StringBuilder();
        Float totalWeight = (Float)notImportedData.get("marineLitterTotalWeight");
        this.addNotImportedWeightToReport(builder, totalWeight, marineLitterWeightUnit, I18n.n((String)"tutti.multiPostImportLog.totalWeight", (Object[])new Object[0]));
        Collection notImportedMarineLitterBatches = (Collection)notImportedData.get("batchesKey");
        for (MarineLitterBatch mlb : notImportedMarineLitterBatches) {
            builder.append("- ").append(this.decorate(mlb.getMarineLitterCategory())).append(" / ").append(this.decorate(mlb.getMarineLitterSizeCategory())).append("\n");
        }
        return builder.toString();
    }
}

