/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.AbstractEhcacheRegionFactory;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.util.HibernateEhcacheUtils;
import org.hibernate.cfg.Settings;
import org.jboss.logging.Logger;

public class SingletonEhCacheRegionFactory
extends AbstractEhcacheRegionFactory {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)SingletonEhCacheRegionFactory.class.getName());
    private static final AtomicInteger REFERENCE_COUNT = new AtomicInteger();

    public SingletonEhCacheRegionFactory() {
    }

    public SingletonEhCacheRegionFactory(Properties prop) {
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                this.manager = CacheManager.create();
                REFERENCE_COUNT.incrementAndGet();
            } else {
                URL url;
                try {
                    url = new URL(configurationResourceName);
                }
                catch (MalformedURLException e) {
                    if (!configurationResourceName.startsWith("/")) {
                        configurationResourceName = "/" + configurationResourceName;
                        LOG.debugf("prepending / to %s. It should be placed in the root of the classpath rather than in a package.", configurationResourceName);
                    }
                    url = this.loadResource(configurationResourceName);
                }
                Configuration configuration = HibernateEhcacheUtils.loadAndCorrectConfiguration(url);
                this.manager = CacheManager.create((Configuration)configuration);
                REFERENCE_COUNT.incrementAndGet();
            }
            this.mbeanRegistrationHelper.registerMBean(this.manager, properties);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
        try {
            if (this.manager != null) {
                if (REFERENCE_COUNT.decrementAndGet() == 0) {
                    this.manager.shutdown();
                }
                this.manager = null;
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

