package fr.ifremer.tutti.ui.swing.util.auth;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class LoginUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUTU8TQRieVlr6ASoSEBEMqBdj3GqMiQlGUUgjpCgRTIi9ON2dwpDZmXF2FpYYjT/Bn6B3LybePBkPnj14Mf4FYzx4Nb6z22677ZJik243834979PnmXc/Uc5TaH4XB4GlfK6pS6zVu1tbDxu7xNbLxLMVlVooFH0yWZSto7ITn3saXajXTHmlVV5ZEq4UnPCu6oUaKnn6gBFvhxCt0Wyywva8ykYcXgikr9pdY1BpXd/8/pV97bx6m0UokICuBKvMDarqbDJUQ1nqaHQKJu3hCsN8G2AoyrcB76g5W2LY8x5glzxDL9FwDeUlVtBMo/NHXznsEdYHUqMyE9uUL1MMvxpdbiqLNhVxibK0rzW1fGp5+4DA8jVlFvb1jlUzFY9XpAy75DUqupjydcwJ02gqsW5UuokbLERcjEvKlDfFGvE8vE1gYbNb0MpereEGYSZvJE4vhSjjwFhatEoJA/ImE702SaDDQLJiVAIH+0I5h7WME1pdpxNd17uDycLCxdWQiau9W4WnydwRG3ObsHtAtOAajSfyo1OTOdMpwLZNpO6E5ltxhc4meAcBWx0BdxSWqaOc8uEY/qh6v+YfQShS+1SP2k3DMPp3cvzbxx8fqm2JF2D2RGpql0NBelIJSZSmZvSJSN9GUZU1LBfqqOgRBvYO7TuTAmyjFQZwMG/MlEeCvI+9HWiRG/7+6fPk06/HULZq5ICdKjb5K6iodxSwIJgTyDuLIaKR/QI8T8I3q1FOU82AorFI7qGSrNZZzhUOBk0PaeWTAFiZSWElhtYofvkzvvF+sc1MBpCeOTS9w07uCcpTzignof1bzk61e1l6xHdEx8FpnkZJU8uWTy+Fzyt9HGTAP8AVFXzFNiocMs4MfJN8PdzCvN1AScsOagrEFpixVlUoMMLz0hx8Oi4tvTCkgjU1Ot3Ne9MEo/c0BF23wP8BmIgAJDzdhWG6H0M7NQ1G8vIYhGQoHjMejbGF6wpuRd7vIT/fPh2h127yNU4gk9rgiZRSy43DZS0E26Ry89A5aXskrp+jrzGRaL+HGXWwJr2LRDdV3yLnUosPXSV9Vuoy3VfjETSfZ/hAQDI6fgta4rkG5Q7cu7f7emfMszSwozl2zaNfuWFsFjr8AzFx5C7dCAAA";
    private static final Log log = LogFactory.getLog(LoginUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton acceptButton;
    protected JButton cancelButton;
    protected final LoginUIHandler handler = createHandler();
    protected JLabel infoMessage;
    protected LoginUI loginDialog = this;
    protected JTextField loginField;
    protected JLabel loginLabel;
    protected Table mainPanel;
    protected JPasswordField passwordField;
    protected JLabel passwordLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public LoginUI open(String url, AuthenticationInfo authenticationInfo) {
        handler.open(url, authenticationInfo);
        return this;
    }
    
    public AuthenticationInfo getAuthenticationInfo() { return handler.getAuthenticationInfo(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LoginUI(TuttiUIContext context) {
        super(context.getExistingActionUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public LoginUI() {
        $initialize();
    }

    public LoginUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__acceptButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.accept();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAcceptButton() {
        return acceptButton;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public LoginUIHandler getHandler() {
        return handler;
    }

    public JLabel getInfoMessage() {
        return infoMessage;
    }

    public JTextField getLoginField() {
        return loginField;
    }

    public JLabel getLoginLabel() {
        return loginLabel;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public JPasswordField getPasswordField() {
        return passwordField;
    }

    public JLabel getPasswordLabel() {
        return passwordLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLoginDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(infoMessage, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(loginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(loginField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAcceptButton() {
        $objectMap.put("acceptButton", acceptButton = new JButton());
        
        acceptButton.setName("acceptButton");
        acceptButton.setText(t("tutti.common.validate"));
        acceptButton.setToolTipText(t("tutti.common.validate"));
        acceptButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__acceptButton"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.common.cancel"));
        cancelButton.setToolTipText(t("tutti.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected LoginUIHandler createHandler() {
        return new LoginUIHandler();
    }

    protected void createInfoMessage() {
        $objectMap.put("infoMessage", infoMessage = new JLabel());
        
        infoMessage.setName("infoMessage");
    }

    protected void createLoginField() {
        $objectMap.put("loginField", loginField = new JTextField());
        
        loginField.setName("loginField");
        loginField.setColumns(15);
    }

    protected void createLoginLabel() {
        $objectMap.put("loginLabel", loginLabel = new JLabel());
        
        loginLabel.setName("loginLabel");
        loginLabel.setText(t("tutti.login.field.login"));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createPasswordField() {
        $objectMap.put("passwordField", passwordField = new JPasswordField());
        
        passwordField.setName("passwordField");
        passwordField.setColumns(15);
    }

    protected void createPasswordLabel() {
        $objectMap.put("passwordLabel", passwordLabel = new JLabel());
        
        passwordLabel.setName("passwordLabel");
        passwordLabel.setText(t("tutti.login.field.password"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToLoginDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(acceptButton);
        
        // apply 9 property setters
        infoMessage.setIcon(SwingUtil.createActionIcon("info"));
        loginLabel.setLabelFor(
            loginField
        );
        passwordLabel.setLabelFor(
            passwordField
        );
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.cancel.mnemonic"),'Z'));
        acceptButton.setIcon(SwingUtil.createActionIcon("accept"));
        acceptButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        loginDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("loginDialog", loginDialog);
        createMainPanel();
        createInfoMessage();
        createLoginLabel();
        createLoginField();
        createPasswordLabel();
        createPasswordField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createAcceptButton();
        // inline creation of loginDialog
        setName("loginDialog");
        loginDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.login.title"));
        setModal(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}