package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateBenthosBatchUIModel.java 1192 2013-09-19 14:09:05Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/tutti/tags/tutti-3.1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/create/CreateBenthosBatchUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

/**
 * Model of {@link CreateBenthosBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateBenthosBatchUIModel extends AbstractTuttiTableUIModel<CreateBenthosBatchUIModel, SplitBenthosBatchRowModel, CreateBenthosBatchUIModel> implements SelectedCategoryAble {

    private final static Log log = LogFactory.getLog(CreateBenthosBatchUIModel.class);

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";

    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";

    public static final String PROPERTY_BATCH_COUNT = "batchCount";

    public static final String PROPERTY_CATEGORY = "category";

    public static final String PROPERTY_SELECTED_CATEGORY = "selectedCategory";

    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";

    /**
     * All available species (sets by protocol).
     *
     * @since 0.3
     */
    protected List<Species> availableSpecies;

    /**
     * Species to select.
     *
     * @since 0.3
     */
    protected Species species;

    /**
     * First sample category.
     *
     * @since 2.4
     */
    protected CaracteristicQualitativeValue sampleCategory;

    /**
     * Batch weight.
     *
     * @since 0.3
     */
    protected Float batchWeight;

    /**
     * Batch count.
     *
     * @since 2.5
     */
    protected Integer batchCount;

    /**
     * Sample categories.
     *
     * @since 2.5
     */
    protected List<SampleCategoryModelEntry> category;

    /**
     * Selected Sample category.
     *
     * @since 2.5
     */
    protected SampleCategoryModelEntry selectedCategory;

    /**
     * Sample weight of split batches.
     *
     * @since 2.5
     */
    protected Float sampleWeight;

    /**
     * Model of sample categories.
     *
     * @since 2.5
     */
    protected SampleCategoryModel sampleCategoryModel;

    /**
     * Already used species by sample category.
     *
     * @since 0.3
     */
    protected final Multimap<CaracteristicQualitativeValue, Species> speciesUsed = ArrayListMultimap.create();

    public CreateBenthosBatchUIModel(SampleCategoryModel sampleCategoryModel) {
        super(CreateBenthosBatchUIModel.class, null, null);
        this.sampleCategoryModel = sampleCategoryModel;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return sampleCategoryModel;
    }

    public List<Species> getAvailableSpecies() {
        if (log.isDebugEnabled()) {
            log.debug("getAvailableSpecies " + availableSpecies);
        }
        return availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {

        if (log.isDebugEnabled()) {
            log.debug("setAvailableSpecies " + availableSpecies);
        }
        Object oldValue = getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldSpecies = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldSpecies, getSpecies());
    }

    public CaracteristicQualitativeValue getSampleCategory() {
        return sampleCategory;
    }

    public void setSampleCategory(CaracteristicQualitativeValue sampleCategory) {
        Object oldValue = getSampleCategory();
        this.sampleCategory = sampleCategory;
        firePropertyChange(PROPERTY_SAMPLE_CATEGORY, oldValue, sampleCategory);
    }

    public Float getBatchWeight() {
        return batchWeight;
    }

    public void setBatchWeight(Float batchWeight) {
        Object oldValue = getBatchWeight();
        this.batchWeight = batchWeight;
        firePropertyChange(PROPERTY_BATCH_WEIGHT, oldValue, batchWeight);
    }

    public Integer getBatchCount() {
        return batchCount;
    }

    public void setBatchCount(Integer batchCount) {
        Object oldValue = getBatchCount();
        this.batchCount = batchCount;
        firePropertyChange(PROPERTY_BATCH_COUNT, oldValue, batchCount);
    }

    public List<SampleCategoryModelEntry> getCategory() {
        return category;
    }

    public void setCategory(List<SampleCategoryModelEntry> category) {
        Object oldValue = getCategory();
        this.category = category;
        firePropertyChange(PROPERTY_CATEGORY, oldValue, category);
    }

    @Override
    public SampleCategoryModelEntry getSelectedCategory() {
        return selectedCategory;
    }

    public void setSelectedCategory(SampleCategoryModelEntry selectedCategory) {
        Object oldValue = getSelectedCategory();
        this.selectedCategory = selectedCategory;
        firePropertyChange(PROPERTY_SELECTED_CATEGORY, oldValue, selectedCategory);
    }

    public Float getSampleWeight() {
        return sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Object oldValue = getSampleWeight();
        this.sampleWeight = sampleWeight;
        firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return speciesUsed;
    }

    public boolean isSpeciesAndCategoryAvailable() {
        boolean result = species != null && sampleCategory != null &&
                         isSpeciesAndCategoryAvailable(species, sampleCategory);
        return result;
    }

    public boolean isSpeciesAndCategoryAvailable(Species species,
                                                 CaracteristicQualitativeValue value) {
        boolean result = !speciesUsed.containsEntry(value, species);
        return result;
    }

    public boolean isCategoryIsFilled() {
        boolean result = selectedCategory != null;
        if (result) {
            result = false;
            for (SplitBenthosBatchRowModel rowModel : getRows()) {
                if (rowModel.isValid()) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    protected CreateBenthosBatchUIModel newEntity() {
        return new CreateBenthosBatchUIModel(sampleCategoryModel);
    }
}