/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <A, E extends Collection<A>> E addAll(E col, A ... e) {
        Collections.addAll(col, e);
        return col;
    }

    public static <A, E extends List<A>> E addAll(E col, int pos, A ... e) {
        col.addAll(pos, Arrays.asList(e));
        return (E)col;
    }

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static <O> Collection<O> toGenericCollection(Collection<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast Collection with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static <O> Set<O> toGenericSet(Set<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast Set with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static <T> T getOrNull(Collection<T> collection, int index) {
        T result = null;
        if (collection != null) {
            int i = 0;
            for (T t : collection) {
                if (index == i) {
                    result = t;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static <T> T get(Collection<T> collection, int index) throws IndexOutOfBoundsException {
        T result = null;
        if (collection != null) {
            int i = 0;
            for (T t : collection) {
                if (index == i) {
                    result = t;
                    break;
                }
                ++i;
            }
            if (i != index) {
                throw new IndexOutOfBoundsException("No element at index " + index);
            }
        }
        return result;
    }

    public static <T> T get(List<T> list, int index) throws IndexOutOfBoundsException {
        T result = null;
        if (list != null) {
            if (index >= list.size()) {
                throw new IndexOutOfBoundsException("No element at index " + index);
            }
            result = list.get(index);
        }
        return result;
    }

    public static <T> T getOrNull(List<T> list, int index) {
        T result = null;
        if (list != null && index < list.size()) {
            result = list.get(index);
        }
        return result;
    }
}

