/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableItem;

public final class TableColumnBandAdapter
extends ColumnBandAdapter {
    protected TableHandle element;

    TableColumnBandAdapter() {
    }

    TableColumnBandAdapter(TableHandle element) {
        this.element = element;
    }

    @Override
    protected ReportItemHandle getElementHandle() {
        return this.element;
    }

    @Override
    protected SlotHandle getColumns() {
        return this.element.getColumns();
    }

    @Override
    protected List getCellsUnderColumn(int columnIndex, boolean mustBeStartPosition) {
        ArrayList cells = new ArrayList();
        cells.addAll(this.getCellsInSlot(this.element.getHeader(), columnIndex, mustBeStartPosition));
        SlotHandle groups = this.element.getGroups();
        int i = 0;
        while (i < groups.getCount()) {
            GroupHandle group = (GroupHandle)groups.get(i);
            cells.addAll(this.getCellsInSlot(group.getHeader(), columnIndex, mustBeStartPosition));
            cells.addAll(this.getCellsInSlot(group.getFooter(), columnIndex, mustBeStartPosition));
            ++i;
        }
        cells.addAll(this.getCellsInSlot(this.element.getDetail(), columnIndex, mustBeStartPosition));
        cells.addAll(this.getCellsInSlot(this.element.getFooter(), columnIndex, mustBeStartPosition));
        return cells;
    }

    @Override
    protected int getCellPosition(CellHandle cell) {
        assert (cell != null);
        TableItem table = (TableItem)this.element.getElement();
        return table.getColumnPosition4Cell(this.getModule(), (Cell)cell.getElement());
    }

    @Override
    protected int getRowCount() {
        int numOfRows = 0;
        numOfRows += this.element.getHeader().getCount();
        SlotHandle groups = this.element.getGroups();
        int i = 0;
        while (i < groups.getCount()) {
            GroupHandle group = (GroupHandle)groups.get(i);
            numOfRows += group.getHeader().getCount();
            numOfRows += group.getFooter().getCount();
            ++i;
        }
        numOfRows += this.element.getDetail().getCount();
        return numOfRows += this.element.getFooter().getCount();
    }

    @Override
    protected int getColumnCount() {
        return this.element.getColumnCount();
    }

    @Override
    protected RowHandle getRow(int slotId, int groupId, int rowNumber) {
        RowHandle row = null;
        if (groupId == -1) {
            row = (RowHandle)this.element.getSlot(slotId).get(rowNumber);
        } else {
            GroupHandle group = (GroupHandle)this.element.getGroups().get(groupId);
            row = (RowHandle)group.getSlot(slotId).get(rowNumber);
        }
        return row;
    }

    @Override
    protected boolean hasDroppingCell(List cells) {
        int i = 0;
        while (i < cells.size()) {
            CellContextInfo cellInfo = (CellContextInfo)cells.get(i);
            String containerDefnName = cellInfo.getContainerDefnName();
            int slotId = cellInfo.getSlotId();
            if ("TableGroup".equals(containerDefnName) && slotId == 0 && !"none".equalsIgnoreCase(cellInfo.getDrop())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected List getRowContainerSlots() {
        ArrayList<SlotHandle> list = new ArrayList<SlotHandle>();
        list.add(this.element.getHeader());
        SlotHandle groups = this.element.getGroups();
        int i = 0;
        while (i < groups.getCount()) {
            GroupHandle group = (GroupHandle)groups.get(i);
            list.add(group.getHeader());
            list.add(group.getFooter());
            ++i;
        }
        list.add(this.element.getDetail());
        list.add(this.element.getFooter());
        return list;
    }
}

