// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: PropertySearch.java.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao;

import java.util.StringTokenizer;


/**
 * Provides the ability to search by properties.
 */
@SuppressWarnings({"unchecked"})
public class PropertySearch
    extends CriteriaSearch
{
    private Search search;

    /**
     * Constructor for PropertySearch. Creates a <code>PropertySearch</code> instance
     * from the given arguments.
     *
     * @param session The Hibernate session.
     * @param entityType The <code>Class</code> of the result.
     * @param search the object that specifies the search criteria.
     */
    public PropertySearch(
        final org.hibernate.Session session,
        final java.lang.Class entityType,
        final Search search)
    {
        super(session, entityType);
        this.search = search;
        try
        {
            this.initializeConverters();
            this.getConfiguration().setForceEagerLoading(search.isEagerFetching());
            final SearchParameter[] parameters = search.getParameters();
            if (parameters != null)
            {
                for (int ctr = 0; ctr < parameters.length; ctr++)
                {
                    final SearchParameter searchParameter = parameters[ctr];

                    Object value;
                    switch (searchParameter.getComparator())
                    {
                        case SearchParameter.IN_COMPARATOR :
                            value = searchParameter.getValue();
                            break;
                        case SearchParameter.NOT_IN_COMPARATOR :
                            value = searchParameter.getValue();
                            break;
                        default :
                            value = this.getValue(entityType, searchParameter);
                            break;
                    }

                    // - now add the parameter.
                    final CriteriaSearchParameter parameter =
                        new CriteriaSearchParameter(value,
                            searchParameter.getName(),
                            searchParameter.getComparator());
                    parameter.setOrderDirection(searchParameter.getOrder());
                    parameter.setSearchIfNull(searchParameter.isSearchIfNull());
                    switch (searchParameter.getMatch())
                    {
                        case SearchParameter.MATCH_ANYWHERE :
                            parameter.setMatchMode(org.hibernate.criterion.MatchMode.ANYWHERE);
                            break;
                        case SearchParameter.MATCH_START :
                            parameter.setMatchMode(org.hibernate.criterion.MatchMode.START);
                            break;
                        case SearchParameter.MATCH_END :
                            parameter.setMatchMode(org.hibernate.criterion.MatchMode.END);
                            break;
                        default:
                            parameter.setMatchMode(org.hibernate.criterion.MatchMode.EXACT);
                            break;
                    }
                    this.addParameter(parameter);
                    if (search.isUseSqlLimiting())
                    {
                        if (search.getPageNumber() > 0 && search.getPageSize() > 0)
                        {
                            // - set the first result as part of pagination support
                            this.getConfiguration().setFirstResult(new java.lang.Integer(this.calculateFirstResult(search.getPageNumber(), search.getPageSize())));
                            this.getConfiguration().setMaximumResultSize(new java.lang.Integer(search.getPageSize()));
                        }
                    }
                }
            }
        }
        catch (java.lang.Exception exception)
        {
            throw new RuntimeException(exception);
        }
    }

    /**
     * Stores the total count when sql limiting isn't used.
     */
    private int totalCount;

    /**
     * Gets the total possible count of objects returned in this
     * search.
     */
    public int getTotalCount()
    {
        int totalCount;
        if (this.search.isUseSqlLimiting())
        {
            // Remove first result requirement
            this.getConfiguration().setFirstResult(new java.lang.Integer(0));
            this.getRootCriteria().setProjection(
                org.hibernate.criterion.Projections.projectionList().add(
                    org.hibernate.criterion.Projections.rowCount()));
            // 24/10/2012 BL Passage de Integer en Long (changement dans l'API d'Hibernate)
            //totalCount = ((java.lang.Integer)this.executeAsList().iterator().next()).intValue();
            totalCount = ((java.lang.Long)this.executeAsList().iterator().next()).intValue();
        }
        else
        {
            totalCount = this.totalCount;
        }
        return totalCount;
    }

    /**
     * @see com.lighthousepmg.messaging.service.CriteriaSearch#executeAsList()
     */
    @Override
    public java.util.List executeAsList()
        throws org.hibernate.HibernateException
    {
        java.util.List results = super.executeAsList();
        if (!this.search.isUseSqlLimiting() && this.search.getPageNumber() > 0 && this.search.getPageSize() > 0)
        {
            int start = this.calculateFirstResult(search.getPageNumber(), search.getPageSize());
            int end = this.calculateLastResult(search.getPageNumber(), search.getPageSize());
            this.totalCount = results.size();
            if (this.totalCount < start)
            {
                start = this.totalCount;
            }
            if (this.totalCount < end)
            {
                end = this.totalCount;
            }
            results = results.subList(start, end);
        }
        return results;
    }

    /**
     * Calculates the first result based upon page size and current
     * desired page.
     *
     * @param pageNumber the page number to retrieve.
     * @param pageSize the page size to retrieve.
     *
     * @return the calculated first result.
     */
    private int calculateFirstResult(int pageNumber, int pageSize)
    {
        int firstResult = 0;
        if (pageNumber > 0 && pageSize > 0)
        {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    /**
     * Calculates the last result based upon page size and current
     * desired page.
     *
     * @param pageNumber the page number to retrieve.
     * @param pageSize the page size to retrieve.
     *
     * @return the calculated first result.
     */
    private int calculateLastResult(int pageNumber, int pageSize)
    {
        int lastResult = 0;
        if (pageNumber > 0 && pageSize > 0)
        {
            lastResult = pageNumber * pageSize;
        }
        return lastResult;
    }

    private static final String PERIOD = ".";

    /**
     * Initializes the converters to behave the way we want when converting values (we don't
     * want empty strings converted to zeros, like beanutils does by default)
     */
    private void initializeConverters()
    {
        org.apache.commons.beanutils.ConvertUtils.register(new org.apache.commons.beanutils.converters.LongConverter(null), java.lang.Long.class);
        org.apache.commons.beanutils.ConvertUtils.register(new org.apache.commons.beanutils.converters.IntegerConverter(null), java.lang.Integer.class);
        org.apache.commons.beanutils.ConvertUtils.register(new org.apache.commons.beanutils.converters.ShortConverter(null), java.lang.Short.class);
        org.apache.commons.beanutils.ConvertUtils.register(new CalendarConverter(), java.util.Calendar.class);
        org.apache.commons.beanutils.ConvertUtils.register(new DateConverter(), java.util.Date.class);
    }

    /**
     * Converts the value contained within the parameter to the type which Hibernate expects.
     *
     * @param entityType the class of the entity for which the search is being performed.
     * @param parameter the parameter from which to get the value.
     * @return the appropriate value.
     */
    private Object getValue(Class type, final SearchParameter parameter)
    {
        try
        {
            Object value = parameter.getValue();
            // - don't try to convert null values or classes
            if (value != null && !value.getClass().equals(Class.class))
            {
                Class propertyType = type;
                for (final StringTokenizer tokenizer = new StringTokenizer(parameter.getName(), PERIOD); tokenizer.hasMoreTokens();)
                {
                    final String token = tokenizer.nextToken().trim();
                    Class lastType = type;
                    type = CriteriaSearchProperties.getPropertyType(type, token);
                    if (!tokenizer.hasMoreTokens())
                    {
                        break;
                    }
                    if (type == null)
                    {
                        throw new RuntimeException("No accessible property named '" + token + "', exists on: " + lastType.getName());
                    }
                    propertyType = type;
                }
                final String name = parameter.getName().replaceAll(".*\\" + PERIOD, "");
                final Object object = propertyType.newInstance();
                // - copy the parameter to the property object so that when we retrieve it,
                //  its of the correct type
                org.apache.commons.beanutils.BeanUtils.copyProperty(
                    object,
                    name,
                    value);
                try
                {
                    value = org.apache.commons.beanutils.PropertyUtils.getProperty(
                            object,
                            name);
                }
                catch (final NoSuchMethodException noSuchMethodException)
                {
                    throw new RuntimeException("No accessible property named '" + name + "', exists on: " + propertyType.getName());
                }
            }
            return value;
        }
        catch (final Exception exception)
        {
            throw new RuntimeException(exception);
        }
    }

    /**
     * A beanutils converter that converts java.util.Calendar objects to java.util.Date instances.
     */
    private static final class DateConverter
        implements org.apache.commons.beanutils.Converter
    {
        public DateConverter()
        {
        }

        /**
         * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
         */
        public Object convert(
            Class type,
            Object value)
            throws org.apache.commons.beanutils.ConversionException
        {
            if (value != null)
            {
                try
                {
                    if (value instanceof java.util.Calendar)
                    {
                        value = ((java.util.Calendar)value).getTime();
                    }
                }
                catch (Exception ex)
                {
                    throw new org.apache.commons.beanutils.ConversionException(ex);
                }
            }
            return value;
        }
    }

    /**
     * A beanutils converter that converts java.util.Date objects to java.util.Calendar instances.
     */
    private static final class CalendarConverter
        implements org.apache.commons.beanutils.Converter
    {
        public CalendarConverter()
        {
        }

        /**
         * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
         */
        public Object convert(
            Class type,
            Object value)
            throws org.apache.commons.beanutils.ConversionException
        {
            if (value != null)
            {
                try
                {
                    if (value instanceof java.util.Date)
                    {
                        java.util.Calendar calendar = java.util.Calendar.getInstance();
                        calendar.setTime((java.util.Date)value);
                        value = calendar;
                    }
                }
                catch (Exception ex)
                {
                    throw new org.apache.commons.beanutils.ConversionException(ex);
                }
            }
            return value;
        }
    }
}