/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import fr.ifremer.tutti.service.export.AccidentalCatchExportModel;
import fr.ifremer.tutti.service.export.AccidentalCatchExportRow;
import fr.ifremer.tutti.service.export.CatchExportModel;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.IndividualObservationExportModel;
import fr.ifremer.tutti.service.export.IndividualObservationExportRow;
import fr.ifremer.tutti.service.export.MarineLitterExportModel;
import fr.ifremer.tutti.service.export.MarineLitterExportRow;
import fr.ifremer.tutti.service.export.OperationExportModel;
import fr.ifremer.tutti.service.export.OperationExportRow;
import fr.ifremer.tutti.service.export.ParameterExportModel;
import fr.ifremer.tutti.service.export.ParameterExportRow;
import fr.ifremer.tutti.service.export.SpeciesExportModel;
import fr.ifremer.tutti.service.export.SpeciesExportRow;
import fr.ifremer.tutti.service.export.SurveyExportModel;
import fr.ifremer.tutti.service.export.SurveyExportRow;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class TuttiExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected TuttiWeightComputingService tuttiWeightComputingService;
    protected char csvSeparator;
    protected Caracteristic verticalOpeningCaracteristic;
    protected Caracteristic horizontalOpeningWingCaracteristic;
    protected Caracteristic horizontalOpeningDoorCaracteristic;
    protected TuttiLocation country;
    protected List<SampleCategoryEnum> samplingOrder;
    protected Map<SampleCategoryEnum, Caracteristic> samplingToCaracteristic;
    protected Caracteristic sampleIdCaracteristic;
    protected Caracteristic otolitheIdCaracteristic;
    protected Caracteristic deadOrAliveCaracteristic;
    protected Caracteristic genderCaracteristic;
    protected Caracteristic weightMeasuredCaracteristic;
    protected Caracteristic pmfmIdCaracteristic;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.tuttiWeightComputingService = this.getService(TuttiWeightComputingService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
        this.verticalOpeningCaracteristic = this.persistenceService.getVerticalOpeningCaracteristic();
        this.horizontalOpeningWingCaracteristic = this.persistenceService.getHorizontalOpeningWingCaracteristic();
        this.horizontalOpeningDoorCaracteristic = this.persistenceService.getHorizontalOpeningDoorCaracteristic();
        this.sampleIdCaracteristic = this.persistenceService.getSampleIdCaracteristic();
        this.otolitheIdCaracteristic = this.persistenceService.getOtolitheIdCaracteristic();
        this.weightMeasuredCaracteristic = this.persistenceService.getWeightMeasuredCaracteristic();
        this.pmfmIdCaracteristic = this.persistenceService.getPmfmIdCaracteristic();
        this.deadOrAliveCaracteristic = this.persistenceService.getDeadOrAliveCaracteristic();
        this.genderCaracteristic = this.persistenceService.getSexCaracteristic();
        List<TuttiLocation> allCountry = this.persistenceService.getAllCountry();
        String countryId = context.getConfig().getExportCountryId();
        this.country = (TuttiLocation)TuttiEntities.splitById(allCountry).get(countryId);
        List<Caracteristic> allCaracteristic = this.persistenceService.getAllCaracteristic();
        Map allCaracteristicById = TuttiEntities.splitById(allCaracteristic);
        this.samplingToCaracteristic = Maps.newEnumMap(SampleCategoryEnum.class);
        Map idMapping = SampleCategoryEnum.toIdMapping();
        this.samplingOrder = Lists.newArrayList();
        this.samplingOrder.add(SampleCategoryEnum.sortedUnsorted);
        this.samplingToCaracteristic.put(SampleCategoryEnum.sortedUnsorted, (Caracteristic)allCaracteristicById.get(SampleCategoryEnum.sortedUnsorted.getFieldValue().toString()));
        for (Integer categoryId : context.getConfig().getSamplingOrderIds()) {
            SampleCategoryEnum categoryEnum = (SampleCategoryEnum)idMapping.get(categoryId);
            if (SampleCategoryEnum.sortedUnsorted != categoryEnum) {
                this.samplingOrder.add(categoryEnum);
            }
            this.samplingToCaracteristic.put(categoryEnum, (Caracteristic)allCaracteristicById.get(categoryId.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProgram(String programId, TuttiProtocol protocol, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)programId);
        Preconditions.checkNotNull((Object)exportFile);
        Program program = this.persistenceService.getProgram(programId);
        Preconditions.checkNotNull((Object)program);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export program: " + programId));
        }
        List<Cruise> allCruise = this.persistenceService.getAllCruise(programId);
        for (Cruise cruise : allCruise) {
            this.checkCruise(progressionModel, cruise);
        }
        File basedir = new File(this.context.getConfig().newTempFile("exportProgram"), "exportProgram-" + programId);
        TuttiIOUtil.forceMkdir((File)basedir, (String)I18n._((String)"tutti.service.mkDir.error", (Object[])new Object[]{basedir}));
        ExportContext exportContext = this.createExportContext(basedir, protocol);
        try {
            for (Cruise cruise : allCruise) {
                cruise = this.persistenceService.getCruise(cruise.getId());
                this.exportCruise(cruise, exportContext, progressionModel);
            }
            TuttiIOUtil.close((Closeable)exportContext, (String)I18n._((String)"tutti.service.export.closeContext.error", (Object[])new Object[0]));
            progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            TuttiIOUtil.zip((File)basedir, (File)exportFile, (String)I18n._((String)"tutti.service.export.zip.error", (Object[])new Object[]{exportFile}));
            progressionModel.increments(1);
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCruise(String cruiseId, TuttiProtocol protocol, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export cruise: " + cruiseId));
        }
        this.checkCruise(progressionModel, cruise);
        File basedir = new File(this.context.getConfig().newTempFile("exportCruise"), "exportCruise-" + cruiseId);
        TuttiIOUtil.forceMkdir((File)basedir, (String)I18n._((String)"tutti.service.mkDir.error", (Object[])new Object[]{basedir}));
        ExportContext exportContext = this.createExportContext(basedir, protocol);
        try {
            this.exportCruise(cruise, exportContext, progressionModel);
            TuttiIOUtil.close((Closeable)exportContext, (String)I18n._((String)"tutti.service.export.closeContext.error", (Object[])new Object[0]));
            progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            TuttiIOUtil.zip((File)basedir, (File)exportFile, (String)I18n._((String)"tutti.service.export.zip.error", (Object[])new Object[]{exportFile}));
            progressionModel.increments(1);
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
    }

    protected ExportContext createExportContext(File basedir, TuttiProtocol protocol) {
        List<Species> allReferentSpecies = this.persistenceService.getAllReferentSpecies(protocol);
        Map speciesById = TuttiEntities.splitById(allReferentSpecies);
        return new ExportContext(basedir, this.csvSeparator, this.decoratorService, this.verticalOpeningCaracteristic, this.horizontalOpeningWingCaracteristic, this.horizontalOpeningDoorCaracteristic, this.sampleIdCaracteristic, this.otolitheIdCaracteristic, this.weightMeasuredCaracteristic, this.deadOrAliveCaracteristic, this.genderCaracteristic, this.pmfmIdCaracteristic, this.samplingOrder, this.samplingToCaracteristic, speciesById);
    }

    protected void checkCruise(ProgressionModel progressionModel, Cruise cruise) {
        Preconditions.checkNotNull((Object)cruise);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.checkCruise", (Object[])new Object[]{cruise.getName()}));
        Map<String, String> errors = this.tuttiWeightComputingService.checkCruise(cruise.getId());
        progressionModel.increments(1);
        if (MapUtils.isNotEmpty(errors)) {
            Decorator<Cruise> cruiseDecorator = this.decoratorService.getDecoratorByType(Cruise.class);
            Decorator<FishingOperation> fishingOperationDecorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : errors.entrySet()) {
                String fishingOperationId = entry.getKey();
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
                String fishingOperationStr = fishingOperationDecorator.toString((Object)fishingOperation);
                sb.append(I18n._((String)"tutti.service.export.invalid.fishingOperation", (Object[])new Object[]{fishingOperationStr, entry.getValue()}));
            }
            String cruiseStr = cruiseDecorator.toString((Object)cruise);
            throw new TuttiBusinessException(I18n._((String)"tutti.service.export.invalid.cruise", (Object[])new Object[]{cruiseStr, sb.toString()}));
        }
    }

    protected void exportCruise(Cruise cruise, ExportContext exportContext, ProgressionModel progressionModel) {
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruise.getId());
        ArrayList loadedOperations = Lists.newArrayListWithCapacity((int)operations.size());
        for (FishingOperation operation : operations) {
            FishingOperation loadedOeration = this.persistenceService.getFishingOperation(operation.getId());
            loadedOperations.add(loadedOeration);
        }
        String cruiseName = cruise.getName();
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportSurvey", (Object[])new Object[]{cruiseName}));
        this.exportSurvey(exportContext, cruise);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportOperations", (Object[])new Object[]{cruiseName}));
        this.exportOperations(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportParameters", (Object[])new Object[]{cruiseName}));
        this.exportParameters(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportMarineLitters", (Object[])new Object[]{cruiseName}));
        this.exportMarineLitters(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportIndividualObservations", (Object[])new Object[]{cruiseName}));
        this.exportIndividualObservations(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportAccidentalCatches", (Object[])new Object[]{cruiseName}));
        this.exportAccidentalCatch(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportCatches", (Object[])new Object[]{cruiseName}));
        this.exportCatches(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportSpecies", (Object[])new Object[]{cruiseName}));
        this.exportSpecies(exportContext, exportContext.getSpeciesToExport());
        progressionModel.increments(1);
    }

    protected void exportSurvey(ExportContext exportContext, Cruise cruise) {
        try {
            ArrayList rows = Lists.newArrayList();
            exportContext.surveyModel.prepareRows(rows, cruise, this.country);
            exportContext.surveyExport.write(rows, exportContext.surveyWriter);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.survey.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportOperations(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            ArrayList rows = Lists.newArrayList();
            exportContext.operationModel.prepareRows(rows, cruise, operations);
            exportContext.operationExport.write(rows, exportContext.operationWriter);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.operations.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportParameters(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                exportContext.parameterModel.prepareRows(rows, cruise, operation);
                exportContext.parameterExport.write(rows, exportContext.parameterWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.parameters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportMarineLitters(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                boolean withCatchBatch = this.withCatch(operation);
                if (!withCatchBatch) continue;
                ArrayList rows = Lists.newArrayList();
                exportContext.marineLitterModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.marineLitterExport.write(rows, exportContext.marineLitterWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.parameters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportIndividualObservations(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                boolean withCatchBatch = this.withCatch(operation);
                if (!withCatchBatch) continue;
                ArrayList rows = Lists.newArrayList();
                exportContext.individualObservationModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.speciesModel.prepareIndividualRows(exportContext, rows);
                exportContext.individualObservationExport.write(rows, exportContext.individualObservationWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.parameters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportAccidentalCatch(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                exportContext.accidentalCatchModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.speciesModel.prepareAccidentalRows(exportContext, rows);
                exportContext.accidentalCatchExport.write(rows, exportContext.accidentalCatchWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.parameters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportCatches(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                boolean withCatchBatch = this.withCatch(operation);
                if (!withCatchBatch) continue;
                String operationId = operation.getId();
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                BatchContainer<SpeciesBatch> rootSpeciesBatch = this.tuttiWeightComputingService.getComputedSpeciesBatches(operation);
                BatchContainer<BenthosBatch> rootBenthosBatch = this.tuttiWeightComputingService.getComputedBenthosBatches(operation);
                BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.tuttiWeightComputingService.getComputedMarineLitterBatches(operation, catchBatch.getMarineLitterTotalWeight());
                this.tuttiWeightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
                exportContext.speciesModel.prepareBatchRows(exportContext, rootSpeciesBatch, rootBenthosBatch);
                Float totalWeight = catchBatch.getCatchTotalWeight();
                if (totalWeight == null) {
                    totalWeight = catchBatch.getCatchTotalComputedWeight();
                }
                Float totalUnsortedWeight = catchBatch.getCatchTotalUnsortedComputedWeight();
                Float totalSpeciesWeight = catchBatch.getSpeciesTotalSampleSortedComputedWeight();
                Float totalBenthosWeight = catchBatch.getBenthosTotalSampleSortedComputedWeight();
                Float speciesCatchRaisingFactor = Float.valueOf((totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalSpeciesWeight.floatValue());
                Float benthosCatchRaisingFactor = Float.valueOf((totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalBenthosWeight.floatValue());
                ArrayList rows = Lists.newArrayList();
                exportContext.catchModel.prepareRows(this.persistenceService, rows, cruise, operation, rootSpeciesBatch, rootBenthosBatch, speciesCatchRaisingFactor, benthosCatchRaisingFactor);
                exportContext.catchExport.write(rows, exportContext.catchWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.catches.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportSpecies(ExportContext exportContext, List<SpeciesExportRow> rows) {
        try {
            exportContext.speciesExport.write(rows, exportContext.speciesWriter);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.catches.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected boolean withCatch(FishingOperation operation) {
        String operationId = operation.getId();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(operationId);
        if (!withCatchBatch && log.isWarnEnabled()) {
            log.warn((Object)("Skip fishing operation " + operationId + " since no catchBatch associated."));
        }
        return withCatchBatch;
    }

    protected static class ExportContext
    implements Closeable {
        File surveyFile;
        File operationFile;
        File parameterFile;
        File marineLitterFile;
        File individualObservationFile;
        File catchFile;
        File accidentalCatchFile;
        File speciesFile;
        BufferedWriter surveyWriter;
        BufferedWriter operationWriter;
        BufferedWriter parameterWriter;
        BufferedWriter marineLitterWriter;
        BufferedWriter catchWriter;
        BufferedWriter accidentalCatchWriter;
        BufferedWriter individualObservationWriter;
        BufferedWriter speciesWriter;
        SurveyExportModel surveyModel;
        OperationExportModel operationModel;
        MarineLitterExportModel marineLitterModel;
        ParameterExportModel parameterModel;
        CatchExportModel catchModel;
        AccidentalCatchExportModel accidentalCatchModel;
        IndividualObservationExportModel individualObservationModel;
        SpeciesExportModel speciesModel;
        final Map<String, SpeciesExportRow> speciesToExport = Maps.newTreeMap();
        TuttiCsvUtil.TuttiRepeatableExport<SurveyExportRow> surveyExport;
        TuttiCsvUtil.TuttiRepeatableExport<OperationExportRow> operationExport;
        TuttiCsvUtil.TuttiRepeatableExport<MarineLitterExportRow> marineLitterExport;
        TuttiCsvUtil.TuttiRepeatableExport<ParameterExportRow> parameterExport;
        TuttiCsvUtil.TuttiRepeatableExport<CatchExportRow> catchExport;
        TuttiCsvUtil.TuttiRepeatableExport<AccidentalCatchExportRow> accidentalCatchExport;
        TuttiCsvUtil.TuttiRepeatableExport<IndividualObservationExportRow> individualObservationExport;
        TuttiCsvUtil.TuttiRepeatableExport<SpeciesExportRow> speciesExport;
        Map<String, Species> speciesById;

        ExportContext(File basedir, char csvSeparator, DecoratorService decoratorService, Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic, Caracteristic sampleIdCaracteristic, Caracteristic otolitheIdCaracteristic, Caracteristic weightMeasuredCaracteristic, Caracteristic deadOrAliveCaracteristic, Caracteristic genderCaracteristic, Caracteristic pmfmIdCaracteristic, List<SampleCategoryEnum> samplingOrder, Map<SampleCategoryEnum, Caracteristic> samplingToCaracteristic, Map<String, Species> speciesById) {
            this.speciesById = speciesById;
            try {
                this.surveyFile = new File(basedir, "survey.csv");
                this.surveyWriter = Files.newWriter((File)this.surveyFile, (Charset)Charsets.UTF_8);
                this.operationFile = new File(basedir, "operation.csv");
                this.operationWriter = Files.newWriter((File)this.operationFile, (Charset)Charsets.UTF_8);
                this.marineLitterFile = new File(basedir, "marineLitter.csv");
                this.marineLitterWriter = Files.newWriter((File)this.marineLitterFile, (Charset)Charsets.UTF_8);
                this.parameterFile = new File(basedir, "parameter.csv");
                this.parameterWriter = Files.newWriter((File)this.parameterFile, (Charset)Charsets.UTF_8);
                this.catchFile = new File(basedir, "catch.csv");
                this.catchWriter = Files.newWriter((File)this.catchFile, (Charset)Charsets.UTF_8);
                this.accidentalCatchFile = new File(basedir, "accidentalCatch.csv");
                this.accidentalCatchWriter = Files.newWriter((File)this.accidentalCatchFile, (Charset)Charsets.UTF_8);
                this.individualObservationFile = new File(basedir, "individualObservation.csv");
                this.individualObservationWriter = Files.newWriter((File)this.individualObservationFile, (Charset)Charsets.UTF_8);
                this.speciesFile = new File(basedir, "species.csv");
                this.speciesWriter = Files.newWriter((File)this.speciesFile, (Charset)Charsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.export.context.error", (Object[])new Object[0]), (Throwable)e);
            }
            this.surveyModel = new SurveyExportModel(csvSeparator);
            this.operationModel = new OperationExportModel(csvSeparator, verticalOpeningCaracteristic, horizontalOpeningWingCaracteristic, horizontalOpeningDoorCaracteristic);
            this.parameterModel = new ParameterExportModel(csvSeparator, decoratorService);
            this.marineLitterModel = new MarineLitterExportModel(csvSeparator);
            this.catchModel = new CatchExportModel(csvSeparator, samplingOrder, samplingToCaracteristic);
            this.accidentalCatchModel = new AccidentalCatchExportModel(csvSeparator, deadOrAliveCaracteristic, genderCaracteristic, weightMeasuredCaracteristic, pmfmIdCaracteristic);
            this.individualObservationModel = new IndividualObservationExportModel(csvSeparator, sampleIdCaracteristic, otolitheIdCaracteristic, weightMeasuredCaracteristic, pmfmIdCaracteristic);
            this.speciesModel = new SpeciesExportModel(csvSeparator);
            this.surveyExport = TuttiCsvUtil.newRepeatableExport(this.surveyModel);
            this.operationExport = TuttiCsvUtil.newRepeatableExport(this.operationModel);
            this.parameterExport = TuttiCsvUtil.newRepeatableExport(this.parameterModel);
            this.marineLitterExport = TuttiCsvUtil.newRepeatableExport(this.marineLitterModel);
            this.catchExport = TuttiCsvUtil.newRepeatableExport(this.catchModel);
            this.accidentalCatchExport = TuttiCsvUtil.newRepeatableExport(this.accidentalCatchModel);
            this.individualObservationExport = TuttiCsvUtil.newRepeatableExport(this.individualObservationModel);
            this.speciesExport = TuttiCsvUtil.newRepeatableExport(this.speciesModel);
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly((Writer)this.surveyWriter);
            IOUtils.closeQuietly((Writer)this.operationWriter);
            IOUtils.closeQuietly((Writer)this.parameterWriter);
            IOUtils.closeQuietly((Writer)this.catchWriter);
            IOUtils.closeQuietly((Writer)this.accidentalCatchWriter);
            IOUtils.closeQuietly((Writer)this.marineLitterWriter);
            IOUtils.closeQuietly((Writer)this.individualObservationWriter);
            IOUtils.closeQuietly((Writer)this.speciesWriter);
        }

        public void addSpecies(Species species) {
            String speciesId = species.getId();
            if (!this.speciesToExport.containsKey(speciesId)) {
                Species fullSpecies = this.speciesById.get(speciesId);
                SpeciesExportRow row = new SpeciesExportRow();
                row.setSpecies(fullSpecies);
                this.speciesToExport.put(speciesId, row);
            }
        }

        public List<SpeciesExportRow> getSpeciesToExport() {
            ArrayList result = Lists.newArrayList(this.speciesToExport.values());
            Collections.sort(result, new Comparator<SpeciesExportRow>(){

                @Override
                public int compare(SpeciesExportRow o1, SpeciesExportRow o2) {
                    return o1.getSpecies().getReferenceTaxonId().compareTo(o2.getSpecies().getReferenceTaxonId());
                }
            });
            return result;
        }
    }
}

