/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.validation;

import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.andromda.core.engine.ModelProcessorException;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.translation.ocl.BaseTranslator;
import org.andromda.translation.ocl.node.AActualParameterList;
import org.andromda.translation.ocl.node.AArrowPropertyCallExpressionTail;
import org.andromda.translation.ocl.node.AAttributeOrAssociationContextDeclaration;
import org.andromda.translation.ocl.node.ABodyOperationStereotype;
import org.andromda.translation.ocl.node.AClassifierContextDeclaration;
import org.andromda.translation.ocl.node.AContextDeclaration;
import org.andromda.translation.ocl.node.ADefClassifierExpressionBody;
import org.andromda.translation.ocl.node.ADotPropertyCallExpressionTail;
import org.andromda.translation.ocl.node.AEqualExpression;
import org.andromda.translation.ocl.node.AFeatureCall;
import org.andromda.translation.ocl.node.AFeatureCallParameters;
import org.andromda.translation.ocl.node.AFeaturePrimaryExpression;
import org.andromda.translation.ocl.node.AIfExpression;
import org.andromda.translation.ocl.node.AImpliesLogicalOperator;
import org.andromda.translation.ocl.node.AInvClassifierExpressionBody;
import org.andromda.translation.ocl.node.ALetExp;
import org.andromda.translation.ocl.node.ALetVariableDeclaration;
import org.andromda.translation.ocl.node.ALogicalExp;
import org.andromda.translation.ocl.node.ALogicalExpressionTail;
import org.andromda.translation.ocl.node.AMessageExpression;
import org.andromda.translation.ocl.node.ANotUnaryOperator;
import org.andromda.translation.ocl.node.AOperationContextDeclaration;
import org.andromda.translation.ocl.node.APathName;
import org.andromda.translation.ocl.node.APostOperationStereotype;
import org.andromda.translation.ocl.node.APreOperationStereotype;
import org.andromda.translation.ocl.node.APropertyCallExpression;
import org.andromda.translation.ocl.node.ARelationalExpression;
import org.andromda.translation.ocl.node.ARelationalExpressionTail;
import org.andromda.translation.ocl.node.ATypeDeclaration;
import org.andromda.translation.ocl.node.AUnaryExpression;
import org.andromda.translation.ocl.node.AVariableDeclaration;
import org.andromda.translation.ocl.node.AVariableDeclarationLetExpSub;
import org.andromda.translation.ocl.node.AVariableDeclarationList;
import org.andromda.translation.ocl.node.AVariableDeclarationListTail;
import org.andromda.translation.ocl.node.Node;
import org.andromda.translation.ocl.node.PAttributeOrAssociationExpressionBody;
import org.andromda.translation.ocl.node.PClassifierExpressionBody;
import org.andromda.translation.ocl.node.PContextDeclaration;
import org.andromda.translation.ocl.node.PFeatureCallParameters;
import org.andromda.translation.ocl.node.POperationExpressionBody;
import org.andromda.translation.ocl.node.PPropertyCallExpressionTail;
import org.andromda.translation.ocl.node.PVariableDeclarationListTail;
import org.andromda.translation.ocl.node.Switch;
import org.andromda.translation.ocl.node.TAnd;
import org.andromda.translation.ocl.node.TApostrophe;
import org.andromda.translation.ocl.node.TArrow;
import org.andromda.translation.ocl.node.TAttr;
import org.andromda.translation.ocl.node.TBag;
import org.andromda.translation.ocl.node.TBar;
import org.andromda.translation.ocl.node.TBlank;
import org.andromda.translation.ocl.node.TBody;
import org.andromda.translation.ocl.node.TBoolean;
import org.andromda.translation.ocl.node.TCollection;
import org.andromda.translation.ocl.node.TColon;
import org.andromda.translation.ocl.node.TComma;
import org.andromda.translation.ocl.node.TCommercialAt;
import org.andromda.translation.ocl.node.TContext;
import org.andromda.translation.ocl.node.TDef;
import org.andromda.translation.ocl.node.TDerive;
import org.andromda.translation.ocl.node.TDiv;
import org.andromda.translation.ocl.node.TDot;
import org.andromda.translation.ocl.node.TElse;
import org.andromda.translation.ocl.node.TEndif;
import org.andromda.translation.ocl.node.TEndpackage;
import org.andromda.translation.ocl.node.TEnum;
import org.andromda.translation.ocl.node.TEqual;
import org.andromda.translation.ocl.node.TGt;
import org.andromda.translation.ocl.node.TGteq;
import org.andromda.translation.ocl.node.TIf;
import org.andromda.translation.ocl.node.TImplies;
import org.andromda.translation.ocl.node.TIn;
import org.andromda.translation.ocl.node.TInit;
import org.andromda.translation.ocl.node.TInt;
import org.andromda.translation.ocl.node.TInv;
import org.andromda.translation.ocl.node.TIsSentOperator;
import org.andromda.translation.ocl.node.TLBrace;
import org.andromda.translation.ocl.node.TLBracket;
import org.andromda.translation.ocl.node.TLParen;
import org.andromda.translation.ocl.node.TLet;
import org.andromda.translation.ocl.node.TLt;
import org.andromda.translation.ocl.node.TLteq;
import org.andromda.translation.ocl.node.TMessageOperator;
import org.andromda.translation.ocl.node.TMinus;
import org.andromda.translation.ocl.node.TMult;
import org.andromda.translation.ocl.node.TName;
import org.andromda.translation.ocl.node.TNewLine;
import org.andromda.translation.ocl.node.TNot;
import org.andromda.translation.ocl.node.TNotEqual;
import org.andromda.translation.ocl.node.TOper;
import org.andromda.translation.ocl.node.TOr;
import org.andromda.translation.ocl.node.TOrderedset;
import org.andromda.translation.ocl.node.TPackage;
import org.andromda.translation.ocl.node.TPlus;
import org.andromda.translation.ocl.node.TPost;
import org.andromda.translation.ocl.node.TPre;
import org.andromda.translation.ocl.node.TRBrace;
import org.andromda.translation.ocl.node.TRBracket;
import org.andromda.translation.ocl.node.TRParen;
import org.andromda.translation.ocl.node.TRange;
import org.andromda.translation.ocl.node.TReal;
import org.andromda.translation.ocl.node.TScopeOperator;
import org.andromda.translation.ocl.node.TSemicolon;
import org.andromda.translation.ocl.node.TSequence;
import org.andromda.translation.ocl.node.TSet;
import org.andromda.translation.ocl.node.TSingleLineComment;
import org.andromda.translation.ocl.node.TStringLit;
import org.andromda.translation.ocl.node.TTab;
import org.andromda.translation.ocl.node.TThen;
import org.andromda.translation.ocl.node.TTuple;
import org.andromda.translation.ocl.node.TTupletype;
import org.andromda.translation.ocl.node.TUnknown;
import org.andromda.translation.ocl.node.TXor;
import org.andromda.translation.ocl.syntax.ConcreteSyntaxUtils;
import org.andromda.translation.ocl.syntax.OCLFeatures;
import org.andromda.translation.ocl.syntax.OCLPatterns;
import org.andromda.translation.ocl.validation.OCLPredicateFeatures;
import org.andromda.translation.ocl.validation.ValidationTranslatorException;
import org.apache.commons.lang.StringUtils;

public class ValidationJavaTranslator
extends BaseTranslator {
    private static Properties features = null;
    private static final String OCL_TRANSLATOR_PACKAGE = "org.andromda.translation.ocl.validation";
    private boolean requiresBooleanConversion = false;
    private final Stack translationLayers = new Stack();
    private final Stack arrowPropertyCallStack = new Stack();
    private final Stack letVariableStack = new Stack();
    private static final String CONTEXT_ELEMENT_NAME = "contextElement";
    private static final String OCL_INTROSPECTOR_INVOKE_PREFIX = "org.andromda.translation.ocl.validation.OCLIntrospector.invoke(";
    private static final String BOOLEAN_WRAP_PREFIX = "Boolean.valueOf(String.valueOf(";
    private static final String BOOLEAN_WRAP_SUFFIX = ")).booleanValue()";
    static /* synthetic */ Class class$org$andromda$translation$ocl$validation$ValidationJavaTranslator;

    public void caseAContextDeclaration(AContextDeclaration node) {
        this.newTranslationLayer();
        Object[] temp = node.getContextDeclaration().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((PContextDeclaration)temp[ctr]).apply((Switch)this);
        }
        this.mergeTranslationLayers();
        this.getExpression().appendToTranslatedExpression(this.translationLayers.peek());
        this.translationLayers.clear();
    }

    public void caseAClassifierContextDeclaration(AClassifierContextDeclaration node) {
        super.inAClassifierContextDeclaration(node);
        Object[] temp = node.getClassifierExpressionBody().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((PClassifierExpressionBody)temp[ctr]).apply((Switch)this);
        }
    }

    public void caseAOperationContextDeclaration(AOperationContextDeclaration node) {
        super.inAOperationContextDeclaration(node);
        Object[] temp = node.getOperationExpressionBody().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((POperationExpressionBody)temp[ctr]).apply((Switch)this);
        }
    }

    public void caseAAttributeOrAssociationContextDeclaration(AAttributeOrAssociationContextDeclaration node) {
        super.inAAttributeOrAssociationContextDeclaration(node);
        Object[] temp = node.getAttributeOrAssociationExpressionBody().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((PAttributeOrAssociationExpressionBody)temp[ctr]).apply((Switch)this);
        }
    }

    public void caseAInvClassifierExpressionBody(AInvClassifierExpressionBody node) {
        super.inAInvClassifierExpressionBody(node);
        node.getExpression().apply((Switch)this);
    }

    public void caseADefClassifierExpressionBody(ADefClassifierExpressionBody node) {
        super.inADefClassifierExpressionBody(node);
        node.getDefinitionExpression().apply((Switch)this);
    }

    public void inAArrowPropertyCallExpressionTail(AArrowPropertyCallExpressionTail node) {
        this.arrowPropertyCallStack.push(Boolean.TRUE);
    }

    public void outAArrowPropertyCallExpressionTail(AArrowPropertyCallExpressionTail node) {
        this.arrowPropertyCallStack.pop();
    }

    public void inADotPropertyCallExpressionTail(ADotPropertyCallExpressionTail node) {
        this.arrowPropertyCallStack.push(Boolean.FALSE);
    }

    public void outADotPropertyCallExpressionTail(ADotPropertyCallExpressionTail node) {
        this.arrowPropertyCallStack.pop();
    }

    public void caseALetVariableDeclaration(ALetVariableDeclaration node) {
        this.inALetVariableDeclaration(node);
        if (node.getVariableDeclaration() != null) {
            node.getVariableDeclaration().apply((Switch)this);
        }
        if (node.getEqual() != null) {
            this.write("=");
        }
        if (node.getExpression() != null) {
            node.getExpression().apply((Switch)this);
        }
        this.outALetVariableDeclaration(node);
    }

    public void inALetVariableDeclaration(ALetVariableDeclaration node) {
        this.newTranslationLayer();
        AVariableDeclaration variableDeclaration = (AVariableDeclaration)node.getVariableDeclaration();
        String variableName = variableDeclaration.getName().getText();
        this.newTranslationLayer();
        node.getExpression().apply((Switch)this);
        String variableValue = this.translationLayers.pop().toString();
        this.addLetVariableToContext(variableName, variableValue);
    }

    public void outALetVariableDeclaration(ALetVariableDeclaration node) {
        this.write(";");
        this.translationLayers.pop();
    }

    public void caseAVariableDeclaration(AVariableDeclaration node) {
        if (node.getTypeDeclaration() == null) {
            this.write("java.lang.Object");
        } else {
            node.getTypeDeclaration().apply((Switch)this);
        }
        this.write(" ");
        node.getName().apply((Switch)this);
    }

    public void caseATypeDeclaration(ATypeDeclaration node) {
        node.getType().apply((Switch)this);
    }

    public void caseAVariableDeclarationList(AVariableDeclarationList node) {
        node.getVariableDeclaration().apply((Switch)this);
        if (node.getVariableDeclarationValue() != null) {
            node.getVariableDeclarationValue().apply((Switch)this);
        }
        Object[] temp = node.getVariableDeclarationListTail().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((PVariableDeclarationListTail)temp[ctr]).apply((Switch)this);
        }
    }

    public void caseAVariableDeclarationListTail(AVariableDeclarationListTail node) {
        node.getComma().apply((Switch)this);
        node.getVariableDeclaration().apply((Switch)this);
        if (node.getVariableDeclarationValue() != null) {
            node.getVariableDeclarationValue().apply((Switch)this);
        }
    }

    public void caseAEqualExpression(AEqualExpression node) {
        node.getEqual().apply((Switch)this);
        node.getExpression().apply((Switch)this);
    }

    public void caseABodyOperationStereotype(ABodyOperationStereotype node) {
    }

    public void caseAPreOperationStereotype(APreOperationStereotype node) {
    }

    public void caseAPostOperationStereotype(APostOperationStereotype node) {
    }

    public void caseAMessageExpression(AMessageExpression node) {
    }

    public void caseAIfExpression(AIfExpression node) {
        node.getIf().apply((Switch)this);
        this.write("(");
        node.getIfBranch().apply((Switch)this);
        this.write(")");
        node.getThen().apply((Switch)this);
        this.write("{");
        node.getThenBranch().apply((Switch)this);
        this.write(";");
        this.write("}");
        node.getElse().apply((Switch)this);
        this.write("{");
        node.getElseBranch().apply((Switch)this);
        this.write(";");
        this.write("}");
    }

    public void caseAPropertyCallExpression(APropertyCallExpression node) {
        this.newTranslationLayer();
        node.getPrimaryExpression().apply((Switch)this);
        Object[] temp = node.getPropertyCallExpressionTail().toArray();
        for (int ctr = 0; ctr < temp.length; ++ctr) {
            ((PPropertyCallExpressionTail)temp[ctr]).apply((Switch)this);
        }
        this.mergeTranslationLayerAfter();
    }

    public void caseADotPropertyCallExpressionTail(ADotPropertyCallExpressionTail node) {
        this.inADotPropertyCallExpressionTail(node);
        String expression = TranslationUtils.trimToEmpty((Object)node);
        if (OCLPatterns.isOperation((Object)expression)) {
            AFeatureCall featureCall = (AFeatureCall)node.getFeatureCall();
            String featureCallExpression = TranslationUtils.trimToEmpty((Object)node.getFeatureCall());
            if (OCLFeatures.isOclIsKindOf((Object)featureCallExpression)) {
                this.handleOclIsKindOf(featureCall);
            } else if (OCLFeatures.isOclIsTypeOf((Object)featureCallExpression)) {
                this.handleOclIsTypeOf(featureCall);
            } else if (OCLFeatures.isConcat((Object)featureCallExpression)) {
                this.handleConcat(featureCall);
            } else {
                this.handleDotFeatureCall(featureCall);
            }
        }
        this.outADotPropertyCallExpressionTail(node);
    }

    private void handleOclIsKindOf(Object node) {
        String type = this.getParametersAsType(node);
        if (type != null) {
            this.write(" instanceof ");
            this.write(type);
        }
    }

    private void handleOclIsTypeOf(Object node) {
        String type = this.getParametersAsType(node);
        if (type != null) {
            this.write(".getClass().getName().equals(");
            this.write(type);
            this.write(".class.getName())");
        }
    }

    private String getParametersAsType(Object node) {
        String type = null;
        if (node instanceof AFeatureCall) {
            type = ConcreteSyntaxUtils.getParametersAsString((AFeatureCall)((AFeatureCall)node));
        } else if (node instanceof AFeatureCallParameters) {
            type = ConcreteSyntaxUtils.getParametersAsString((PFeatureCallParameters)((AFeatureCallParameters)node));
        }
        if (type != null && (type = type.replaceAll("\\s*::\\s*", ".")).indexOf(".") == -1 && this.getModelElement() != null) {
            type = this.getModelElement().getPackageName() + "." + type;
        }
        return type;
    }

    private void handleConcat(AFeatureCall featureCall) {
        this.write(" + \"\" + ");
        this.write(OCL_INTROSPECTOR_INVOKE_PREFIX);
        this.write(CONTEXT_ELEMENT_NAME);
        this.write(",\"");
        this.write(ConcreteSyntaxUtils.getParametersAsString((AFeatureCall)featureCall).replaceAll("\\s*", ""));
        this.write("\")");
    }

    public void handleDotFeatureCall(AFeatureCall featureCall) {
        List parameters;
        this.prependToTranslationLayer(OCL_INTROSPECTOR_INVOKE_PREFIX);
        this.appendToTranslationLayer(",\"");
        this.appendToTranslationLayer(TranslationUtils.deleteWhitespace((Object)featureCall));
        this.appendToTranslationLayer("\"");
        if (featureCall.getFeatureCallParameters() != null && (parameters = ConcreteSyntaxUtils.getParameters((AFeatureCall)featureCall)) != null && !parameters.isEmpty()) {
            this.write(",new Object[]{");
            this.appendToTranslationLayer(OCL_INTROSPECTOR_INVOKE_PREFIX);
            this.appendToTranslationLayer(CONTEXT_ELEMENT_NAME);
            this.appendToTranslationLayer(",\"");
            this.appendToTranslationLayer(ConcreteSyntaxUtils.getParameters((AFeatureCall)featureCall).get(0));
            this.appendToTranslationLayer("\")}");
        }
        this.appendToTranslationLayer(")");
    }

    public void caseAArrowPropertyCallExpressionTail(AArrowPropertyCallExpressionTail node) {
        this.inAArrowPropertyCallExpressionTail(node);
        node.getArrow().apply((Switch)this);
        this.handleArrowFeatureCall((AFeatureCall)node.getFeatureCall());
        this.outAArrowPropertyCallExpressionTail(node);
    }

    protected boolean isOperationArgument(String argument) {
        return super.isOperationArgument(this.getRootName(argument));
    }

    private String getRootName(String navigationalPath) {
        return StringUtils.trimToEmpty((String)navigationalPath).replaceAll("\\..*", "");
    }

    private String getPathTail(String navigationalPath) {
        int dotIndex = navigationalPath.indexOf(".");
        return dotIndex != -1 ? navigationalPath.substring(dotIndex + 1, navigationalPath.length()) : navigationalPath;
    }

    public void caseAFeaturePrimaryExpression(AFeaturePrimaryExpression node) {
        this.inAFeaturePrimaryExpression(node);
        if (node.getPathName() != null) {
            String variableName = ((APathName)node.getPathName()).getName().getText();
            String variableValue = this.getDeclaredLetVariableValue(variableName);
            boolean isDeclaredAsLetVariable = variableValue != null;
            String featureExpression = TranslationUtils.deleteWhitespace((Object)node);
            if (isDeclaredAsLetVariable) {
                this.write(variableValue);
            } else if (node.getFeatureCallParameters() == null || OCLPatterns.isOperation((Object)featureExpression)) {
                APropertyCallExpression expression = (APropertyCallExpression)node.parent();
                String expressionAsString = ConcreteSyntaxUtils.getPrimaryExpression((APropertyCallExpression)expression);
                if (OCLFeatures.isSelf((Object)(expressionAsString = expressionAsString.replaceAll("self\\.", "")))) {
                    this.write(CONTEXT_ELEMENT_NAME);
                } else if (StringUtils.isNotBlank((String)expressionAsString)) {
                    AUnaryExpression unaryExpression;
                    boolean convertToBoolean = false;
                    if (node.parent().parent() instanceof AUnaryExpression && (convertToBoolean = (unaryExpression = (AUnaryExpression)node.parent().parent()).getUnaryOperator() instanceof ANotUnaryOperator)) {
                        this.write(BOOLEAN_WRAP_PREFIX);
                    }
                    if (OCLFeatures.isOclIsKindOf((Object)expressionAsString)) {
                        this.write("object");
                        this.handleOclIsKindOf(node.getFeatureCallParameters());
                    } else if (OCLFeatures.isOclIsTypeOf((Object)expressionAsString)) {
                        this.write("object");
                        this.handleOclIsTypeOf(node.getFeatureCallParameters());
                    } else {
                        boolean introspectorCall = true;
                        String invokedObject = CONTEXT_ELEMENT_NAME;
                        if (this.arrowPropertyCallStack.peek().equals(Boolean.TRUE)) {
                            invokedObject = "object";
                        }
                        if (this.isOperationArgument(expressionAsString)) {
                            invokedObject = this.getRootName(expressionAsString);
                            boolean bl = introspectorCall = !invokedObject.equals(expressionAsString = this.getPathTail(expressionAsString));
                        }
                        if (introspectorCall) {
                            this.write(OCL_INTROSPECTOR_INVOKE_PREFIX);
                        }
                        this.write(invokedObject);
                        if (introspectorCall) {
                            this.write(",\"");
                            this.write(expressionAsString);
                        }
                        if (introspectorCall) {
                            this.write("\")");
                        }
                        if (convertToBoolean) {
                            this.write(BOOLEAN_WRAP_SUFFIX);
                        }
                    }
                    if (this.requiresBooleanConversion) {
                        this.write(BOOLEAN_WRAP_SUFFIX);
                        this.requiresBooleanConversion = false;
                    }
                }
            } else {
                node.getPathName().apply((Switch)this);
            }
        }
        if (node.getIsMarkedPre() != null) {
            node.getIsMarkedPre().apply((Switch)this);
        }
        if (node.getQualifiers() != null && this.arrowPropertyCallStack.peek().equals(Boolean.FALSE)) {
            node.getQualifiers().apply((Switch)this);
        }
        this.outAFeaturePrimaryExpression(node);
    }

    public void handleArrowFeatureCall(AFeatureCall featureCall) {
        AFeatureCallParameters params = (AFeatureCallParameters)featureCall.getFeatureCallParameters();
        AActualParameterList list = null;
        if (params != null) {
            list = (AActualParameterList)params.getActualParameterList();
        }
        boolean arrow = this.arrowPropertyCallStack.peek().equals(Boolean.TRUE) && !String.valueOf(list).trim().equals("");
        this.newTranslationLayer();
        String navigationalPath = ConcreteSyntaxUtils.getArrowFeatureCallResultNavigationalPath((APropertyCallExpression)((APropertyCallExpression)featureCall.parent().parent()));
        boolean resultNavigationalPath = StringUtils.isNotBlank((String)navigationalPath);
        if (resultNavigationalPath) {
            this.write(OCL_INTROSPECTOR_INVOKE_PREFIX);
        }
        this.write(OCL_TRANSLATOR_PACKAGE);
        this.write(".OCLCollections.");
        this.inAFeatureCall(featureCall);
        if (featureCall.getPathName() != null) {
            featureCall.getPathName().apply((Switch)this);
        }
        String featureCallName = TranslationUtils.trimToEmpty((Object)featureCall.getPathName());
        AFeatureCallParameters parameters = (AFeatureCallParameters)featureCall.getFeatureCallParameters();
        if (parameters != null) {
            if (parameters.getLParen() != null) {
                parameters.getLParen().apply((Switch)this);
            }
            this.mergeTranslationLayerBefore();
            AActualParameterList parameterList = (AActualParameterList)parameters.getActualParameterList();
            if (parameterList != null) {
                LinkedList expressions = parameterList.getCommaExpression();
                if (parameterList.getExpression() != null) {
                    if (arrow) {
                        this.write(",");
                        this.write(features.getProperty(featureCallName));
                        this.write(" ");
                        if (OCLPredicateFeatures.isPredicateFeature(featureCallName)) {
                            this.write(BOOLEAN_WRAP_PREFIX);
                        }
                    }
                    parameterList.getExpression().apply((Switch)this);
                }
                for (int ctr = 0; ctr < expressions.size(); ++ctr) {
                    Node expression = (Node)expressions.get(ctr);
                    if (expression == null) continue;
                    this.write(",");
                    expression.apply((Switch)this);
                }
                if (parameterList.getExpression() != null) {
                    if (OCLPredicateFeatures.isPredicateFeature(featureCallName)) {
                        this.write(BOOLEAN_WRAP_SUFFIX);
                    }
                    if (arrow) {
                        this.write(";}}");
                    }
                }
            }
            if (parameters.getRParen() != null) {
                parameters.getRParen().apply((Switch)this);
            }
        }
        if (resultNavigationalPath) {
            this.write(",\"");
            this.write(navigationalPath);
            this.write("\"");
            this.write(")");
        }
        this.outAFeatureCall(featureCall);
    }

    public void caseALetExp(ALetExp node) {
        this.inALetExp(node);
        if (node.getLet() != null) {
            node.getLet().apply((Switch)this);
        }
        if (node.getLetVariableDeclaration() != null) {
            node.getLetVariableDeclaration().apply((Switch)this);
        }
        if (node.getLetExpSub() != null) {
            node.getLetExpSub().apply((Switch)this);
        }
        this.outALetExp(node);
    }

    public void inALetExp(ALetExp node) {
        this.newLetVariableContext();
    }

    public void outALetExp(ALetExp node) {
        this.dropLetVariableContext();
    }

    public void caseAVariableDeclarationLetExpSub(AVariableDeclarationLetExpSub node) {
        node.getComma().apply((Switch)this);
        node.getLetVariableDeclaration().apply((Switch)this);
        node.getLetExpSub().apply((Switch)this);
    }

    public void caseALogicalExp(ALogicalExp node) {
        this.newTranslationLayer();
        if (node.getRelationalExpression() != null) {
            node.getRelationalExpression().apply((Switch)this);
        }
        Object[] tails = node.getLogicalExpressionTail().toArray();
        for (int ctr = 0; ctr < tails.length; ++ctr) {
            ((ALogicalExpressionTail)tails[ctr]).apply((Switch)this);
        }
        this.mergeTranslationLayerAfter();
    }

    public void caseALogicalExpressionTail(ALogicalExpressionTail node) {
        node.getLogicalOperator().apply((Switch)this);
        if (node.getLogicalOperator() instanceof AImpliesLogicalOperator) {
            this.prependToTranslationLayer("(");
        }
        if (node.getRelationalExpression() != null) {
            node.getRelationalExpression().apply((Switch)this);
        }
        if (node.getLogicalOperator() instanceof AImpliesLogicalOperator) {
            this.write(":true)");
        }
    }

    public void caseARelationalExpressionTail(ARelationalExpressionTail node) {
        this.inARelationalExpressionTail(node);
        this.newTranslationLayer();
        this.write(OCL_TRANSLATOR_PACKAGE);
        this.write(".OCLExpressions.");
        node.getRelationalOperator().apply((Switch)this);
        this.write("(");
        this.mergeTranslationLayerBefore();
        if (node.getAdditiveExpression() != null) {
            this.write(",");
            node.getAdditiveExpression().apply((Switch)this);
        }
        this.write(")");
        this.outARelationalExpressionTail(node);
    }

    public void inARelationalExpression(ARelationalExpression node) {
        if (node.getRelationalExpressionTail() == null) {
            Node parent = node.parent();
            Object expression = null;
            if (parent instanceof ALogicalExp) {
                LinkedList tails = ((ALogicalExp)parent).getLogicalExpressionTail();
                if (tails != null && !tails.isEmpty() && OCLPatterns.isAndOrOrExpression((Object)(expression = tails.get(0)))) {
                    expression = node;
                }
            } else if (parent instanceof ALogicalExpressionTail) {
                expression = node;
            }
            boolean bl = this.requiresBooleanConversion = expression != null && OCLPatterns.isNavigationalPath((Object)expression) && !OCLPatterns.isOperation((Object)node);
            if (this.requiresBooleanConversion) {
                this.write(BOOLEAN_WRAP_PREFIX);
            }
        }
        this.newTranslationLayer();
    }

    public void outARelationalExpression(ARelationalExpression node) {
        this.mergeTranslationLayerAfter();
    }

    public void caseTName(TName node) {
        this.write(node.getText());
    }

    public void caseTAnd(TAnd tAnd) {
        this.write("&&");
    }

    public void caseTOr(TOr tOr) {
        this.write("||");
    }

    public void caseTXor(TXor tXor) {
        this.write("^");
    }

    public void caseTImplies(TImplies tImplies) {
        this.prependToTranslationLayer(BOOLEAN_WRAP_PREFIX);
        this.appendToTranslationLayer(BOOLEAN_WRAP_SUFFIX);
        this.write("?");
    }

    public void caseTNot(TNot tNot) {
        this.write("!");
    }

    public void caseTPlus(TPlus tPlus) {
        this.write("+");
    }

    public void caseTMinus(TMinus tMinus) {
        this.write("-");
    }

    public void caseTMult(TMult tMult) {
        this.write("*");
    }

    public void caseTDiv(TDiv tDiv) {
        this.write("/");
    }

    public void caseTEqual(TEqual tEqual) {
        this.write("equal");
    }

    public void caseTNotEqual(TNotEqual tNotEqual) {
        this.write("notEqual");
    }

    public void caseTLt(TLt tLt) {
        this.write("less");
    }

    public void caseTLteq(TLteq tLteq) {
        this.write("lessOrEqual");
    }

    public void caseTGt(TGt tGt) {
        this.write("greater");
    }

    public void caseTGteq(TGteq tGteq) {
        this.write("greaterOrEqual");
    }

    public void caseTInv(TInv tInv) {
    }

    public void caseTDef(TDef tDef) {
    }

    public void caseTLet(TLet tLet) {
    }

    public void caseTColon(TColon tColon) {
    }

    public void caseTLBrace(TLBrace tlBrace) {
        this.write("{");
    }

    public void caseTLBracket(TLBracket tlBracket) {
        this.write("[");
    }

    public void caseTLParen(TLParen tlParen) {
        this.write("(");
    }

    public void caseTRBrace(TRBrace trBrace) {
        this.write("}");
    }

    public void caseTRBracket(TRBracket trBracket) {
        this.write("]");
    }

    public void caseTRParen(TRParen trParen) {
        this.write(")");
    }

    public void caseTContext(TContext tContext) {
    }

    public void caseTBoolean(TBoolean tBoolean) {
        this.write(tBoolean.getText());
    }

    public void caseTApostrophe(TApostrophe tApostrophe) {
        this.write("'");
    }

    public void caseTBlank(TBlank tBlank) {
        this.write(" ");
    }

    public void caseTCollection(TCollection tCollection) {
        this.write("java.util.Collection ");
    }

    public void caseTComment(TSingleLineComment tSingleLineComment) {
        this.write("// ");
    }

    public void caseTEndif(TEndif tEndif) {
    }

    public void caseTAttr(TAttr tAttr) {
    }

    public void caseTBag(TBag tBag) {
    }

    public void caseTBar(TBar tBar) {
    }

    public void caseTBody(TBody tBody) {
    }

    public void caseTCommercialAt(TCommercialAt tCommercialAt) {
    }

    public void caseTDerive(TDerive tDerive) {
    }

    public void caseTEndpackage(TEndpackage tEndpackage) {
    }

    public void caseTEnum(TEnum tEnum) {
    }

    public void caseTIn(TIn tIn) {
    }

    public void caseTInit(TInit tInit) {
    }

    public void caseTInt(TInt tInt) {
        this.write(tInt.getText());
    }

    public void caseTIsSentOperator(TIsSentOperator tIsSentOperator) {
    }

    public void caseTMessageOperator(TMessageOperator tMessageOperator) {
    }

    public void caseTNewLine(TNewLine tNewLine) {
    }

    public void caseTOper(TOper tOper) {
    }

    public void caseTOrderedset(TOrderedset tOrderedset) {
    }

    public void caseTPackage(TPackage tPackage) {
    }

    public void caseTPost(TPost tPost) {
    }

    public void caseTPre(TPre tPre) {
    }

    public void caseTArrow(TArrow tArrow) {
    }

    public void caseTIf(TIf tIf) {
        this.write("if");
    }

    public void caseTElse(TElse tElse) {
        this.write("else");
    }

    public void caseTThen(TThen tThen) {
    }

    public void caseTRange(TRange tRange) {
    }

    public void caseTReal(TReal tReal) {
        this.write(tReal.getText());
    }

    public void caseTComma(TComma tComma) {
        this.write(", ");
    }

    public void caseTDot(TDot tDot) {
        this.write(".");
    }

    public void caseTSemicolon(TSemicolon tSemicolon) {
    }

    public void caseTUnknown(TUnknown tUnknown) {
    }

    public void caseTScopeOperator(TScopeOperator tScopeOperator) {
        this.write(".");
    }

    public void caseTSequence(TSequence tSequence) {
    }

    public void caseTSet(TSet tSet) {
    }

    public void caseTStringLit(TStringLit tStringLit) {
        StringBuffer buffer = new StringBuffer(tStringLit.getText().replace('\'', '\"'));
        this.write(buffer);
    }

    public void caseTTab(TTab tTab) {
    }

    public void caseTTuple(TTuple tTuple) {
    }

    public void caseTTupletype(TTupletype tTupletype) {
    }

    private void write(Object object) {
        this.appendToTranslationLayer(String.valueOf(object));
    }

    private StringBuffer newTranslationLayer() {
        return this.translationLayers.push(new StringBuffer());
    }

    private StringBuffer appendToTranslationLayer(Object appendix) {
        return ((StringBuffer)this.translationLayers.peek()).append(appendix);
    }

    private StringBuffer prependToTranslationLayer(Object appendix) {
        return ((StringBuffer)this.translationLayers.peek()).insert(0, appendix);
    }

    private StringBuffer mergeTranslationLayerAfter() {
        StringBuffer newTop = null;
        if (this.translationLayers.size() > 1) {
            newTop = this.appendToTranslationLayer(this.translationLayers.pop());
        }
        return newTop;
    }

    private StringBuffer mergeTranslationLayerBefore() {
        StringBuffer newTop = null;
        if (this.translationLayers.size() > 1) {
            newTop = this.prependToTranslationLayer(this.translationLayers.pop());
        }
        return newTop;
    }

    private StringBuffer mergeTranslationLayers() {
        while (this.mergeTranslationLayerAfter() != null) {
        }
        return (StringBuffer)this.translationLayers.peek();
    }

    private String getDeclaredLetVariableValue(String variableName) {
        Iterator iterator = ((AbstractList)this.letVariableStack).iterator();
        while (iterator.hasNext()) {
            Map variableMap = (Map)iterator.next();
            if (!variableMap.containsKey(variableName)) continue;
            return (String)variableMap.get(variableName);
        }
        return null;
    }

    private void newLetVariableContext() {
        this.letVariableStack.push(new HashMap(4));
    }

    private void dropLetVariableContext() {
        if (!this.letVariableStack.isEmpty()) {
            this.letVariableStack.pop();
        }
    }

    private void addLetVariableToContext(String variableName, String variableValue) {
        ((Map)this.letVariableStack.peek()).put(variableName, variableValue);
    }

    private ModelElementFacade getModelElement() {
        return (ModelElementFacade)this.getContextElement();
    }

    public ValidationJavaTranslator() {
        this.arrowPropertyCallStack.push(Boolean.FALSE);
    }

    public void postProcess() {
        this.getExpression().insertInTranslatedExpression(0, (Object)"org.andromda.translation.ocl.validation.OCLResultEnsurer.ensure(");
        this.getExpression().insertInTranslatedExpression(0, (Object)"boolean constraintValid = ");
        this.getExpression().insertInTranslatedExpression(0, (Object)"final java.lang.Object contextElement = this; ");
        this.getExpression().appendToTranslatedExpression((Object)");");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            URL featuresUri = (class$org$andromda$translation$ocl$validation$ValidationJavaTranslator == null ? (class$org$andromda$translation$ocl$validation$ValidationJavaTranslator = ValidationJavaTranslator.class$("org.andromda.translation.ocl.validation.ValidationJavaTranslator")) : class$org$andromda$translation$ocl$validation$ValidationJavaTranslator).getResource("features.properties");
            if (featuresUri == null) {
                throw new ModelProcessorException("Could not load file --> '" + featuresUri + "'");
            }
            features = new Properties();
            InputStream stream = featuresUri.openStream();
            features.load(stream);
            stream.close();
            Object var1_2 = null;
        }
        catch (Throwable throwable) {
            throw new ValidationTranslatorException(throwable);
        }
    }
}

