/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.Serializable;

public class ColumnIdentifier<R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final String headerI18nKey;
    private final String headerTipI18nKey;

    public static <R> ColumnIdentifier<R> newId(String propertyName, String headerI18nKey, String headerTipI18nKey) {
        return new ColumnIdentifier<R>(propertyName, headerI18nKey, headerTipI18nKey);
    }

    public static <R> ColumnIdentifier<R> newReadOnlyId(String propertyName, String headerI18nKey, String headerTipI18nKey) {
        return new ColumnIdentifier<R>(propertyName, headerI18nKey, headerTipI18nKey){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(R entry, Object value) {
            }
        };
    }

    protected ColumnIdentifier(String propertyName, String headerI18nKey, String headerTipI18nKey) {
        this.propertyName = propertyName;
        this.headerI18nKey = headerI18nKey;
        this.headerTipI18nKey = headerTipI18nKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getHeaderI18nKey() {
        return this.headerI18nKey;
    }

    public String getHeaderTipI18nKey() {
        return this.headerTipI18nKey;
    }

    public Object getValue(R entry) {
        Object result = null;
        if (this.propertyName != null && entry != null) {
            result = TuttiUIUtil.getProperty(entry, this.propertyName);
        }
        return result;
    }

    public void setValue(R entry, Object value) {
        if (this.propertyName != null) {
            TuttiUIUtil.setProperty(entry, this.propertyName, value);
        }
    }
}

