/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import java.util.Collection;
import java.util.Map;
import javax.swing.JTextArea;
import org.nuiton.i18n.I18n;

public class ImportMultiPostAction
extends AbstractImportMultiPostAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    protected Map<String, Object> notImportedData;

    public ImportMultiPostAction(BenthosBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiBenthos";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n._((String)"tutti.common.file.tuttiBenthos", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n._((String)"tutti.editBenthosBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n._((String)"tutti.editBenthosBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    protected void releaseAction() {
        this.notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        this.notImportedData = this.multiPostImportExportService.importBenthos(this.file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        if (!this.notImportedData.isEmpty()) {
            Float livingNotItemizedWeight;
            Float inertWeight;
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog(this.getContext().getActionUI());
            Collection notImportedBenthosBatches = (Collection)this.notImportedData.get("batchesKey");
            StringBuffer stringBuffer = new StringBuffer();
            Float totalSortedWeight = (Float)this.notImportedData.get("benthosTotalSortedWeight");
            if (totalSortedWeight != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.totalSortedWeight", (Object[])new Object[]{totalSortedWeight}) + "\n");
            }
            if ((inertWeight = (Float)this.notImportedData.get("benthosTotalInertWeight")) != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.inertWeight", (Object[])new Object[]{inertWeight}) + "\n");
            }
            if ((livingNotItemizedWeight = (Float)this.notImportedData.get("benthosTotalLivingNotItemizedWeight")) != null) {
                stringBuffer.append("- " + I18n._((String)"tutti.multiPostImportLog.livingNotItemizedWeight", (Object[])new Object[]{livingNotItemizedWeight}) + "\n");
            }
            for (BenthosBatch sb : notImportedBenthosBatches) {
                stringBuffer.append("- " + this.decorate(sb.getSpecies()) + " / " + this.decorate(sb.getSampleCategoryValue()) + "\n");
            }
            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(this.getContext().getMainUI());
                dialog.setVisible(true);
            }
        }
        this.sendMessage(I18n._((String)"tutti.editBenthosBatch.action.importMultiPost.success", (Object[])new Object[]{this.file}));
    }
}

