/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 2496830135246700300L;
    protected static final Logger LOG = LoggerFactory.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    public static final String DEFAULT_REQUESTONLY_PARAMETER = "request_only_locale";
    protected String parameterName = "request_locale";
    protected String requestOnlyParameterName = "request_only_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";

    public I18nInterceptor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new I18nInterceptor()", new String[0]);
        }
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setRequestOnlyParameterName(String requestOnlyParameterName) {
        this.requestOnlyParameterName = requestOnlyParameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept '#0/#1' {", invocation.getProxy().getNamespace(), invocation.getProxy().getActionName());
        }
        Map<String, Object> params = invocation.getInvocationContext().getParameters();
        boolean storeInSession = true;
        Object requestedLocale = this.findLocaleParameter(params, this.parameterName);
        if (requestedLocale == null && (requestedLocale = this.findLocaleParameter(params, this.requestOnlyParameterName)) != null) {
            storeInSession = false;
        }
        Locale locale = this.getLocaleFromParam(requestedLocale);
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        if (session != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                if (locale == null) {
                    storeInSession = false;
                    locale = this.readStoredLocale(invocation, session);
                }
                if (storeInSession) {
                    session.put(this.attributeName, locale);
                }
            }
        }
        this.saveLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale=#0", invocation.getStack().findValue("locale"));
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale=#0", invocation.getStack().findValue("locale"));
            LOG.debug("intercept } ", new String[0]);
        }
        return result;
    }

    protected Locale readStoredLocale(ActionInvocation invocation, Map<String, Object> session) {
        Object sessionLocale = session.get(this.attributeName);
        if (sessionLocale != null && sessionLocale instanceof Locale) {
            Locale locale = (Locale)sessionLocale;
            if (LOG.isDebugEnabled()) {
                LOG.debug("applied session locale=#0", locale);
            }
            return locale;
        }
        Locale locale = invocation.getInvocationContext().getLocale();
        if (locale != null && LOG.isDebugEnabled()) {
            LOG.debug("applied invocation context locale=#0", locale);
        }
        return locale;
    }

    protected Locale getLocaleFromParam(Object requestedLocale) {
        Locale locale = null;
        if (requestedLocale != null) {
            Locale locale2 = locale = requestedLocale instanceof Locale ? (Locale)requestedLocale : LocalizedTextUtil.localeFromString(requestedLocale.toString(), null);
            if (locale != null && LOG.isDebugEnabled()) {
                LOG.debug("applied request locale=#0", locale);
            }
        }
        return locale;
    }

    private Object findLocaleParameter(Map<String, Object> params, String parameterName) {
        Object requestedLocale = params.remove(parameterName);
        if (requestedLocale != null && requestedLocale.getClass().isArray() && ((Object[])requestedLocale).length == 1) {
            requestedLocale = ((Object[])requestedLocale)[0];
            if (LOG.isDebugEnabled()) {
                LOG.debug("requested_locale=#0", requestedLocale);
            }
        }
        return requestedLocale;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }
}

