/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils.inflector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrenchInflector {
    private static final List plurals = new ArrayList();
    private static final List uncountables = new ArrayList();

    private static void uncountable(String pattern) {
        uncountables.add(Pattern.compile(pattern));
    }

    private static void ailIrregulars(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            FrenchInflector.plural("(\\S*)" + string + "ail$", "$1" + string + "aux");
        }
    }

    private static void takeAnS(String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            String string = patterns[i];
            FrenchInflector.plural(FrenchInflector.endsWith(string), "$1" + string + "s");
        }
    }

    private static void takeAnX(String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            String string = patterns[i];
            FrenchInflector.plural(FrenchInflector.endsWith(string), "$1" + string + "x");
        }
    }

    private static void plural(String pattern, String replace) {
        plurals.add(new Inflection(pattern, replace));
    }

    private static String endsWith(String end) {
        return "(\\S*)" + end + "$";
    }

    public static String pluralize(String str) {
        Iterator i = uncountables.iterator();
        while (i.hasNext()) {
            Pattern pattern = (Pattern)i.next();
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            return str;
        }
        List rules = FrenchInflector.getPluralRules();
        Iterator i2 = rules.iterator();
        while (i2.hasNext()) {
            Inflection inflection = (Inflection)i2.next();
            Pattern pattern = inflection.getPattern();
            String replace = inflection.getReplace();
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            return matcher.replaceFirst(replace);
        }
        return str.replaceFirst("([\\w]+)([^s])$", "$1$2s");
    }

    private static List getPluralRules() {
        return plurals;
    }

    static {
        FrenchInflector.uncountable(FrenchInflector.endsWith("(s|x|z)"));
        FrenchInflector.takeAnS(new String[]{"bal", "carnaval", "c?r?monial", "chacal", "choral", "festival", "nopal", "pal", "r?cital", "r?gal", "santal"});
        FrenchInflector.plural(FrenchInflector.endsWith("(al)"), "$1aux");
        FrenchInflector.takeAnS(new String[]{"landau", "sarrau", "bleu", "?meu", "emposieu", "enfeu", "feu", "lieu", "pneu", "richelieu", "schleu"});
        FrenchInflector.plural(FrenchInflector.endsWith("(au|eu|eau)"), "$1$2x");
        FrenchInflector.takeAnX(new String[]{"bijou", "caillou", "chou", "genou", "hibou", "joujou", "pou"});
        FrenchInflector.ailIrregulars(new String[]{"b", "cor", "?m", "soupir", "trav", "vant", "vitr"});
        FrenchInflector.plural(FrenchInflector.endsWith("a?eul"), "$1a?eux");
        FrenchInflector.plural(FrenchInflector.endsWith("ciel"), "$1cieux");
        FrenchInflector.plural(FrenchInflector.endsWith("oeil"), "$1yeux");
    }

    static class Inflection {
        private final Pattern pattern;
        private final String replace;

        public Inflection(Pattern pattern, String replace) {
            this.pattern = pattern;
            this.replace = replace;
        }

        public Inflection(String regexp, String replace) {
            this.pattern = Pattern.compile(regexp);
            this.replace = replace;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getReplace() {
            return this.replace;
        }
    }
}

