package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: RenameSpeciesBatchAction.java 666 2013-03-23 18:20:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/RenameSpeciesBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.jdesktop.swingx.JXTable;

import java.util.Collection;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To rename the species for a species batch and all his children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RenameSpeciesBatchAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);

    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();

        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = tableModel.getEntry(table.getSelectedRow());

        SpeciesBatchUIModel model = handler.getModel();
        List<Species> speciesList = Lists.newArrayList(
                getDataContext().getReferentSpeciesWithSurveyCode());
        speciesList.removeAll(
                model.getSpeciesUsed().get(
                        row.getSortedUnsortedCategoryValue()));

        selectedSpecies = getHandler().openAddSpeciesDialog(
                _("tutti.selectSpecies.title"),
                speciesList
        );

        result &= selectedSpecies != null;
        return result;
    }

    @Override
    protected void releaseAction() {
        selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {

        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = tableModel.getEntry(table.getSelectedRow());

        PersistenceService persistenceService = getContext().getPersistenceService();
        persistenceService.changeSpeciesBatchSpecies(row.getId(), selectedSpecies);

        Collection<Species> speciesUsed = getModel().getSpeciesUsed()
                .get(row.getSortedUnsortedCategoryValue());
        speciesUsed.remove(row.getSpecies());
        changeChildrenSpecies(row, selectedSpecies);
        speciesUsed.add(selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row,
                                         Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                changeChildrenSpecies(child, species);
            }
        }
    }
}
