/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchRowModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ZipUtil;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;

public class TuttiMultiPostImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiMultiPostImportExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected char csvSeparator;
    protected List<SampleCategoryEnum> samplingOrder;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
        Map idMapping = SampleCategoryEnum.toIdMapping();
        this.samplingOrder = Lists.newArrayList();
        this.samplingOrder.add(SampleCategoryEnum.sortedUnsorted);
        for (Integer categoryId : context.getConfig().getSamplingOrderIds()) {
            SampleCategoryEnum categoryEnum = (SampleCategoryEnum)idMapping.get(categoryId);
            if (SampleCategoryEnum.sortedUnsorted == categoryEnum) continue;
            this.samplingOrder.add(categoryEnum);
        }
    }

    public void exportSpecies(File file, FishingOperation operation) {
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator);
        CatchFrequencyRowModel csvFrequencyModel = new CatchFrequencyRowModel(this.csvSeparator);
        BatchContainer<SpeciesBatch> speciesBatchContainer = this.persistenceService.getRootSpeciesBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList frequencyRows = Lists.newArrayList();
        for (SpeciesBatch batch : speciesBatchContainer.getChildren()) {
            this.createSpeciesRow(batch, rows, frequencyRows);
        }
        BufferedWriter writer = null;
        File directory = Files.createTempDir();
        File speciesFile = new File(directory, "species.csv");
        try {
            writer = Files.newWriter((File)speciesFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        File frequencyFile = new File(directory, "frequencies.csv");
        try {
            writer = Files.newWriter((File)frequencyFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvFrequencyModel, (Iterable)frequencyRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[]{frequencyFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        try {
            ZipUtil.compressFiles((File)file, (File)directory, (Collection)Lists.newArrayList((Object[])new File[]{speciesFile, frequencyFile}));
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected void createSpeciesRow(SpeciesBatch batch, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows) {
        CatchRow row = new CatchRow();
        String id = UUID.randomUUID().toString();
        row.setId(id);
        row.setSpecies(batch.getSpecies());
        switch (batch.getSampleCategoryType()) {
            case sortedUnsorted: {
                row.setSortedUnsortedSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case sex: {
                row.setSexSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case size: {
                row.setSizeSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case maturity: {
                row.setMaturitySampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case age: {
                row.setAgeSampleCategory(batch.getSampleCategoryValue());
            }
        }
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(id);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRows.add(frequencyRow);
        }
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.createSpeciesRow(child, rows, frequencyRows);
        }
    }

    public void exportBenthos(File file, FishingOperation operation) {
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator);
        CatchFrequencyRowModel csvFrequencyModel = new CatchFrequencyRowModel(this.csvSeparator);
        BatchContainer<BenthosBatch> benthosBatchContainer = this.persistenceService.getRootBenthosBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList frequencyRows = Lists.newArrayList();
        for (BenthosBatch batch : benthosBatchContainer.getChildren()) {
            this.createBenthosRow(batch, rows, frequencyRows);
        }
        BufferedWriter writer = null;
        File directory = Files.createTempDir();
        File benthosFile = new File(directory, "benthos.csv");
        try {
            writer = Files.newWriter((File)benthosFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        File frequencyFile = new File(directory, "frequencies.csv");
        try {
            writer = Files.newWriter((File)frequencyFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvFrequencyModel, (Iterable)frequencyRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[]{frequencyFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        this.compressZipFile(file, directory);
    }

    protected void createBenthosRow(BenthosBatch batch, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows) {
        CatchRow row = new CatchRow();
        String id = UUID.randomUUID().toString();
        row.setId(id);
        row.setSpecies(batch.getSpecies());
        switch (batch.getSampleCategoryType()) {
            case sortedUnsorted: {
                row.setSortedUnsortedSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case sex: {
                row.setSexSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case size: {
                row.setSizeSampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case maturity: {
                row.setMaturitySampleCategory(batch.getSampleCategoryValue());
                break;
            }
            case age: {
                row.setAgeSampleCategory(batch.getSampleCategoryValue());
            }
        }
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(id);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRows.add(frequencyRow);
        }
        for (BenthosBatch child : batch.getChildBatchs()) {
            this.createBenthosRow(child, rows, frequencyRows);
        }
    }
}

