package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR = "busyBlockLayerUI.blockingColor";
    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_MANAGE_DB_ENABLED = "menuActionManageDb.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_FR_ENABLED = "menuChangeLocaleFR.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_UK_ENABLED = "menuChangeLocaleUK.enabled";
    public static final String BINDING_MENU_FILE_CONFIGURATION_ENABLED = "menuFileConfiguration.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected TuttiHelpBroker broker;
    protected BlockingLayerUI busyBlockLayerUI;
    protected MainUIHandler handler;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionManageDb;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionUpdate;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuChangeLocale;
    protected JMenuItem menuChangeLocaleFR;
    protected JMenuItem menuChangeLocaleUK;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected JMenuItem menuShowHelp;
    protected TuttiUIContext model;
    protected JButton showHelp;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        setContextValue(context);
                MainUIHandler handler = new MainUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite();
    }

    public void doActionPerformed__on__menuShowHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        menuFileExit.getAction().actionPerformed(null);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionManageDb() {
        return menuActionManageDb;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionUpdate() {
        return menuActionUpdate;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuChangeLocale() {
        return menuChangeLocale;
    }

    public JMenuItem getMenuChangeLocaleFR() {
        return menuChangeLocaleFR;
    }

    public JMenuItem getMenuChangeLocaleUK() {
        return menuChangeLocaleUK;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public JMenuItem getMenuShowHelp() {
        return menuShowHelp;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(showHelp);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
    }

    protected void addChildrenToMenuChangeLocale() {
        if (!allComponentsCreated) {
            return;
        }
        menuChangeLocale.add(menuChangeLocaleUK);
        menuChangeLocale.add(menuChangeLocaleFR);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuActionUpdate);
        menuFile.add($JSeparator0);
        menuFile.add(menuActionManageDb);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuShowHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuChangeLocale);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
        body.putClientProperty("help", "tutti.main.help");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.main.help"));
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MainUIHandler.class));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.setText(_("tutti.main.action.editCatches"));
        menuActionEditCatches.setToolTipText(_("tutti.main.action.editCatches.tip"));
        menuActionEditCatches.putClientProperty("help", "tutti.main.menu.action.editCatches.help");
        menuActionEditCatches.putClientProperty("tuttiAction", EditSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.setText(_("tutti.main.action.editSelectedCruise"));
        menuActionEditCruise.setToolTipText(_("tutti.main.action.editSelectedCruise.tip"));
        menuActionEditCruise.putClientProperty("help", "tutti.main.menu.action.editCruise.help");
        menuActionEditCruise.putClientProperty("tuttiAction", EditSelectedCruiseAction.class);
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.setText(_("tutti.main.action.editSelectedProgram"));
        menuActionEditProgram.setToolTipText(_("tutti.main.action.editProgram.tip"));
        menuActionEditProgram.putClientProperty("help", "tutti.main.menu.action.editProgram.help");
        menuActionEditProgram.putClientProperty("tuttiAction", EditSelectedProgramAction.class);
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.setText(_("tutti.main.action.editSelectedProtocol"));
        menuActionEditProtocol.setToolTipText(_("tutti.main.action.editSelectedProtocol.tip"));
        menuActionEditProtocol.putClientProperty("help", "tutti.main.menu.action.editProtocol.help");
        menuActionEditProtocol.putClientProperty("tuttiAction", EditSelectedProtocolAction.class);
    }

    protected void createMenuActionManageDb() {
        $objectMap.put("menuActionManageDb", menuActionManageDb = new JMenuItem());
        
        menuActionManageDb.setName("menuActionManageDb");
        menuActionManageDb.setText(_("tutti.main.action.manageDb"));
        menuActionManageDb.setToolTipText(_("tutti.main.action.manageDb.tip"));
        menuActionManageDb.putClientProperty("help", "tutti.main.menu.action.manageDb.help");
        menuActionManageDb.putClientProperty("tuttiAction", ManageDbAction.class);
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.setText(_("tutti.main.action.selectCruise"));
        menuActionSelectCruise.setToolTipText(_("tutti.main.action.selectCruise.tip"));
        menuActionSelectCruise.putClientProperty("help", "tutti.main.menu.action.selectCruise.help");
        menuActionSelectCruise.putClientProperty("tuttiAction", SelectCruiseAction.class);
    }

    protected void createMenuActionUpdate() {
        $objectMap.put("menuActionUpdate", menuActionUpdate = new JMenuItem());
        
        menuActionUpdate.setName("menuActionUpdate");
        menuActionUpdate.setText(_("tutti.main.action.updateApplication"));
        menuActionUpdate.setToolTipText(_("tutti.main.action.updateApplication.tip"));
        menuActionUpdate.putClientProperty("help", "tutti.main.menu.action.updateApplication.help");
        menuActionUpdate.putClientProperty("tuttiAction", UpdateApplicationAction.class);
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(_("tutti.main.action.validateCatches"));
        menuActionValidateCatches.setToolTipText(_("tutti.main.action.validateCatches.tip"));
        menuActionValidateCatches.putClientProperty("help", "tutti.main.menu.action.validateCatches.help");
        menuActionValidateCatches.putClientProperty("tuttiAction", ValidateSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.main.menu.actions"));
        menuActions.setToolTipText(_("tutti.main.menu.actions.tip"));
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(_("tutti.main.menu.administration"));
        menuAdministration.setToolTipText(_("tutti.main.menu.administration.tip"));
    }

    protected void createMenuChangeLocale() {
        $objectMap.put("menuChangeLocale", menuChangeLocale = new JMenu());
        
        menuChangeLocale.setName("menuChangeLocale");
        menuChangeLocale.setText(_("tutti.main.menu.changeLocale"));
        menuChangeLocale.setToolTipText(_("tutti.main.action.changeLocale.tip"));
        menuChangeLocale.putClientProperty("help", "tutti.main.menu.action.changeLocale.help");
    }

    protected void createMenuChangeLocaleFR() {
        $objectMap.put("menuChangeLocaleFR", menuChangeLocaleFR = new JMenuItem());
        
        menuChangeLocaleFR.setName("menuChangeLocaleFR");
        menuChangeLocaleFR.setText(_("tutti.main.action.changeLocaleFR"));
        menuChangeLocaleFR.setToolTipText(_("tutti.main.action.changeLocaleFR.tip"));
        menuChangeLocaleFR.putClientProperty("help", "tutti.main.menu.action.changeLocaleFR.help");
        menuChangeLocaleFR.putClientProperty("tuttiAction", ChangeToLocaleFRAction.class);
    }

    protected void createMenuChangeLocaleUK() {
        $objectMap.put("menuChangeLocaleUK", menuChangeLocaleUK = new JMenuItem());
        
        menuChangeLocaleUK.setName("menuChangeLocaleUK");
        menuChangeLocaleUK.setText(_("tutti.main.action.changeLocaleUK"));
        menuChangeLocaleUK.setToolTipText(_("tutti.main.action.changeLocaleUK.tip"));
        menuChangeLocaleUK.putClientProperty("help", "tutti.main.menu.action.changeLocaleUK.help");
        menuChangeLocaleUK.putClientProperty("tuttiAction", ChangeToLocaleUKAction.class);
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.main.menu.file"));
        menuFile.setToolTipText(_("tutti.main.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.main.action.configuration"));
        menuFileConfiguration.setToolTipText(_("tutti.main.action.configuration.tip"));
        menuFileConfiguration.putClientProperty("help", "tutti.main.menu.action.configuration.help");
        menuFileConfiguration.putClientProperty("tuttiAction", ShowConfigAction.class);
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.main.action.exit"));
        menuFileExit.setToolTipText(_("tutti.main.action.exit.tip"));
        menuFileExit.putClientProperty("help", "tutti.main.menu.action.exit.help");
        menuFileExit.putClientProperty("tuttiAction", CloseApplicationAction.class);
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.main.menu.help"));
        menuHelp.setToolTipText(_("tutti.main.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.main.action.about"));
        menuHelpAbout.setToolTipText(_("tutti.main.action.about.tip"));
        menuHelpAbout.putClientProperty("help", "tutti.main.menu.action.about.help");
        menuHelpAbout.putClientProperty("tuttiAction", ShowAboutAction.class);
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.main.action.site"));
        menuHelpSite.setToolTipText(_("tutti.main.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "tutti.main.menu.action.site.help");
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.setText(_("tutti.main.action.importTemporaryReferential"));
        menuImportTemporaryReferential.setToolTipText(_("tutti.main.action.importTemporaryReferential.tip"));
        menuImportTemporaryReferential.putClientProperty("help", "tutti.main.menu.action.importTemporaryReferential.help");
        menuImportTemporaryReferential.putClientProperty("tuttiAction", ImportTemporaryReferentialAction.class);
    }

    protected void createMenuShowHelp() {
        $objectMap.put("menuShowHelp", menuShowHelp = new JMenuItem());
        
        menuShowHelp.setName("menuShowHelp");
        menuShowHelp.setText(_("tutti.main.action.showHelp"));
        menuShowHelp.setToolTipText(_("tutti.main.action.showHelp.tip"));
        menuShowHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowHelp"));
        menuShowHelp.putClientProperty("help", "tutti.index.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setToolTipText(_("tutti.main.action.showHelp.tip"));
        showHelp.putClientProperty("help", "tutti.main.menu.action.showHelp.help");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToMenuChangeLocale();
        addChildrenToBottomBar();
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 41 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.configuration.mnemonic"),'Z'));
        menuActionUpdate.setIcon(SwingUtil.createActionIcon("update-application"));
        menuActionUpdate.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.updateApplication.mnemonic"),'Z'));
        menuActionManageDb.setIcon(SwingUtil.createActionIcon("manage-db"));
        menuActionManageDb.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.manageDb.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.exit.mnemonic"),'Z'));
        menuActions.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.actions.mnemonic"),'Z'));
        menuActionSelectCruise.setIcon(SwingUtil.createActionIcon("home"));
        menuActionSelectCruise.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.selectCruise.mnemonic"),'Z'));
        menuActionEditProgram.setIcon(SwingUtil.createActionIcon("program"));
        menuActionEditProgram.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedProgram.mnemonic"),'Z'));
        menuActionEditCruise.setIcon(SwingUtil.createActionIcon("cruise"));
        menuActionEditCruise.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedCruise.mnemonic"),'Z'));
        menuActionEditProtocol.setIcon(SwingUtil.createActionIcon("protocol"));
        menuActionEditProtocol.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedProtocol.mnemonic"),'Z'));
        menuActionEditCatches.setIcon(SwingUtil.createActionIcon("edit"));
        menuActionEditCatches.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editCatches.mnemonic"),'Z'));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuActionValidateCatches.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.validateCatches.mnemonic"),'Z'));
        menuAdministration.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.administration.mnemonic"),'Z'));
        menuImportTemporaryReferential.setIcon(SwingUtil.createActionIcon("temporary-referential-import"));
        menuImportTemporaryReferential.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.importTemporaryReferential.mnemonic"),'Z'));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.help.mnemonic"),'Z'));
        menuShowHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuShowHelp.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.showHelp.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.site.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.about.mnemonic"),'Z'));
        menuChangeLocale.setIcon(SwingUtil.createActionIcon("translate"));
        menuChangeLocale.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocale.mnemonic"),'Z'));
        menuChangeLocaleUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuChangeLocaleUK.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocaleUK.mnemonic"),'Z'));
        menuChangeLocaleFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuChangeLocaleFR.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocaleFR.mnemonic"),'Z'));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, menuFileConfiguration, "tutti.main.menu.action.configuration.help");
        registerHelpId(_broker, menuActionUpdate, "tutti.main.menu.action.updateApplication.help");
        registerHelpId(_broker, menuActionManageDb, "tutti.main.menu.action.manageDb.help");
        registerHelpId(_broker, menuFileExit, "tutti.main.menu.action.exit.help");
        registerHelpId(_broker, menuActionSelectCruise, "tutti.main.menu.action.selectCruise.help");
        registerHelpId(_broker, menuActionEditProgram, "tutti.main.menu.action.editProgram.help");
        registerHelpId(_broker, menuActionEditCruise, "tutti.main.menu.action.editCruise.help");
        registerHelpId(_broker, menuActionEditProtocol, "tutti.main.menu.action.editProtocol.help");
        registerHelpId(_broker, menuActionEditCatches, "tutti.main.menu.action.editCatches.help");
        registerHelpId(_broker, menuActionValidateCatches, "tutti.main.menu.action.validateCatches.help");
        registerHelpId(_broker, menuImportTemporaryReferential, "tutti.main.menu.action.importTemporaryReferential.help");
        registerHelpId(_broker, menuShowHelp, "tutti.index.help");
        registerHelpId(_broker, menuHelpSite, "tutti.main.menu.action.site.help");
        registerHelpId(_broker, menuHelpAbout, "tutti.main.menu.action.about.help");
        registerHelpId(_broker, menuChangeLocale, "tutti.main.menu.action.changeLocale.help");
        registerHelpId(_broker, menuChangeLocaleUK, "tutti.main.menu.action.changeLocaleUK.help");
        registerHelpId(_broker, menuChangeLocaleFR, "tutti.main.menu.action.changeLocaleFR.help");
        registerHelpId(_broker, showHelp, "tutti.main.menu.action.showHelp.help");
        registerHelpId(_broker, body, "tutti.main.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createHandler();
        createBroker();
        createBusyBlockLayerUI();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuActionUpdate();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuActionManageDb();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuHelp();
        createMenuShowHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuChangeLocale();
        createMenuChangeLocaleUK();
        createMenuChangeLocaleFR();
        createBottomBar();
        createValidatorMessageWidget();
        createShowHelp();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.main.title.applicationName"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    busyBlockLayerUI.setBlockingColor(model.getConfig().getColorBlockingLayer());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("busy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    busyBlockLayerUI.setBlock(model.isBusy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("busy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONFIGURATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConfiguration.setEnabled(model.getScreen() != TuttiScreen.CONFIG);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled(model.getScreen() != TuttiScreen.VALIDATE_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleUK.setEnabled(!handler.acceptLocale(model.getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleFR.setEnabled(!handler.acceptLocale(model.getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}