/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.TuttiExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportCruiseAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportCruiseAction.class);
    protected File file;

    public ExportCruiseAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
            this.file = TuttiUIUtil.saveFile("exportCruise-" + cruise.getName() + ".zip", this.getContext().getMainUI(), I18n._((String)"tutti.selectCruise.title.choose.exportCruiseFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.chooseCruiseExportFile", (Object[])new Object[0]), "^.+\\.zip$", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            boolean bl = doAction = this.file != null;
            if (doAction) {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".zip");
                doAction = ((SelectCruiseUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save cruise " + cruise.getId() + " to file: " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(6);
        TuttiExportService service = this.getContext().getTuttiExportService();
        service.exportCruise(cruise.getId(), this.file, progressionModel);
        ((SelectCruiseUIHandler)this.getHandler()).resetEditCruiseAction();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
        this.sendMessage(I18n._((String)"tutti.exportCruise.action.success", (Object[])new Object[]{cruise.getName(), this.file.getName()}));
    }
}

