/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.content.UpdateDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiErrorHelper;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.swing.AboutPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.updater.ApplicationInfo;
import org.nuiton.util.updater.ApplicationUpdater;

public class ShowAboutAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ShowAboutAction.class);
    protected AboutPanel about;
    protected boolean canUpdate;

    public ShowAboutAction(MainUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        String url = config.getUpdateUrl();
        try {
            TuttiUIUtil.tryToConnectToUpdateUrl(url, I18n.n_((String)"tutti.error.about.could.not.reach.url", (Object[])new Object[0]));
            this.canUpdate = true;
        }
        catch (TuttiBusinessException e) {
            new TuttiErrorHelper(this.getContext()).showErrorDialog(e.getMessage());
            this.canUpdate = false;
        }
        return super.prepareAction();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.about.showInDialog((Frame)this.getUI(), true);
        this.getContext().getSwingSession().add((Component)this.about);
    }

    @Override
    protected void doAction() throws Exception {
        this.about = null;
        ApplicationConfig applicationConfig = this.getContext().getConfig().getApplicationConfig();
        String iconPath = applicationConfig.getOption("application.icon.path");
        String name = "tutti";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        this.about = new AboutPanel();
        this.about.setTitle(I18n._((String)"tutti.about.title", (Object[])new Object[0]));
        this.about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiApplicationConfig config = this.getContext().getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        this.about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        this.about.setIconPath(iconPath);
        this.about.setLicenseFile(licensePath);
        this.about.setThirdpartyFile(thirdPartyPath);
        this.about.buildTopPanel();
        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        File csvFile = new File(config.getI18nDirectory(), "tutti-i18n.csv");
        String translateText = I18n._((String)"tutti.about.translate.content", (Object[])new Object[]{csvFile.toURI().toURL()});
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("edit url: " + url));
                    }
                    TuttiUIUtil.openLink(url);
                }
            }
        });
        this.about.getTabs().add(I18n._((String)"tutti.about.translate.title", (Object[])new Object[0]), translatePane);
        if (this.canUpdate) {
            this.addUpdateTab(config);
        }
        this.about.init();
    }

    protected void addUpdate(Map<String, ApplicationInfo> source, Map<String, ApplicationInfo> target, TuttiApplicationUpdaterCallBack.UpdateType ... types) {
        for (TuttiApplicationUpdaterCallBack.UpdateType type : types) {
            String appName = type.name().toLowerCase();
            ApplicationInfo info = source.get(appName);
            target.put(appName, info);
        }
    }

    protected void addUpdateTab(TuttiApplicationConfig config) {
        File current = config.getTuttiBasedir();
        String url = config.getUpdateUrl();
        ApplicationUpdater up = new ApplicationUpdater();
        Map applicationVersions = up.getVersions(url, current);
        Map dbVersions = up.getVersions(url, config.getDataDirectory());
        TreeMap versions = Maps.newTreeMap();
        this.addUpdate(applicationVersions, versions, UpdateApplicationAction.ALL_APPLICATION_TYPES);
        this.addUpdate(dbVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.DB);
        JScrollPane updatePane = new JScrollPane();
        JEditorPane updateArea = new JEditorPane();
        updateArea.setContentType("text/html");
        updateArea.setEditable(false);
        if (updateArea.getFont() != null) {
            updateArea.setFont(updateArea.getFont().deriveFont(11.0f));
        }
        updateArea.setBorder(null);
        ArrayList params = Lists.newArrayList();
        for (TuttiApplicationUpdaterCallBack.UpdateType type : TuttiApplicationUpdaterCallBack.UpdateType.values()) {
            String appName = type.name().toLowerCase();
            ApplicationInfo info = (ApplicationInfo)versions.get(appName);
            String oldVersion = info.oldVersion;
            String newVersion = info.newVersion;
            String appLabel = type.getLabel();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Module %s, version courante %s, nouvelle version %s", appLabel, oldVersion, newVersion));
            }
            if (newVersion == null) {
                params.add(I18n._((String)"tutti.about.update.app.noup.detail", (Object[])new Object[]{appLabel, oldVersion}));
                continue;
            }
            params.add(I18n._((String)"tutti.about.update.app.up.detail", (Object[])new Object[]{appLabel, oldVersion, newVersion, appName}));
        }
        String updateText = I18n._((String)"tutti.about.update.content", (Object[])new Object[]{url, Joiner.on((String)"\n").join((Iterable)params)});
        updateArea.setText(updateText);
        updatePane.getViewport().add(updateArea);
        updateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (url != null) {
                        TuttiUIUtil.openLink(url);
                    } else {
                        AbstractTuttiAction action;
                        String appType = e.getDescription();
                        TuttiApplicationUpdaterCallBack.UpdateType updateType = TuttiApplicationUpdaterCallBack.UpdateType.valueOf(appType.toUpperCase());
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Open url: " + updateType));
                        }
                        switch (updateType) {
                            case DB: {
                                UpdateDbAction logicAction;
                                action = logicAction = TuttiActionHelper.createLogicAction(ShowAboutAction.this.getHandler(), UpdateDbAction.class);
                                if (ShowAboutAction.this.getContext().isDbExist()) break;
                                action.setActionDescription(I18n._((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
                                break;
                            }
                            default: {
                                UpdateApplicationAction logicAction = TuttiActionHelper.createLogicAction(ShowAboutAction.this.getHandler(), UpdateApplicationAction.class);
                                logicAction.setTypes(updateType);
                                logicAction.setActionDescription(I18n._((String)"tutti.main.action.updateSpecificApplication.tip", (Object[])new Object[]{updateType.getLabel()}));
                                action = logicAction;
                            }
                        }
                        TuttiActionHelper.runAction(ShowAboutAction.this.about.getClose());
                        TuttiActionHelper.runAction(action);
                    }
                }
            }
        });
        this.about.getTabs().add(I18n._((String)"tutti.about.update.title", (Object[])new Object[0]), updatePane);
    }
}

