/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.persistence.hibernate.usertypes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class HibernateByteBlobType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class<?> returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        byte[] object;
        InputStream inputStream = resultSet.getBinaryStream(names[0]);
        if (inputStream == null) {
            object = null;
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                byte[] buffer = new byte[65536];
                int read = -1;
                while ((read = inputStream.read(buffer)) > -1) {
                    outputStream.write(buffer, 0, read);
                }
                outputStream.close();
            }
            catch (IOException exception) {
                throw new HibernateException("Unable to read blob " + names[0], (Throwable)exception);
            }
            object = outputStream.toByteArray();
        }
        return object;
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws SQLException {
        byte[] bytes = (byte[])value;
        if (bytes == null) {
            try {
                statement.setBinaryStream(index, (InputStream)null, 0);
            }
            catch (SQLException exception) {
                Blob nullBlob = null;
                statement.setBlob(index, nullBlob);
            }
        } else {
            statement.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }
}

