/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.RemoveSpeciesSubBatchAction;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

public class RemoveMarineLitterBatchAction
extends AbstractTuttiAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveMarineLitterBatchAction.class);
    protected RemoveSpeciesSubBatchAction removeSpeciesSubBatchAction;
    int rowIndex;

    public RemoveMarineLitterBatchAction(MarineLitterBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        boolean persisted;
        JXTable table = ((MarineLitterBatchUIHandler)this.handler).getTable();
        this.rowIndex = table.getSelectedRow();
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if none is selected");
        MarineLitterBatchTableModel tableModel = ((MarineLitterBatchUIHandler)this.handler).getTableModel();
        MarineLitterBatchRowModel selectedBatch = (MarineLitterBatchRowModel)tableModel.getEntry(this.rowIndex);
        boolean bl = persisted = !TuttiEntities.isNew(selectedBatch);
        if (persisted) {
            String id = selectedBatch.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove marineLitter with id: " + id));
            }
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            persistenceService.deleteMarineLitterBatch(id);
        }
        ((MarineLitterBatchUIHandler)this.handler).removeFromMarineLitterCategoriesUsed(selectedBatch);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((MarineLitterBatchUIHandler)this.handler).getTable();
        MarineLitterBatchTableModel tableModel = ((MarineLitterBatchUIHandler)this.handler).getTableModel();
        tableModel.removeRow(this.rowIndex);
        if (!tableModel.getRows().isEmpty()) {
            AbstractSelectTableAction.doSelectCell((JTable)table, 0, 0);
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }
}

