package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateIndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "individualObservationLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_NUMBER_PATTERN = "individualObservationSizeField.numberPattern";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM = "individualObservationSpeciesComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_NUMBER_PATTERN = "individualObservationWeightField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVYz28bRRSeuLETJyklCYQgWkhDqBIh1i0tVSVT2sStiSPnB7GBQoTK2Duxp6x3l53ZxGkUxJ/AnwB3LkjcOCEOnDlwQRzgwg0hDlwRb2bXu15nN7tOjVKpq3j2ve998+ab92b26z9Rmlno8iPcbiuWrXPaIsra8oMHm7VHpM7vEVa3qMkNCzn/hlIotYPGVW+ccfTyTlm451z3XMFomYZO9C7vfBmNMX6gEdYkhHN0KehRZyxX8V7n26ZtdVA9UmGoX/79V+oL9fOvUgi1TWA3CVOZi/PyZzJcRimqcjQFkfZwTsN6A2hYVG8A3/NirKBhxjZwi3yKPkMjZZQxsQVgHM0nn7LEkP5tk6PFukUwJyVdpXtUtbG2WWPE2sOcGvoK5vVm1TC3sE40jtiupdBdi7SIpXCbc6rYVGH7QE+pGzqHaIphEku6KnXhS5hCPWDDB1acoEohJva7JdOUVDMcjTSxrmrE4ujxGfBYdYL7dNItQxVJaZ8BmXUR2qeS3cMaVTGsMUevBtTmvXAZVcTzvc6gj5CpWcYnIrVL0bOpip+rEHdF2vrOUzDPXdqwnTm6WpkN8HARcE2Tws16vpdp2DQrJqlTwsq4JqCmhPDbLsaaHBTesx7IwkkgsBNqxorR5uiNEEpEpSI7NYJ1ZQUeRapxWCzg2fELhpoLDfU+oY0m95hdSu5TpESDDX8lmtqG3aoR6778EcR9MXza9DGJYhLtIXkIq1eCHtdCPcpEb/BmhROzgC1ch4xRxmk9KuyNfkC68z4XxBldWJPqutqrCTkaFNZEHet1oq2AaGEXoumAvTMqLBXPYYzhPeK/uO6+tdALgbWBzqD4ncEv3UM7KG3ZMAzS3zneTLbhldNGZnvaiACUb/+dmf75u1+/LXb3jmdDTbtaH9R00xL1hVMR+oLTOGxOtdw6NvM7KMuIBn1T9sWLIcQq7msgB/Emhbsi3JVVzJoAkR755fsfZj7+6RxKFdGYZmC1iIV9CWV504IsGJraNu/clYwm9kfh+TT8P8fRsNhUULYPZaE8ggzTa7f0LYvsUtiMF5zq4pI/UKCKAdb+NmGiHQ9zyyZtyNbFkGx5lGvZH/+Zrnxzt5OxIZjB85HmftbSH6IM1TWqE9lv3VYa2l/HTUZs1fBbZlgTRdBGZ8Krh1sl8/J5JyxNWWxzY8swbQDJHbo9TmkQXpBVdXFJoWy5Y9JdDBaXjkKSBpkVQ9K6I/6rEbAVMOxGdOwBt20Lum/LlIq/SmKGE92mMfMagv74sAm9Qsxp3lnquHOGIuznQ2L3cUYxY3gNQxHRRJUqil555TBJ4zgSmSVtSHAp4UR2RTFVTsLmaJwbhlalZlUirw8MWeFw2POSv504+QmQo9cnvovHLUwK9OVUKqKWOGlx9IxTN4RkXSAp+NFOxYDKwpzxMEaJjgT9qWU+XC1dfdxXyuqTZ93B7RVKeVDAQZ28MwiduMDRMok9PCVYkGNd5bwuy9IW5lB64c3U4b37hdL6cvn6w63lavX+9oZQjc1IEZqXXyW7dJTZlwz6ZSyXvD8JzUUUnM4BzBdQcQDbFlB75bM2GNigeDYHUmQEbLR0Ys66ZyOcYQbx+2N7CtHcDBdNzPHZl9IHT744EbF61fXR/xYpKLjaIAQXFSlag/3fhfrvegt+14sA7u2Cz2nhdmEzONVFLG4S4tMM0cWhFy6yky5/yuRXBknW1eHrCdcMGIiPIeI6BncG51dJfEqB/SbHJsQ9Yl0nLUMXGsz3j6u0PO+ggm+eAisgzXxiaXZDRGuu61Yatw5pL9M3+qPg3JR7cp3pjPZk+/ZpsCPzfetUaIGM3+434y5IdM4Dnw7isg43nYyGDwwwRk+9qWKO52pil+mNt45hD4nnWALEUdGrqgemvIX+Ho7zUiyOGP7jBITXEiH8dgJCDhD+A7QA/NuxFwAA";
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateIndividualObservationBatchUI createIndividualObservationBatchTopPanel = this;
    protected CreateIndividualObservationBatchUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "individualObservationLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> individualObservationLengthStepCaracteristicComboBox;
    protected JLabel individualObservationLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "individualObservationSizeField")
    protected NumberEditor individualObservationSizeField;
    protected JLabel individualObservationSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "individualObservationSpeciesComboBox")
    protected BeanFilterableComboBox<Species> individualObservationSpeciesComboBox;
    protected JLabel individualObservationSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "individualObservationWeightField")
    protected NumberEditor individualObservationWeightField;
    protected JLabel individualObservationWeightLabel;
    protected CreateIndividualObservationBatchUIModel model;
    protected JButton saveButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateIndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIndividualObservationBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateIndividualObservationBatchUIHandler handler = new CreateIndividualObservationBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateIndividualObservationBatchUI() {
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateIndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<Caracteristic> getIndividualObservationLengthStepCaracteristicComboBox() {
        return individualObservationLengthStepCaracteristicComboBox;
    }

    public JLabel getIndividualObservationLengthStepCaracteristicLabel() {
        return individualObservationLengthStepCaracteristicLabel;
    }

    public NumberEditor getIndividualObservationSizeField() {
        return individualObservationSizeField;
    }

    public JLabel getIndividualObservationSizeLabel() {
        return individualObservationSizeLabel;
    }

    public BeanFilterableComboBox<Species> getIndividualObservationSpeciesComboBox() {
        return individualObservationSpeciesComboBox;
    }

    public JLabel getIndividualObservationSpeciesLabel() {
        return individualObservationSpeciesLabel;
    }

    public NumberEditor getIndividualObservationWeightField() {
        return individualObservationWeightField;
    }

    public JLabel getIndividualObservationWeightLabel() {
        return individualObservationWeightLabel;
    }

    public CreateIndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(individualObservationSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationSizeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSizeField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationLengthStepCaracteristicLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationLengthStepCaracteristicComboBox), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createIndividualObservationBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createIndividualObservationBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateIndividualObservationBatchUIHandler.class));
    }

    protected void createIndividualObservationLengthStepCaracteristicComboBox() {
        $objectMap.put("individualObservationLengthStepCaracteristicComboBox", individualObservationLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        individualObservationLengthStepCaracteristicComboBox.setName("individualObservationLengthStepCaracteristicComboBox");
        individualObservationLengthStepCaracteristicComboBox.setI18nPrefix("tutti.property.");
        individualObservationLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        individualObservationLengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createIndividualObservationLengthStepCaracteristicLabel() {
        $objectMap.put("individualObservationLengthStepCaracteristicLabel", individualObservationLengthStepCaracteristicLabel = new JLabel());
        
        individualObservationLengthStepCaracteristicLabel.setName("individualObservationLengthStepCaracteristicLabel");
        individualObservationLengthStepCaracteristicLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic"));
        individualObservationLengthStepCaracteristicLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.tip"));
        individualObservationLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
    }

    protected void createIndividualObservationSizeField() {
        $objectMap.put("individualObservationSizeField", individualObservationSizeField = new NumberEditor(this));
        
        individualObservationSizeField.setName("individualObservationSizeField");
        individualObservationSizeField.setProperty("size");
        individualObservationSizeField.setUseFloat(true);
        individualObservationSizeField.setShowReset(true);
    }

    protected void createIndividualObservationSizeLabel() {
        $objectMap.put("individualObservationSizeLabel", individualObservationSizeLabel = new JLabel());
        
        individualObservationSizeLabel.setName("individualObservationSizeLabel");
        individualObservationSizeLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSize"));
        individualObservationSizeLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSize.tip"));
        individualObservationSizeLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
    }

    protected void createIndividualObservationSpeciesComboBox() {
        $objectMap.put("individualObservationSpeciesComboBox", individualObservationSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        individualObservationSpeciesComboBox.setName("individualObservationSpeciesComboBox");
        individualObservationSpeciesComboBox.setI18nPrefix("tutti.property.");
        individualObservationSpeciesComboBox.setProperty("species");
        individualObservationSpeciesComboBox.setShowReset(true);
    }

    protected void createIndividualObservationSpeciesLabel() {
        $objectMap.put("individualObservationSpeciesLabel", individualObservationSpeciesLabel = new JLabel());
        
        individualObservationSpeciesLabel.setName("individualObservationSpeciesLabel");
        individualObservationSpeciesLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies"));
        individualObservationSpeciesLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies.tip"));
        individualObservationSpeciesLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
    }

    protected void createIndividualObservationWeightField() {
        $objectMap.put("individualObservationWeightField", individualObservationWeightField = new NumberEditor(this));
        
        individualObservationWeightField.setName("individualObservationWeightField");
        individualObservationWeightField.setProperty("weight");
        individualObservationWeightField.setUseFloat(true);
        individualObservationWeightField.setShowReset(true);
    }

    protected void createIndividualObservationWeightLabel() {
        $objectMap.put("individualObservationWeightLabel", individualObservationWeightLabel = new JLabel());
        
        individualObservationWeightLabel.setName("individualObservationWeightLabel");
        individualObservationWeightLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight"));
        individualObservationWeightLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight.tip"));
        individualObservationWeightLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateIndividualObservationBatchUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.createIndividualObservationBatch.action.save"));
        saveButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.save.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateIndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        individualObservationSpeciesComboBox.setBeanType(Species.class);
        individualObservationLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        individualObservationSpeciesLabel.setLabelFor(individualObservationSpeciesComboBox);
        individualObservationSpeciesComboBox.setBean(model);
        individualObservationWeightLabel.setLabelFor(individualObservationWeightField);
        individualObservationWeightField.setBean(model);
        individualObservationWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationSizeLabel.setLabelFor(individualObservationSizeField);
        individualObservationSizeField.setBean(model);
        individualObservationSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationLengthStepCaracteristicLabel.setLabelFor(individualObservationLengthStepCaracteristicComboBox);
        individualObservationLengthStepCaracteristicComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createIndividualObservationBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, individualObservationSpeciesLabel, "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
        registerHelpId(_broker, individualObservationWeightLabel, "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        registerHelpId(_broker, individualObservationSizeLabel, "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
        registerHelpId(_broker, individualObservationLengthStepCaracteristicLabel, "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
        registerHelpId(_broker, cancelButton, "tutti.createIndividualObservationBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.createIndividualObservationBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createIndividualObservationBatchTopPanel", createIndividualObservationBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createIndividualObservationSpeciesLabel();
        createIndividualObservationSpeciesComboBox();
        createIndividualObservationWeightLabel();
        createIndividualObservationWeightField();
        createIndividualObservationSizeLabel();
        createIndividualObservationSizeField();
        createIndividualObservationLengthStepCaracteristicLabel();
        createIndividualObservationLengthStepCaracteristicComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of createIndividualObservationBatchTopPanel
        setName("createIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        createIndividualObservationBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                individualObservationWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                individualObservationSizeField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}