package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: OpenDbAction.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/OpenDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * To open existing db.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class OpenDbAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(OpenDbAction.class);

    public OpenDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.SELECT_CRUISE);
        setActionDescription(_("tutti.dbManager.action.openDb.tip"));
    }

    @Override
    public void doAction() throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("Will open db...");
        }
        getContext().setDbLoaded(true);
        getHandler().reloadPersistenceService();

        if (log.isDebugEnabled()) {
            log.debug("Check db context");
        }
        getContext().checkDbContext();

        super.doAction();
    }

    @Override
    public void postSuccessAction() {

        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        sendMessage(_("tutti.flash.info.db.opened", jdbcUrl));

        // make sure title is reloaded
        getUI().getHandler().changeTitle();
    }
}